/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.NoRegionContentAssistProcessor;
import org.hibernate.eclipse.mapper.MapperPlugin;
import org.hibernate.eclipse.mapper.editors.CFGXMLContentAssistProcessor;

public class CFGXMLStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationXML {
    public static IJavaProject findJavaProject(ITextViewer viewer) {
        if (viewer == null) {
            return null;
        }
        IStructuredModel existingModelForRead = StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
        if (existingModelForRead == null) {
            return null;
        }
        IJavaProject javaProject = null;
        try {
            String baseLocation = existingModelForRead.getBaseLocation();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baseLocation);
            IProject project = null;
            if (filePath.segmentCount() > 0) {
                project = root.getProject(filePath.segment(0));
            }
            if (project != null) {
                javaProject = JavaCore.create(project);
            }
        }
        catch (Exception ex) {
            MapperPlugin.getDefault().logException(ex);
        }
        return javaProject;
    }

    public static IJavaProject findJavaProject(IDocument doc) {
        IProject project;
        IProject resource = CFGXMLStructuredTextViewerConfiguration.getProject(doc);
        if (resource != null && (project = resource.getProject()) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IJavaProject findJavaProject(ContentAssistRequest request) {
        IProject project;
        IProject resource = CFGXMLStructuredTextViewerConfiguration.getProject(request);
        if (resource != null && (project = resource.getProject()) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IProject getProject(ContentAssistRequest request) {
        IStructuredDocumentRegion region;
        if (request != null && (region = request.getDocumentRegion()) != null) {
            IStructuredDocument document = region.getParentDocument();
            return CFGXMLStructuredTextViewerConfiguration.getProject((IDocument)document);
        }
        return null;
    }

    public static IProject getProject(IDocument document) {
        IStructuredModel model = null;
        try {
            String baselocation;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && (baselocation = model.getBaseLocation()) != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                Path filePath = new Path(baselocation);
                if (filePath.segmentCount() > 0) {
                    IProject iProject = root.getProject(filePath.segment(0));
                    return iProject;
                }
            }
            return null;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT") {
            processors = new IContentAssistProcessor[]{new CFGXMLContentAssistProcessor()};
        } else if (partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE") {
            processors = new IContentAssistProcessor[]{new NoRegionContentAssistProcessor()};
        }
        return processors;
    }
}

