/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import java.util.Collection;
import javax.swing.tree.TreeNode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ClassNode;
import org.hibernate.console.node.NodeFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class PersistentCollectionNode
extends BaseNode {
    BaseNode virtualNode;
    CollectionType type;
    Type elementType;
    private boolean objectGraph;
    private Object baseObject;
    private Object collectionObject;
    boolean childrenCreated = false;
    private ClassMetadata md;

    public PersistentCollectionNode(NodeFactory factory, BaseNode parent, String name, CollectionType type, ClassMetadata md, CollectionMetadata metadata, Object baseObject, boolean objectGraph) {
        super(factory, parent);
        this.md = md;
        this.type = type;
        this.name = name;
        this.baseObject = baseObject;
        this.objectGraph = objectGraph;
        this.iconName = factory.getIconNameForType((Type)type);
        this.elementType = metadata.getElementType();
        if (!objectGraph) {
            this.virtualNode = factory.createNode(null, this.elementType.getReturnedClass());
        }
    }

    Object initCollectionObject() {
        if (this.collectionObject != null) {
            return this.collectionObject;
        }
        try {
            this.collectionObject = this.md.getPropertyValue(this.baseObject, this.name, EntityMode.POJO);
        }
        catch (HibernateException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not access property value");
            iae.initCause(e);
            throw iae;
        }
        return this.collectionObject;
    }

    public String getHQL() {
        return "";
    }

    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        if (this.objectGraph) {
            return super.getChildAt(childIndex);
        }
        return this.virtualNode.getChildAt(childIndex);
    }

    public int getChildCount() {
        this.checkChildren();
        if (this.objectGraph) {
            return super.getChildCount();
        }
        return this.virtualNode.getChildCount();
    }

    public int getIndex(TreeNode node) {
        this.checkChildren();
        if (this.objectGraph) {
            return super.getIndex(node);
        }
        return this.virtualNode.getIndex(node);
    }

    public boolean isLeaf() {
        this.checkChildren();
        if (this.objectGraph) {
            return super.isLeaf();
        }
        return this.virtualNode.isLeaf();
    }

    protected void checkChildren() {
        if (!this.childrenCreated && this.objectGraph) {
            this.initCollectionObject();
            int idx = 0;
            if (!this.type.isArrayType()) {
                for (Object element : (Collection)this.collectionObject) {
                    this.children.add(this.createNode(idx++, element, this.elementType));
                }
            } else {
                Object[] os = (Object[])this.collectionObject;
                int i = 0;
                while (i < os.length) {
                    Object element = os[i];
                    this.children.add(this.createNode(idx++, element, this.elementType));
                    ++i;
                }
            }
            this.childrenCreated = true;
        }
    }

    private Object createNode(int idx, Object element, Type type) {
        return new ClassNode(this.factory, this, type.getReturnedClass().getName(), this.factory.getMetaData(type.getReturnedClass()), element, this.objectGraph);
    }

    public String renderLabel(boolean b) {
        return String.valueOf(PersistentCollectionNode.getLabel(this.getName(), b)) + " : " + PersistentCollectionNode.getLabel(this.type.getReturnedClass().getName(), b) + "<" + PersistentCollectionNode.getLabel(this.elementType.getReturnedClass().getName(), b) + ">";
    }

    public Type getType() {
        return this.type;
    }
}

