/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.parts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.RoundLineBorder;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TitleFigure;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TitleLabel;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ExpandeableShapeEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.Messages;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ResourceManager;

public class OrmShapeEditPart
extends ExpandeableShapeEditPart {
    public void addNotify() {
        super.addNotify();
        if (((OrmShape)this.getModel()).isHiden()) {
            int i = this.figure.getPreferredSize().width;
            ((TitleFigure)this.figure).setHidden(true);
            ((TitleLabel)((Object)this.figure.getChildren().get(0))).setHidden(true);
            this.figure.setSize(i, -1);
            this.refresh();
        }
    }

    protected IFigure createFigure() {
        if (this.getModel() instanceof OrmShape) {
            TitleFigure figure = new TitleFigure();
            figure.setLayoutManager((LayoutManager)new ToolbarLayout());
            TitleLabel label = new TitleLabel();
            String text = "";
            Object element = this.getCastedModel().getOrmElement();
            if (element instanceof RootClass) {
                text = ormLabelProvider.getText((Object)((PersistentClass)element));
            } else if (element instanceof Table) {
                text = ormLabelProvider.getText((Object)((Table)element));
            } else if (element instanceof Subclass) {
                text = ormLabelProvider.getText((Object)((Subclass)element));
            }
            label.setText(text);
            label.setIcon(ormLabelProvider.getImage(this.getCastedModel().getOrmElement()));
            FontData[] fontData = Display.getCurrent().getSystemFont().getFontData();
            fontData[0].setStyle(1);
            label.setFont(ResourceManager.getInstance().getFont(fontData[0]));
            label.setBackgroundColor(this.getColor());
            label.setIcon(ormLabelProvider.getImage(this.getCastedModel().getOrmElement()));
            label.setLabelAlignment(1);
            label.setBorder((Border)new MarginBorder(1, 2, 1, 2));
            figure.add((IFigure)label, -2);
            label.setOpaque(true);
            figure.setBackgroundColor(this.getBackgroundColor());
            RoundLineBorder border = new RoundLineBorder();
            border.setColor(ResourceManager.getInstance().getColor(new RGB(160, 160, 160)));
            figure.setBorder((Border)border);
            figure.setSize(-1, -1);
            return figure;
        }
        throw new IllegalArgumentException();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && this.getModel() instanceof OrmShape) {
            ((OrmShape)this.getModel()).refreshHiden();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("OrmShape.Location".equals(prop)) {
            this.refreshVisuals();
            ((OrmDiagram)this.getParent().getModel()).setDirty(true);
        } else if ("set hiden".equals(prop)) {
            int i = this.figure.getPreferredSize().width;
            ((TitleFigure)this.figure).setHidden((Boolean)evt.getNewValue());
            ((TitleLabel)((Object)this.figure.getChildren().get(0))).setHidden((Boolean)evt.getNewValue());
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.figure.setSize(i, -1);
            } else {
                this.figure.setSize(-1, -1);
            }
            this.refresh();
            ((OrmDiagram)this.getParent().getModel()).setDirty(true);
        } else {
            super.propertyChange(evt);
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = null;
        if (this.getModel() instanceof OrmShape) {
            bounds = new Rectangle(((OrmShape)this.getModel()).getLocation(), this.getFigure().getSize());
        }
        if (bounds != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), bounds);
        }
    }

    protected Color getBackgroundColor() {
        Object element = this.getCastedModel().getOrmElement();
        if (element instanceof PersistentClass || element instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(0, 0, 0));
        }
        if (element instanceof Table || element instanceof Property) {
            return ResourceManager.getInstance().getColor(new RGB(Integer.parseInt(Messages.Colors_DatabaseColumnR), Integer.parseInt(Messages.Colors_DatabaseColumnG), Integer.parseInt(Messages.Colors_DatabaseColumnB)));
        }
        throw new IllegalArgumentException();
    }
}

