/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.RGB;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TitleLabel;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.TopLineBorder;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ExpandeableShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ConnectionEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ResourceManager;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ShapeEditPart;

public class ExpandeableShapeEditPart
extends ShapeEditPart {
    protected ArrayList<OrmShape> referenceList = new ArrayList();

    protected IFigure createFigure() {
        if (this.getModel() instanceof Shape) {
            TitleLabel label = new TitleLabel();
            label.setText(ormLabelProvider.getText(this.getElement()));
            label.setBackgroundColor(this.getColor());
            label.setIcon(ormLabelProvider.getImage(this.getElement()));
            label.setLabelAlignment(1);
            label.setOpaque(true);
            TopLineBorder border = new TopLineBorder(1, 2 + this.getCastedModel().getIndent(), 1, 2);
            border.setColor(this.getOrmShapeEditPart().getColor());
            label.setBorder((Border)border);
            return label;
        }
        throw new IllegalArgumentException();
    }

    public void activate() {
        super.activate();
        if (this.getClass().equals(ExpandeableShapeEditPart.class) && !((ExpandeableShape)this.getModel()).isReferenceVisible()) {
            ((ExpandeableShape)this.getModel()).refHide = true;
            ((ExpandeableShape)this.getModel()).refreshReferences(this.getViewer().getContents().getModel());
            ((ExpandeableShape)this.getModel()).getOrmDiagram().setDirty(false);
        }
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            ((ExpandeableShape)this.getModel()).refreshReferences(this.getViewer().getContents().getModel());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("show selection".equals(prop)) {
            if (this.getFigure().getChildren().size() > 0) {
                ((IFigure)this.getFigure().getChildren().get(0)).setBackgroundColor(this.getSelectionColor());
                ((IFigure)this.getFigure().getChildren().get(0)).setForegroundColor(ResourceManager.getInstance().getColor(new RGB(255, 255, 255)));
            } else {
                this.getFigure().setBackgroundColor(this.getSelectionColor());
                this.getFigure().setForegroundColor(ResourceManager.getInstance().getColor(new RGB(255, 255, 255)));
            }
        } else if ("hide selection".equals(prop)) {
            if (this.getFigure().getChildren().size() > 0) {
                ((IFigure)this.getFigure().getChildren().get(0)).setBackgroundColor(this.getColor());
                ((IFigure)this.getFigure().getChildren().get(0)).setForegroundColor(ResourceManager.getInstance().getColor(new RGB(0, 0, 0)));
            } else {
                this.getFigure().setBackgroundColor(this.getColor());
                this.getFigure().setForegroundColor(ResourceManager.getInstance().getColor(new RGB(0, 0, 0)));
            }
        } else if ("show references".equals(prop)) {
            this.refreshReferences(this.getCastedModel(), ((ExpandeableShape)this.getCastedModel()).isReferenceVisible());
            ((TitleLabel)this.getFigure()).setHidden(!((ExpandeableShape)this.getCastedModel()).isReferenceVisible());
        } else {
            super.propertyChange(evt);
        }
    }

    protected void refreshReference(ExpandeableShape shape, boolean visible) {
        Object element;
        OrmShape refShape = shape.getReference();
        if (refShape == null) {
            return;
        }
        if (!this.isReferencesCorrect(refShape)) {
            return;
        }
        OrmEditPart refPart = (OrmEditPart)((Object)this.getViewer().getEditPartRegistry().get(refShape));
        if (refPart != null) {
            refPart.getFigure().setVisible(visible);
            this.setLinksVisible(refPart, visible);
        }
        if ((element = refShape.getOrmElement()) instanceof RootClass) {
            RootClass rc = (RootClass)element;
            Table table = rc.getTable();
            OrmShape tableShape = refShape.getOrmDiagram().getShape(table);
            OrmEditPart tablePart = (OrmEditPart)((Object)this.getViewer().getEditPartRegistry().get(tableShape));
            if (tablePart != null && this.isTableCanBeInvisible(tablePart, visible)) {
                tablePart.getFigure().setVisible(visible);
                this.setLinksVisible(tablePart, visible);
            }
        }
        this.referenceList.add(refShape);
        int i = 0;
        while (i < refShape.getChildren().size()) {
            if (refShape.getChildren().get(i) instanceof ExpandeableShape) {
                this.refreshReference((ExpandeableShape)refShape.getChildren().get(i), visible);
            }
            ++i;
        }
        this.referenceList.remove(refShape);
        shape.getOrmDiagram().update();
    }

    protected void refreshReferences(Shape shape, boolean visible) {
        OrmEditPart shapePart = (OrmEditPart)((Object)this.getViewer().getEditPartRegistry().get(shape));
        int i = 0;
        while (i < shape.getSourceConnections().size()) {
            Connection link = shape.getSourceConnections().get(i);
            OrmShape refShape = link.getTarget().getOrmShape();
            if (refShape != null && this.isReferencesCorrect(refShape)) {
                OrmEditPart refPart = (OrmEditPart)((Object)this.getViewer().getEditPartRegistry().get(refShape));
                if (refPart != null && this.isShapeCanBeInvisible(shapePart, refPart, visible)) {
                    refPart.getFigure().setVisible(visible);
                    this.setLinksVisible(refPart, visible);
                }
                this.referenceList.add(shape.getOrmShape());
                this.refreshReferences(refShape, visible);
                this.referenceList.remove(shape.getOrmShape());
            }
            ++i;
        }
        this.referenceList.add(shape.getOrmShape());
        i = 0;
        while (i < shape.getChildren().size()) {
            this.refreshReferences((Shape)shape.getChildren().get(i), visible);
            ++i;
        }
        this.referenceList.remove(shape.getOrmShape());
        shape.getOrmDiagram().update();
    }

    private boolean isTableCanBeInvisible(OrmEditPart tablePart, boolean visible) {
        if (visible) {
            return true;
        }
        int i = 0;
        while (i < tablePart.getTargetConnections().size()) {
            ConnectionEditPart link = (ConnectionEditPart)tablePart.getTargetConnections().get(i);
            if (link.getFigure().isVisible()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isShapeCanBeInvisible(OrmEditPart source, OrmEditPart target, boolean visible) {
        if (visible) {
            return true;
        }
        int i = 0;
        while (i < target.getTargetConnections().size()) {
            ConnectionEditPart link = (ConnectionEditPart)target.getTargetConnections().get(i);
            if (link.getFigure().isVisible() && link.getSource() != source) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isReferencesCorrect(OrmShape shape) {
        if (shape == null) {
            return false;
        }
        int i = 0;
        while (i < this.referenceList.size()) {
            if (shape.equals(this.referenceList.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setLinksVisible(OrmEditPart editPart, boolean flag) {
        ConnectionEditPart link;
        int i = 0;
        while (i < editPart.getSourceConnections().size()) {
            link = (ConnectionEditPart)editPart.getSourceConnections().get(i);
            if (this.isLinkCanBeVisible(link, flag)) {
                link.getFigure().setVisible(flag);
            }
            ++i;
        }
        i = 0;
        while (i < editPart.getTargetConnections().size()) {
            link = (ConnectionEditPart)editPart.getTargetConnections().get(i);
            if (this.isLinkCanBeVisible(link, flag)) {
                link.getFigure().setVisible(flag);
            }
            ++i;
        }
        i = 0;
        while (i < editPart.getChildren().size()) {
            OrmEditPart child = (OrmEditPart)((Object)editPart.getChildren().get(i));
            this.setLinksVisible(child, flag);
            ++i;
        }
    }

    private boolean isLinkCanBeVisible(ConnectionEditPart link, boolean visible) {
        if (!visible) {
            return true;
        }
        if (!((OrmEditPart)link.getSource()).getFigure().isVisible()) {
            return false;
        }
        if (!((OrmEditPart)link.getTarget()).getFigure().isVisible()) {
            return false;
        }
        if (!this.validateShape((Shape)((OrmEditPart)link.getSource()).getModel())) {
            return false;
        }
        return this.validateShape((Shape)((OrmEditPart)link.getTarget()).getModel());
    }

    private boolean validateShape(Shape shape) {
        OrmShape ormShape;
        if (!shape.getClass().equals(OrmShape.class) && (ormShape = shape.getOrmShape()) != null && ormShape.isHiden()) {
            return false;
        }
        ExpandeableShape expanableShape = shape.getExtendeableShape();
        return expanableShape == null || shape.equals(expanableShape) || expanableShape.getClass().equals(OrmShape.class) || expanableShape.isReferenceVisible();
    }

    protected List getModelChildren() {
        return ((ExpandeableShape)this.getModel()).getChildren();
    }
}

