/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.VisualEditor;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.AutoLayout;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IDiagramInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.ILinkInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.command.ShapeSetConstraintCommand;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialOrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmShapeEditPart;
import org.jboss.tools.hibernate.ui.view.views.HibernateUtils;

class DiagramEditPart
extends OrmEditPart
implements PropertyChangeListener {
    DiagramEditPart() {
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        return f;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("refresh".equals(prop)) {
            this.refresh();
            this.autolayout();
        } else if ("dirty".equals(prop)) {
            ((VisualEditor)((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart()).refreshDirty();
        }
    }

    public void restore() {
        OrmShape ormShape2;
        boolean dirty = this.getCastedModel().isDirty();
        HashMap hashMap = this.getCastedModel().getCloneElements();
        String[] childrenLocations = this.getCastedModel().getChildrenLocations();
        int tempPoint = 1;
        int point = 1;
        int pointX = this.calculateTableLocation();
        int i = 0;
        while (i < childrenLocations.length) {
            String string;
            if (childrenLocations[i].indexOf(64) != -1 && childrenLocations[i].indexOf(59) != -1 && (ormShape2 = (OrmShape)hashMap.remove(string = childrenLocations[i].substring(0, childrenLocations[i].indexOf(64)))) != null) {
                string = childrenLocations[i].substring(childrenLocations[i].indexOf(64) + 1);
                String[] xy = string.split(";");
                if (xy.length > 1) {
                    try {
                        ormShape2.setLocation(new Point(Integer.parseInt(xy[0]), Integer.parseInt(xy[1])));
                    }
                    catch (NumberFormatException e) {
                        VisualEditorPlugin.getDefault().logError(e);
                    }
                }
                if (xy.length > 2 && new Boolean(xy[2]).booleanValue()) {
                    ormShape2.refreshHiden();
                }
                if ((tempPoint = ormShape2.getLocation().y + this.getChildrenFigurePreferredHeight(ormShape2) + 20) > point) {
                    point = tempPoint;
                }
            }
            ++i;
        }
        RootClass[] ormElements = this.getCastedModel().getOrmElements();
        int i2 = 0;
        while (i2 < childrenLocations.length) {
            Table table;
            RootClass persistentClass = ormElements[i2];
            ormShape2 = (OrmShape)hashMap.remove(persistentClass.getEntityName());
            if (ormShape2 != null) {
                ormShape2.setLocation(new Point(20, 20));
                tempPoint = 40 + this.getChildrenFigurePreferredHeight(ormShape2);
            }
            if ((ormShape2 = (OrmShape)hashMap.remove(HibernateUtils.getTableName((Table)(table = persistentClass.getTable())))) != null) {
                ormShape2.setLocation(new Point(pointX, 20));
                point = 40 + this.getChildrenFigurePreferredHeight(ormShape2);
            }
            if (tempPoint > point) {
                point = tempPoint;
            }
            ++i2;
        }
        Object[] objects = hashMap.keySet().toArray();
        int i3 = 0;
        while (i3 < objects.length) {
            ormShape2 = (OrmShape)hashMap.get(objects[i3]);
            if (ormShape2 != null && (ormShape2.getOrmElement() instanceof RootClass || ormShape2.getOrmElement() instanceof SpecialOrmShape)) {
                ormShape2.setLocation(new Point(20, point));
                tempPoint = point + this.getChildrenFigurePreferredHeight(ormShape2) + 20;
                Component component = (Component)((Collection)((SpecialRootClass)((Object)ormShape2.getOrmElement())).getProperty().getValue()).getElement();
                Table ownerTable = component.getOwner().getTable();
                ormShape2 = (OrmShape)hashMap.remove(HibernateUtils.getTableName((Table)ownerTable));
                if (tempPoint > point) {
                    point = tempPoint;
                }
            }
            ++i3;
        }
        for (OrmShape ormShape2 : hashMap.values()) {
            if (!(ormShape2.getOrmElement() instanceof Table)) continue;
            ormShape2.setLocation(new Point(pointX, point));
            point = point + this.getChildrenFigurePreferredHeight(ormShape2) + 20;
        }
        this.getCastedModel().setDirty(dirty);
    }

    private OrmDiagram getCastedModel() {
        return (OrmDiagram)this.getModel();
    }

    private int getChildrenFigurePreferredHeight(OrmShape ormShape) {
        int i = 0;
        while (i < this.getChildren().size()) {
            GraphicalEditPart part = (GraphicalEditPart)this.getChildren().get(i);
            if (ormShape.equals(part.getModel())) {
                return part.getFigure().getPreferredSize().height;
            }
            ++i;
        }
        return 0;
    }

    private int calculateTableLocation() {
        int j = 0;
        int i = 0;
        while (i < this.getFigure().getChildren().size()) {
            IFigure figure = (IFigure)this.getFigure().getChildren().get(i);
            if (figure.getPreferredSize().width > j) {
                j = figure.getPreferredSize().width;
            }
            ++i;
        }
        return j + 120;
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            if (!this.getCastedModel().isLoadSuccessfull()) {
                this.autolayout();
                this.getCastedModel().setDirty(false);
            }
        }
    }

    public void autolayout() {
        DiagramInfo process = new DiagramInfo(this.getCastedModel());
        AutoLayout layout = new AutoLayout();
        layout.setGridStep("5");
        layout.setOverride(true);
        layout.setProcess(process);
    }

    public void setToFront(EditPart ep) {
        int index = this.getChildren().indexOf(ep);
        if (index == -1) {
            return;
        }
        if (index != this.getChildren().size() - 1) {
            this.reorderChild(ep, this.getChildren().size() - 1);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    class DiagramElementInfo
    implements IItemInfo {
        OrmShape element;
        ArrayList links = new ArrayList();

        public DiagramElementInfo(OrmShape element) {
            LinkInfo link;
            this.element = element;
            int i = 0;
            while (i < element.getSourceConnections().size()) {
                link = new LinkInfo(element.getSourceConnections().get(i));
                this.addLink(link);
                ++i;
            }
            int j = 0;
            while (j < element.getChildren().size()) {
                Shape child = (Shape)element.getChildren().get(j);
                if (child.getSourceConnections().size() == 0) {
                    link = new LinkInfo(this.getID());
                    this.addLink(link);
                }
                int i2 = 0;
                while (i2 < child.getSourceConnections().size()) {
                    link = new LinkInfo(child.getSourceConnections().get(i2));
                    this.addLink(link);
                    ++i2;
                }
                ++j;
            }
        }

        public String getID() {
            return this.element.toString();
        }

        public boolean isComment() {
            return false;
        }

        public int[] getShape() {
            int[] shape = new int[4];
            shape[0] = this.element.getLocation().x;
            shape[1] = this.element.getLocation().y;
            OrmShapeEditPart part = (OrmShapeEditPart)DiagramEditPart.this.getViewer().getEditPartRegistry().get(this.element);
            if (part != null) {
                IFigure fig = part.getFigure();
                shape[2] = fig.getPreferredSize().width;
                shape[3] = fig.getPreferredSize().height;
            } else {
                shape[2] = 6000;
                shape[3] = 1000;
            }
            return shape;
        }

        public ILinkInfo[] getLinks() {
            return this.links.toArray(new ILinkInfo[0]);
        }

        public void addLink(ILinkInfo link) {
            this.links.add(link);
        }

        public void setShape(int[] s) {
            this.element.setLocation(new Point(s[0], s[1]));
        }
    }

    class DiagramInfo
    implements IDiagramInfo {
        ArrayList items = new ArrayList();
        OrmDiagram diagram;

        public DiagramInfo(OrmDiagram diagram) {
            this.diagram = diagram;
            int i = 0;
            while (i < diagram.getChildren().size()) {
                OrmShapeEditPart part = (OrmShapeEditPart)DiagramEditPart.this.getViewer().getEditPartRegistry().get(diagram.getChildren().get(i));
                if (part != null && part.getFigure().isVisible()) {
                    DiagramElementInfo item = new DiagramElementInfo((OrmShape)diagram.getChildren().get(i));
                    this.addItem(item);
                }
                ++i;
            }
        }

        public IItemInfo[] getItems() {
            return this.items.toArray(new IItemInfo[0]);
        }

        public void addItem(IItemInfo item) {
            this.items.add(item);
        }
    }

    class LinkInfo
    implements ILinkInfo {
        Connection link = null;
        String id = null;

        public LinkInfo(Connection link) {
            this.link = link;
        }

        public LinkInfo(String id) {
            this.id = id;
        }

        public String getTargetID() {
            if (this.id != null) {
                return this.id;
            }
            if (this.link.getTarget() != null) {
                return this.link.getTarget().toString();
            }
            return "";
        }

        public void setLinkShape(int[] vs) {
        }
    }

    private static class ShapesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ShapesXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof OrmShapeEditPart && constraint instanceof Rectangle) {
                return new ShapeSetConstraintCommand((OrmShape)child.getModel(), request, ((Rectangle)constraint).getLocation());
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }
    }
}

