/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.editors.figures.RoundPolylineConnection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.GEFRootEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.ResourceManager;

class ConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
EditPartListener {
    ConnectionEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.addEditPartListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ShapesSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        RoundPolylineConnection connection = new RoundPolylineConnection();
        connection.setForegroundColor(this.getColor());
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        connection.setVisible(!this.getCastedModel().isHiden());
        return connection;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("show selection".equals(property)) {
            this.getFigure().setForegroundColor(this.getSelectionColor());
        } else if ("hide selection".equals(property)) {
            this.getFigure().setForegroundColor(this.getColor());
        } else if ("set hiden".equals(property)) {
            this.getFigure().setVisible((Boolean)event.getNewValue() == false);
        }
    }

    private Connection getCastedModel() {
        return (Connection)this.getModel();
    }

    private Color getColor() {
        Object element = this.getCastedModel().getTarget().getOrmElement();
        if (element instanceof RootClass || element instanceof Subclass) {
            return ResourceManager.getInstance().getColor(new RGB(210, 155, 100));
        }
        if (element instanceof Column || element instanceof Table || element instanceof Property) {
            return ResourceManager.getInstance().getColor(new RGB(160, 160, 160));
        }
        throw new IllegalArgumentException();
    }

    private Color getSelectionColor() {
        if (this.getCastedModel().getTarget().getOrmElement() instanceof RootClass || this.getCastedModel().getTarget().getOrmElement() instanceof Subclass) {
            return ResourceManager.getInstance().getColor(new RGB(112, 161, 99));
        }
        if (this.getCastedModel().getTarget().getOrmElement() instanceof Column || this.getCastedModel().getTarget().getOrmElement() instanceof Table || this.getCastedModel().getTarget().getOrmElement() instanceof Component) {
            return ResourceManager.getInstance().getColor(new RGB(66, 173, 247));
        }
        throw new IllegalArgumentException();
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((GEFRootEditPart)this.getParent()).setToFront(this);
        }
    }

    private class ShapesSelectionEditPolicy
    extends SelectionEditPolicy {
        private ShapesSelectionEditPolicy() {
        }

        protected void hideSelection() {
            ConnectionEditPart.this.getCastedModel().hideSelection();
        }

        protected void showSelection() {
            ConnectionEditPart.this.getCastedModel().showSelection();
        }
    }
}

