/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ExpandeableShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;

public class OrmShape
extends ExpandeableShape {
    public static final String SET_HIDEN = "set hiden";
    public static final String LOCATION_PROP = "OrmShape.Location";
    private Point location = new Point(0, 0);
    protected boolean hiden = false;

    public OrmShape(Object ioe) {
        super(ioe);
        this.generate();
    }

    protected void generate() {
        block24: {
            Object ormElement;
            block25: {
                Shape bodyOrmShape;
                Iterator iterator;
                KeyValue identifier;
                block23: {
                    Component component;
                    KeyValue identifier2;
                    ormElement = this.getOrmElement();
                    if (!(ormElement instanceof RootClass)) break block23;
                    RootClass rootClass = (RootClass)this.getOrmElement();
                    Property identifierProperty = rootClass.getIdentifierProperty();
                    if (identifierProperty != null) {
                        this.getChildren().add(new Shape(identifierProperty));
                    }
                    if ((identifier2 = rootClass.getIdentifier()) instanceof Component && (component = (Component)identifier2).isEmbedded()) {
                        Iterator iterator2 = ((Component)identifier2).getPropertyIterator();
                        while (iterator2.hasNext()) {
                            Property property = (Property)iterator2.next();
                            this.getChildren().add(new Shape(property));
                        }
                    }
                    Iterator iterator3 = rootClass.getPropertyIterator();
                    while (iterator3.hasNext()) {
                        Shape bodyOrmShape2;
                        Property field = (Property)iterator3.next();
                        if (field.isBackRef()) continue;
                        if (!field.isComposite()) {
                            boolean typeIsAccessible = true;
                            if (field.getValue().isSimpleValue() && ((SimpleValue)field.getValue()).isTypeSpecified()) {
                                try {
                                    field.getValue().getType();
                                }
                                catch (Exception exception) {
                                    typeIsAccessible = false;
                                }
                            }
                            bodyOrmShape2 = field.getValue().isSimpleValue() && !((SimpleValue)field.getValue()).isTypeSpecified() ? new Shape(field) : (typeIsAccessible && field.getValue() instanceof Collection ? new ComponentShape(field) : (typeIsAccessible && field.getValue().getType().isEntityType() ? new ExpandeableShape(field) : new Shape(field)));
                            this.getChildren().add(bodyOrmShape2);
                            continue;
                        }
                        bodyOrmShape2 = new ExpandeableShape(field);
                        this.getChildren().add(bodyOrmShape2);
                    }
                    break block24;
                }
                if (!(ormElement instanceof Subclass)) break block25;
                RootClass rootClass = ((Subclass)ormElement).getRootClass();
                Property identifierProperty = rootClass.getIdentifierProperty();
                if (identifierProperty != null) {
                    this.getChildren().add(new Shape(identifierProperty));
                }
                if ((identifier = rootClass.getIdentifier()) instanceof Component) {
                    iterator = ((Component)identifier).getPropertyIterator();
                    while (iterator.hasNext()) {
                        Property property = (Property)iterator.next();
                        this.getChildren().add(new Shape(property));
                    }
                }
                iterator = rootClass.getPropertyIterator();
                while (iterator.hasNext()) {
                    Property field = (Property)iterator.next();
                    if (field.isBackRef()) continue;
                    if (!field.isComposite()) {
                        boolean typeIsAccessible = true;
                        if (field.getValue().isSimpleValue() && ((SimpleValue)field.getValue()).isTypeSpecified()) {
                            try {
                                field.getValue().getType();
                            }
                            catch (Exception exception) {
                                typeIsAccessible = false;
                            }
                        }
                        bodyOrmShape = typeIsAccessible && field.getValue().isSimpleValue() ? new Shape(field) : (typeIsAccessible && field.getValue().getType().isEntityType() ? new ExpandeableShape(field) : (typeIsAccessible && field.getValue().getType().isCollectionType() ? new ComponentShape(field) : new Shape(field)));
                        this.getChildren().add(bodyOrmShape);
                        continue;
                    }
                    bodyOrmShape = new ExpandeableShape(field);
                    this.getChildren().add(bodyOrmShape);
                }
                Iterator iter = ((Subclass)ormElement).getPropertyIterator();
                while (iter.hasNext()) {
                    Property property = (Property)iter.next();
                    if (property.isBackRef()) continue;
                    if (!property.isComposite()) {
                        boolean typeIsAccessible = true;
                        if (property.getValue().isSimpleValue() && ((SimpleValue)property.getValue()).isTypeSpecified()) {
                            try {
                                property.getValue().getType();
                            }
                            catch (Exception exception) {
                                typeIsAccessible = false;
                            }
                        }
                        bodyOrmShape = typeIsAccessible && property.getValue().getType().isEntityType() ? new ExpandeableShape(property) : (typeIsAccessible && property.getValue().getType().isCollectionType() ? new ComponentShape(property) : new Shape(property));
                    } else {
                        bodyOrmShape = new ExpandeableShape(property);
                    }
                    this.getChildren().add(bodyOrmShape);
                }
                break block24;
            }
            if (!(ormElement instanceof Table)) break block24;
            Iterator iterator = ((Table)this.getOrmElement()).getColumnIterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                Shape bodyOrmShape = new Shape(column);
                this.getChildren().add(bodyOrmShape);
            }
        }
    }

    public Shape getChild(Column ormElement) {
        Shape shape = null;
        for (Shape child : this.getChildren()) {
            Object childElement = child.getOrmElement();
            if (!(childElement instanceof Column) || !ormElement.getName().equals(((Column)childElement).getName())) continue;
            return child;
        }
        return shape;
    }

    public Shape getChild(Property ormElement) {
        Shape shape = null;
        if (ormElement != null) {
            for (Shape child : this.getChildren()) {
                Object childElement = child.getOrmElement();
                if (!(childElement instanceof Property) || !ormElement.getName().equals(((Property)childElement).getName())) continue;
                return child;
            }
        }
        return shape;
    }

    protected void setHidden(boolean hiden) {
        super.setHidden(hiden);
        int i = 0;
        while (i < this.getChildren().size()) {
            ((Shape)this.getChildren().get(i)).setHidden(hiden);
            ++i;
        }
    }

    public void refreshHiden() {
        this.hiden = !this.hiden;
        this.setElementHidden(this, this.hiden);
        this.firePropertyChange(SET_HIDEN, null, new Boolean(this.hiden));
    }

    public void refreshReference() {
        this.firePropertyChange(SET_HIDEN, null, new Boolean(this.hiden));
    }

    private void setElementHidden(ModelElement element, boolean hidden) {
        int i = 0;
        while (i < element.getChildren().size()) {
            ((Shape)element.getChildren().get(i)).setHidden(hidden);
            this.setElementHidden((ModelElement)element.getChildren().get(i), hidden);
            ++i;
        }
    }

    public Point getLocation() {
        return this.location.getCopy();
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    public boolean isHiden() {
        return this.hiden;
    }
}

