/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.command;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;

public class ShapeSetConstraintCommand
extends Command {
    private final Point newLocation;
    private Point oldLocation;
    private final ChangeBoundsRequest request;
    private final OrmShape shape;

    public ShapeSetConstraintCommand(OrmShape shape, ChangeBoundsRequest req, Point newLocation) {
        if (shape == null || req == null || newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
        this.request = req;
        this.newLocation = newLocation.getCopy();
        this.setLabel("move");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type);
    }

    public void execute() {
        this.oldLocation = this.shape.getLocation();
        this.redo();
    }

    public void redo() {
        this.shape.setLocation(this.newLocation);
    }

    public void undo() {
        this.shape.setLocation(this.oldLocation);
    }
}

