/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IDiagramInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.ILinkInfo;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.Groups;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.Item;
import org.jboss.tools.hibernate.ui.veditor.editors.autolayout.impl.LayuotConstants;

public class Items {
    protected LayuotConstants constants;
    protected IDiagramInfo process;
    protected Item[] items;
    protected Map paths = new HashMap();
    protected Groups groups = new Groups();
    protected boolean override = false;

    public void setConstants(LayuotConstants constants) {
        this.constants = constants;
        this.groups.setConstants(constants);
    }

    public void setOverride(boolean b) {
        this.override = b;
    }

    public void setProcess(IDiagramInfo process) {
        this.process = process;
        try {
            this.load();
        }
        catch (Exception e) {
            VisualEditorPlugin.getDefault().logError(e);
        }
    }

    private void load() {
        this.initItems();
        if (this.isAllSet()) {
            return;
        }
        this.buildBinds();
        this.groups.load(this.items);
        this.print();
    }

    private void initItems() {
        IItemInfo[] is = this.process.getItems();
        this.items = new Item[is.length];
        int i = 0;
        while (i < is.length) {
            Item item;
            this.items[i] = item = new Item();
            this.paths.put(is[i].getID(), item);
            item.n = i;
            item.itemInfo = is[i];
            int[] shape = is[i].getShape();
            if (!this.override && shape != null && shape.length > 1) {
                item.x = shape[0];
                item.y = shape[1];
                if (item.x != 0 && item.y != 0) {
                    item.isSet = true;
                }
                item.ix = item.x / this.constants.deltaX;
                item.iy = item.y / this.constants.deltaY;
                if (item.ix < 0) {
                    item.ix = 0;
                }
                if (item.iy < 0) {
                    item.iy = 0;
                }
                if (item.ix >= Groups.FX) {
                    item.ix = Groups.FX - 1;
                }
                if (item.iy >= Groups.FY) {
                    item.iy = Groups.FY - 1;
                }
            }
            this.initItem(item);
            ++i;
        }
    }

    protected void initItem(Item item) {
    }

    public ILinkInfo[] getOutput(IItemInfo itemObject) {
        return itemObject.getLinks();
    }

    private boolean isAllSet() {
        int i = 0;
        while (i < this.items.length) {
            if (!this.items[i].isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void buildBinds() {
        int i = 0;
        while (i < this.items.length) {
            ILinkInfo[] iLinkInfoArray;
            if (this.items[i].itemInfo instanceof ILinkInfo) {
                ILinkInfo[] iLinkInfoArray2 = new ILinkInfo[1];
                iLinkInfoArray = iLinkInfoArray2;
                iLinkInfoArray2[0] = (ILinkInfo)((Object)this.items[i].itemInfo);
            } else {
                iLinkInfoArray = this.getOutput(this.items[i].itemInfo);
            }
            ILinkInfo[] ts = iLinkInfoArray;
            int j = 0;
            while (j < ts.length) {
                Item item2;
                String target = ts[j].getTargetID();
                if (target != null && target.length() != 0 && (item2 = (Item)this.paths.get(target)) != null) {
                    if (this.items[i].isComment()) {
                        item2.addComment(this.items[i].n);
                        this.items[i].isOwned = true;
                    } else if (item2.weight >= 0) {
                        item2.addInput(this.items[i].n, ts[j]);
                        this.items[i].addOutput(item2.n);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void print() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].print();
            ++i;
        }
    }
}

