/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.actions;

import java.util.Set;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.Property;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.VisualEditor;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.view.views.ObjectEditorInput;

public class OpenMappingAction
extends SelectionAction {
    public static String ACTION_ID = "org.jboss.tools.hibernate.ui.veditor.editors.actions.open.mapping";

    public OpenMappingAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText("Open Mapping File");
        this.setImageDescriptor(VisualEditorPlugin.getImageDescriptor("icons/mapping.gif"));
    }

    public void run() {
        ObjectEditorInput objectEditorInput = (ObjectEditorInput)((VisualEditor)this.getWorkbenchPart()).getEditorInput();
        ConsoleConfiguration consoleConfiguration = objectEditorInput.getConfiguration();
        VisualEditor part = (VisualEditor)this.getWorkbenchPart();
        Set selectedElements = part.getSelectedElements();
        for (Object selection : selectedElements) {
            if (selection instanceof Property && ((Property)selection).getPersistentClass() instanceof SpecialRootClass) {
                Property compositSel = (Property)selection;
                Property parentProperty = ((SpecialRootClass)((Property)selection).getPersistentClass()).getProperty();
                try {
                    org.hibernate.eclipse.console.actions.OpenMappingAction.run((Property)compositSel, (Property)parentProperty, (ConsoleConfiguration)consoleConfiguration);
                }
                catch (Exception e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't find or open mapping file.", (Throwable)e);
                }
                continue;
            }
            if (selection instanceof SpecialRootClass) {
                selection = ((SpecialRootClass)((Object)selection)).getProperty();
            }
            try {
                org.hibernate.eclipse.console.actions.OpenMappingAction.run(selection, (ConsoleConfiguration)consoleConfiguration);
            }
            catch (Exception e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't find or open mapping file.", (Throwable)e);
            }
        }
    }

    protected boolean calculateEnabled() {
        VisualEditor part = (VisualEditor)this.getWorkbenchPart();
        return part.getSelectedElements().size() > 0;
    }
}

