/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.actions;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.hibernate.ui.veditor.editors.VisualEditor;

public class ExportImageAction
extends Action {
    public static final String ACTION_ID = "Export as Image";
    private VisualEditor editor;

    public ExportImageAction(VisualEditor editor) {
        this.editor = editor;
        this.setId(ACTION_ID);
        this.setText(ACTION_ID);
        this.setImageDescriptor(ImageDescriptor.createFromFile(VisualEditor.class, (String)"icons/export.png"));
    }

    public void run() {
        FileDialog saveDialog = new FileDialog(this.editor.getSite().getShell(), 8192);
        saveDialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.bmp"});
        saveDialog.setFilterNames(new String[]{"PNG format (*.png)", "JPEG format (*.jpg)", "Bitmap format (*.bmp)"});
        String filePath = saveDialog.open();
        if (filePath == null || filePath.trim().length() == 0) {
            return;
        }
        IFigure fig = ((ScalableFreeformRootEditPart)this.editor.getEditPartViewer().getRootEditPart()).getLayer((Object)"Printable Layers");
        try {
            int imageType = 0;
            if (filePath.toLowerCase().endsWith(".jpg")) {
                imageType = 4;
            } else if (filePath.toLowerCase().endsWith(".png")) {
                imageType = 5;
            }
            byte[] imageData = this.createImage(fig, imageType);
            FileOutputStream outStream = new FileOutputStream(filePath);
            outStream.write(imageData);
            outStream.flush();
            outStream.close();
        }
        catch (Throwable e) {
            MessageDialog.openInformation((Shell)this.editor.getSite().getShell(), (String)"Error", (String)("Failed to export image: " + e.getMessage()));
            return;
        }
    }

    private byte[] createImage(IFigure figure, int format) throws Exception {
        Exception error;
        ByteArrayOutputStream result;
        block15: {
            Display device = this.editor.getEditPartViewer().getControl().getDisplay();
            Rectangle r = figure.getBounds();
            result = new ByteArrayOutputStream();
            Image image = null;
            GC gc = null;
            SWTGraphics g = null;
            error = null;
            try {
                try {
                    image = new Image((Device)device, r.width, r.height);
                    gc = new GC((Drawable)image);
                    g = new SWTGraphics(gc);
                    g.translate(r.x * -1, r.y * -1);
                    figure.paint((Graphics)g);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    imageLoader.save((OutputStream)result, format);
                }
                catch (Exception ex) {
                    error = ex;
                    if (g != null) {
                        g.dispose();
                    }
                    if (gc != null) {
                        gc.dispose();
                    }
                    if (image != null) {
                        image.dispose();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (g != null) {
                    g.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
                throw throwable;
            }
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        if (error != null) {
            throw error;
        }
        return result.toByteArray();
    }
}

