/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.StickyNoteFigure;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LogicLabelEditManager
extends DirectEditManager {
    Font scaledFont;

    public LogicLabelEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        StickyNoteFigure stickyNote = (StickyNoteFigure)this.getEditPart().getFigure();
        String initialLabelText = stickyNote.getText();
        this.getCellEditor().setValue((Object)initialLabelText);
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        stickyNote.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 66);
    }
}

