/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.pde;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.examples.pde.PluginEdge;

public class PluginNode
extends Node {
    NodeList closure;

    public PluginNode(Object data) {
        super(data);
    }

    public NodeList getClosure() {
        if (this.closure == null) {
            this.closure = new NodeList();
            int i = 0;
            while (i < this.incoming.size()) {
                PluginEdge e = (PluginEdge)this.incoming.getEdge(i);
                if (!e.exported) {
                    // empty if block
                }
                this.closure.addAll((Collection)((PluginNode)e.source).getClosure());
                this.closure.add((Object)e.source);
                ++i;
            }
        }
        return this.closure;
    }

    public void prune(DirectedGraph g) {
        Collections.sort(this.incoming, new Comparator(){

            public int compare(Object o1, Object o2) {
                PluginNode n1 = (PluginNode)((PluginEdge)((Object)o1)).source;
                PluginNode n2 = (PluginNode)((PluginEdge)((Object)o2)).source;
                return n1.getClosure().size() - n2.getClosure().size();
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        int i = 0;
        while (i < this.incoming.size()) {
            boolean remove = false;
            PluginEdge e = (PluginEdge)((Object)this.incoming.get(i));
            PluginNode n1 = (PluginNode)e.source;
            int j = i + 1;
            while (j < this.incoming.size()) {
                PluginNode n2 = (PluginNode)this.incoming.getEdge((int)j).source;
                if (n2.getClosure().contains((Object)n1)) {
                    remove = true;
                }
                ++j;
            }
            if (remove) {
                g.edges.remove((Object)e);
                this.incoming.remove((Object)e);
                e.source.outgoing.remove((Object)e);
                continue;
            }
            ++i;
        }
    }
}

