/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.pde;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.internal.graph.HorizontalPlacement;
import org.eclipse.draw2d.internal.graph.InitialRankSolver;
import org.eclipse.draw2d.internal.graph.LocalOptimizer;
import org.eclipse.draw2d.internal.graph.MinCross;
import org.eclipse.draw2d.internal.graph.PopulateRanks;
import org.eclipse.draw2d.internal.graph.RankAssigmentSolver;
import org.eclipse.draw2d.internal.graph.TightSpanningTreeSolver;
import org.eclipse.draw2d.internal.graph.VerticalPlacement;
import org.eclipse.gef.examples.pde.DirectedGraphDemo;
import org.eclipse.gef.examples.pde.PluginEdge;
import org.eclipse.gef.examples.pde.PluginNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class PluginDependenciesView
extends ViewPart {
    FigureCanvas canvas;
    Map map = new HashMap();
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite comp) {
        PluginNode n;
        IPluginDescriptor desc;
        this.canvas = new FigureCanvas(comp);
        Label dummy = new Label();
        dummy.setBorder((Border)new MarginBorder(3));
        dummy.setFont(this.canvas.getFont());
        IPluginDescriptor[] plugins = Platform.getPluginRegistry().getPluginDescriptors();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ToggleButton");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz.toString();
        DirectedGraph g = new DirectedGraph();
        g.setDefaultPadding(new Insets(20));
        PluginNode ECLIPSE = new PluginNode("Eclipse");
        g.nodes.add((Object)ECLIPSE);
        EdgeList subgraphRoots = new EdgeList();
        int i = 0;
        while (i < plugins.length) {
            desc = plugins[i];
            if (!this.ignoreDescriptor(desc)) {
                n = new PluginNode(desc.getLabel());
                dummy.setText(desc.getLabel());
                n.width = dummy.getPreferredSize().width;
                g.nodes.add((Object)n);
                this.put(desc, n);
            }
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            desc = plugins[i];
            if (!this.ignoreDescriptor(desc)) {
                IPluginPrerequisite[] prereqs = null;
                try {
                    prereqs = desc.getPluginPrerequisites();
                }
                catch (Exception e) {
                    String id = desc.getUniqueIdentifier();
                    System.out.println("Error getting pre-requisties of " + id);
                    e.printStackTrace();
                }
                if (prereqs != null) {
                    int j = 0;
                    while (j < prereqs.length) {
                        if (prereqs[j] != null) {
                            Node target = this.get(desc);
                            Node source = this.get(prereqs[j].getUniqueIdentifier());
                            if (target != null && source != null) {
                                g.edges.add((Object)new PluginEdge(source, target, prereqs[j].isExported()));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            desc = plugins[i];
            if (!this.ignoreDescriptor(desc)) {
                n = this.get(desc);
                if (n.incoming.isEmpty()) {
                    if (n.outgoing.isEmpty()) {
                        g.nodes.remove((Object)n);
                    } else {
                        PluginEdge e = new PluginEdge(ECLIPSE, n, true);
                        e.weight = 0;
                        subgraphRoots.add((Object)e);
                        g.edges.add((Object)e);
                    }
                }
            }
            ++i;
        }
        new InitialRankSolver().visit(g);
        int r = 1;
        while (true) {
            boolean work = false;
            int i2 = 0;
            while (i2 < g.nodes.size()) {
                Node nod = g.nodes.getNode(i2);
                if (nod instanceof PluginNode) {
                    PluginNode n2 = (PluginNode)g.nodes.getNode(i2);
                    if (n2.rank == r) {
                        n2.prune(g);
                        work = true;
                    }
                }
                ++i2;
            }
            if (!work && r != 8) break;
            ++r;
        }
        System.out.println("Pruned graph contains " + g.edges.size() + " edges.");
        new TightSpanningTreeSolver().visit(g);
        new RankAssigmentSolver().visit(g);
        new PopulateRanks().visit(g);
        new VerticalPlacement().visit(g);
        int i3 = 0;
        while (i3 < subgraphRoots.size()) {
            Edge e = subgraphRoots.getEdge(i3);
            g.removeEdge(e);
            ++i3;
        }
        g.removeNode((Node)ECLIPSE);
        new MinCross().visit(g);
        new LocalOptimizer().visit(g);
        new HorizontalPlacement().visit(g);
        i3 = 0;
        while (i3 < g.edges.size()) {
            Edge e = (Edge)g.edges.get(i3);
            System.out.println(e.source + " -> " + e.target + ";");
            ++i3;
        }
        this.canvas.setContents((IFigure)DirectedGraphDemo.buildGraph(g));
    }

    private boolean ignoreDescriptor(IPluginDescriptor desc) {
        return desc.getUniqueIdentifier().indexOf("org.eclipse.gef") != -1;
    }

    void put(IPluginDescriptor desc, Node n) {
        this.map.put(desc.getUniqueIdentifier(), n);
    }

    Node get(String ID) {
        return (Node)this.map.get(ID);
    }

    Node get(IPluginDescriptor desc) {
        return (Node)this.map.get(desc.getUniqueIdentifier());
    }

    public void setFocus() {
        this.canvas.setFocus();
    }
}

