/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoutingAnimator;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LEDFigure;
import org.eclipse.gef.examples.logicdesigner.model.SimpleOutput;
import org.eclipse.gef.examples.logicdesigner.model.Wire;

public class FigureFactory {
    public static PolylineConnection createNewBendableWire(Wire wire) {
        PolylineConnection conn = new PolylineConnection();
        conn.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
        return conn;
    }

    public static PolylineConnection createNewWire(Wire wire) {
        PolygonDecoration arrow;
        PolylineConnection conn = new PolylineConnection();
        conn.addRoutingListener((RoutingListener)RoutingAnimator.getDefault());
        if (wire == null || wire.getSource() instanceof SimpleOutput) {
            arrow = null;
        } else {
            arrow = new PolygonDecoration();
            arrow.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
            arrow.setScale(5.0, 2.5);
        }
        conn.setSourceDecoration(arrow);
        if (wire == null || wire.getTarget() instanceof SimpleOutput) {
            arrow = null;
        } else {
            arrow = new PolygonDecoration();
            arrow.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
            arrow.setScale(5.0, 2.5);
        }
        conn.setTargetDecoration((RotatableDecoration)arrow);
        return conn;
    }

    public static IFigure createNewLED() {
        return new LEDFigure();
    }

    public static IFigure createNewCircuit() {
        CircuitFigure f = new CircuitFigure();
        return f;
    }
}

