/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.instr;

import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.ICorePreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.JavaRuntime;

public class DefaultInstrumentationFilter {
    private final ICorePreferences preferences;

    public DefaultInstrumentationFilter(ICorePreferences preferences) {
        this.preferences = preferences;
    }

    public IClassFiles[] filter(IClassFiles[] classfiles, ILaunchConfiguration configuration) throws CoreException {
        String filter;
        ArrayList<IClassFiles> list = new ArrayList<IClassFiles>(Arrays.asList(classfiles));
        if (this.preferences.getDefaultInstrumentationSourceFoldersOnly()) {
            this.sourceFoldersOnly(list);
        }
        if (this.preferences.getDefaultInstrumentationSameProjectOnly()) {
            this.sameProjectOnly(list, configuration);
        }
        if ((filter = this.preferences.getDefaultInstrumentationFilter()) != null && filter.length() > 0) {
            this.matchingPathsOnly(list, filter);
        }
        return list.toArray(new IClassFiles[list.size()]);
    }

    private void sourceFoldersOnly(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            IClassFiles c = (IClassFiles)i.next();
            if (!c.isBinary()) continue;
            i.remove();
        }
    }

    private void sameProjectOnly(List list, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                if (this.isSameProject((IClassFiles)i.next(), javaProject)) continue;
                i.remove();
            }
        }
    }

    private boolean isSameProject(IClassFiles classfiles, IJavaProject javaProject) {
        IPackageFragmentRoot[] roots = classfiles.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (javaProject.equals(roots[i].getJavaProject())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void matchingPathsOnly(List list, String filter) {
        String[] matchStrings = filter.split(",");
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (this.isPathMatch((IClassFiles)i.next(), matchStrings)) continue;
            i.remove();
        }
    }

    private boolean isPathMatch(IClassFiles classfiles, String[] matchStrings) {
        IPackageFragmentRoot[] roots = classfiles.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            String path = roots[i].getPath().toString();
            int j = 0;
            while (j < matchStrings.length) {
                if (path.indexOf(matchStrings[j]) != -1) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

