/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.internal.core.analysis.SignatureResolver;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MethodLocator {
    private static final Object AMBIGUOUS = new Object();
    private final Map indexParamCount = new HashMap();
    private final Map indexParamSignature = new HashMap();
    private final IType type;

    public MethodLocator(IType type) throws JavaModelException {
        this.type = type;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.addToIndex(methods[i]);
            ++i;
        }
    }

    public IMethod findMethod(String name, String signature) {
        Object value;
        if (name.equals("<init>")) {
            name = this.type.getElementName();
        }
        if ((value = this.indexParamCount.get(this.createParamCountKey(name, signature))) == AMBIGUOUS) {
            return (IMethod)this.indexParamSignature.get(this.createParamSignatureKey(name, signature));
        }
        return (IMethod)value;
    }

    private void addToIndex(IMethod method) throws JavaModelException {
        String paramCountKey = this.createParamCountKey(method);
        Object existing = this.indexParamCount.get(paramCountKey);
        if (existing == null) {
            this.indexParamCount.put(paramCountKey, method);
            return;
        }
        if (existing != AMBIGUOUS) {
            this.indexParamCount.put(paramCountKey, AMBIGUOUS);
            IMethod m = (IMethod)existing;
            this.indexParamSignature.put(this.createParamSignatureKey(m), m);
        }
        this.indexParamSignature.put(this.createParamSignatureKey(method), method);
    }

    private String createParamCountKey(IMethod method) {
        return String.valueOf(method.getElementName()) + "@" + method.getParameterTypes().length;
    }

    private String createParamCountKey(String name, String fullSignature) {
        return String.valueOf(name) + "@" + Signature.getParameterCount((String)fullSignature);
    }

    private String createParamSignatureKey(IMethod method) throws JavaModelException {
        return String.valueOf(method.getElementName()) + "#" + SignatureResolver.getParameters(method);
    }

    private String createParamSignatureKey(String name, String fullSignature) {
        return String.valueOf(name) + "#" + SignatureResolver.getParameters(fullSignature);
    }
}

