/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.instr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class InstrMarker {
    private static final String MARKERFILE = ".emma_instrumented";

    public static void mark(IPath path) throws CoreException {
        IFile marker;
        IFolder folder = InstrMarker.getFolder(path);
        if (folder != null && !(marker = folder.getFile(MARKERFILE)).exists()) {
            marker.create(InstrMarker.getMarkerContent(), true, null);
            marker.setDerived(true);
        }
    }

    public static boolean isMarked(IPath path) {
        IFolder folder = InstrMarker.getFolder(path);
        return folder == null ? false : folder.getFile(MARKERFILE).exists();
    }

    private static IFolder getFolder(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        return res instanceof IFolder ? (IFolder)res : null;
    }

    private static InputStream getMarkerContent() {
        String text = "Class files instrumented at " + new Date();
        return new ByteArrayInputStream(text.getBytes());
    }
}

