/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;

public class HashtableOfObject
implements Cloneable {
    public char[][] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    protected int threshold;

    public HashtableOfObject() {
        this(13);
    }

    public HashtableOfObject(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new char[extraRoom][];
        this.valueTable = new Object[extraRoom];
    }

    public void clear() {
        int i = this.keyTable.length;
        while (--i >= 0) {
            this.keyTable[i] = null;
            this.valueTable[i] = null;
        }
        this.elementSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObject result = (HashtableOfObject)super.clone();
        result.elementSize = this.elementSize;
        result.threshold = this.threshold;
        int length = this.keyTable.length;
        result.keyTable = new char[length][];
        System.arraycopy(this.keyTable, 0, result.keyTable, 0, length);
        length = this.valueTable.length;
        result.valueTable = new Object[length];
        System.arraycopy(this.valueTable, 0, result.valueTable, 0, length);
        return result;
    }

    public boolean containsKey(char[] key) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = this.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                return true;
            }
            if (++index != length) continue;
            index = 0;
        }
        return false;
    }

    public Object get(char[] key) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = this.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    protected int hashCode(char[] key) {
        int hash;
        int length = key.length;
        int n = hash = length == 0 ? 31 : key[0];
        if (length < 8) {
            int i = length;
            while (--i > 0) {
                hash = hash * 31 + key[i];
            }
        } else {
            int i = length - 1;
            int last = i > 16 ? i - 16 : 0;
            while (i > last) {
                hash = hash * 31 + key[i];
                i -= 2;
            }
        }
        return hash & Integer.MAX_VALUE;
    }

    public Object put(char[] key, Object value) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = this.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    public void putUnsafely(char[] key, Object value) {
        int length = this.keyTable.length;
        int index = this.hashCode(key) % length;
        while (this.keyTable[index] != null) {
            if (++index != length) continue;
            index = 0;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    public Object removeKey(char[] key) {
        char[] currentKey;
        int length = this.keyTable.length;
        int index = this.hashCode(key) % length;
        int keyLength = key.length;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.length == keyLength && CharOperation.equals(currentKey, key)) {
                Object value = this.valueTable[index];
                --this.elementSize;
                this.keyTable[index] = null;
                this.valueTable[index] = null;
                this.rehash();
                return value;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    protected void rehash() {
        HashtableOfObject newHashtable = new HashtableOfObject(this.elementSize * 2);
        int i = this.keyTable.length;
        while (--i >= 0) {
            char[] currentKey = this.keyTable[i];
            if (currentKey == null) continue;
            newHashtable.putUnsafely(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "";
        int i = 0;
        int length = this.valueTable.length;
        while (i < length) {
            Object object = this.valueTable[i];
            if (object != null) {
                s = String.valueOf(s) + new String(this.keyTable[i]) + " -> " + object.toString() + "\n";
            }
            ++i;
        }
        return s;
    }
}

