/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import edu.rice.cs.plt.tuple.Option;
import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.StatementExpression;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAllocation
extends PrimaryExpression
implements StatementExpression {
    private Option<List<TypeName>> typeArgs;
    private ReferenceTypeName creationType;
    private List<Expression> arguments;

    public SimpleAllocation(Option<List<TypeName>> targs, ReferenceTypeName tp, List<? extends Expression> args) {
        this(targs, tp, args, SourceInfo.NONE);
    }

    public SimpleAllocation(ReferenceTypeName tp, List<? extends Expression> args) {
        this(Option.none(), tp, args, SourceInfo.NONE);
    }

    public SimpleAllocation(ReferenceTypeName tp, List<? extends Expression> args, SourceInfo si) {
        this(Option.none(), tp, args, si);
    }

    public SimpleAllocation(Option<List<TypeName>> targs, ReferenceTypeName tp, List<? extends Expression> args, SourceInfo si) {
        super(si);
        if (tp == null || targs == null) {
            throw new IllegalArgumentException();
        }
        this.typeArgs = targs;
        this.creationType = tp;
        this.arguments = args == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(args);
    }

    public Option<List<TypeName>> getTypeArgs() {
        return this.typeArgs;
    }

    public void setTypeArgs(List<TypeName> targs) {
        this.typeArgs = Option.wrap(targs);
    }

    public void setTypeArgs(Option<List<TypeName>> targs) {
        if (targs == null) {
            throw new IllegalArgumentException();
        }
        this.typeArgs = targs;
    }

    public ReferenceTypeName getCreationType() {
        return this.creationType;
    }

    public void setCreationType(ReferenceTypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.creationType = t;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<? extends Expression> l) {
        this.arguments = l == null ? new ArrayList<Expression>(0) : new ArrayList<Expression>(l);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getTypeArgs() + " " + this.getClass().getName() + ": " + this.getCreationType() + " " + this.getArguments() + ")";
    }
}

