/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.Declaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDeclaration
extends Declaration {
    private TypeName type;
    private String name;
    private Expression initializer;

    public FieldDeclaration(ModifierSet mods, TypeName type, String name, Expression init) {
        this(mods, type, name, init, SourceInfo.NONE);
    }

    public FieldDeclaration(ModifierSet mods, TypeName type, String name, Expression init, SourceInfo si) {
        super(mods, si);
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.type = type;
        this.name = name;
        this.initializer = init;
        if (type instanceof ArrayTypeName && this.initializer instanceof ArrayInitializer) {
            ((ArrayInitializer)this.initializer).setElementType(((ArrayTypeName)type).getElementType());
        }
    }

    public TypeName getType() {
        return this.type;
    }

    public void setType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.type = t;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression e) {
        this.initializer = e;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getModifiers() + " " + this.getType() + " " + this.getName() + " " + this.getInitializer() + ")";
    }
}

