/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Utilities {
    public static volatile boolean TEST_MODE = false;
    public static final String JGOODIES_PACKAGE = "com.jgoodies.looks";

    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.clearEventQueue(true);
    }

    public static void clearEventQueue(boolean newEvents) {
        assert (!EventQueue.isDispatchThread());
        EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        do {
            try {
                EventQueue.invokeAndWait(LambdaUtil.NO_OP);
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        } while (newEvents && null != q.peekEvent());
    }

    public static void show(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaScrollableDialog(null, "Debug Message", "Debug Message from Utilities.show():", msg, false).show();
            }
        });
    }

    public static void showDebug(String msg) {
        Utilities.showMessageBox(msg, "Debug Message");
    }

    public static void showMessageBox(final String msg, final String title) {
        if (TEST_MODE) {
            System.out.println(title + ": " + msg);
        } else {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    new DrJavaScrollableDialog(null, title, "Message:", msg, false).show();
                }
            });
        }
    }

    public static void showStackTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaScrollableDialog(null, "Stack Trace", "Stack Trace:", StringOps.getStackTrace(t), false).show();
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            int ch;
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            StringBuilder sb = new StringBuilder();
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            s = sb.toString();
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static AbstractAction createDelegateAction(String newName, final Action delegate) {
        return new AbstractAction(newName){

            public void actionPerformed(ActionEvent ae) {
                delegate.actionPerformed(ae);
            }
        };
    }

    public static boolean isPlasticLaf() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf != null && laf.getClass().getName().startsWith(JGOODIES_PACKAGE);
    }

    public static boolean isPlasticLaf(String name) {
        return name != null && name.startsWith(JGOODIES_PACKAGE);
    }

    public static void setPopupLoc(Window popup, Component owner) {
        GraphicsDevice[] gs;
        Rectangle frameRect = popup.getBounds();
        Point ownerLoc = null;
        Dimension ownerSize = null;
        if (owner != null && owner.isVisible()) {
            ownerLoc = owner.getLocation();
            ownerSize = owner.getSize();
        } else {
            GraphicsDevice[] dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            Rectangle rec = dev[0].getDefaultConfiguration().getBounds();
            ownerLoc = rec.getLocation();
            ownerSize = rec.getSize();
        }
        Point loc = new Point(ownerLoc.x + (ownerSize.width - frameRect.width) / 2, ownerLoc.y + (ownerSize.height - frameRect.height) / 2);
        frameRect.setLocation(loc);
        GraphicsConfiguration gcBest = null;
        int gcBestArea = -1;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle isect = frameRect.intersection(gc.getBounds());
            int gcArea = isect.width * isect.height;
            if (gcArea <= gcBestArea) continue;
            gcBest = gc;
            gcBestArea = gcArea;
        }
        Rectangle screenRect = gcBest.getBounds();
        Dimension screenSize = screenRect.getSize();
        Dimension frameSize = popup.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frameRect.setSize(frameSize);
        loc = new Point(ownerLoc.x + (ownerSize.width - frameRect.width) / 2, ownerLoc.y + (ownerSize.height - frameRect.height) / 2);
        frameRect.setLocation(loc);
        if (frameRect.x < screenRect.x) {
            frameRect.x = screenRect.x;
        }
        if (frameRect.x + frameRect.width > screenRect.x + screenRect.width) {
            frameRect.x = screenRect.x + screenRect.width - frameRect.width;
        }
        if (frameRect.y < screenRect.y) {
            frameRect.y = screenRect.y;
        }
        if (frameRect.y + frameRect.height > screenRect.y + screenRect.height) {
            frameRect.y = screenRect.y + screenRect.height - frameRect.height;
        }
        popup.setSize(frameRect.getSize());
        popup.setLocation(frameRect.getLocation());
    }

    public static PropertyChangeListener enableDisableWith(Action observable, final Action observer) {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("enabled")) {
                    observer.setEnabled((Boolean)e.getNewValue());
                }
            }
        };
        observable.addPropertyChangeListener(pcl);
        return pcl;
    }

    public static int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }
}

