/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.text;

import java.util.regex.Pattern;

public class Bracket {
    private final Pattern _left;
    private final Pattern _right;
    private final boolean _nests;
    public static final Bracket PARENTHESES = Bracket.literal("(", ")", true);
    public static final Bracket SQUARE_BRACKETS = Bracket.literal("[", "]", true);
    public static final Bracket BRACES = Bracket.literal("{", "}", true);
    public static final Bracket ANGLE_BRACKETS = Bracket.literal("<", ">", true);
    public static final Bracket QUOTES = Bracket.literal("\"", "\"", false);
    public static final Bracket APOSTROPHES = Bracket.literal("'", "'", false);
    public static final Bracket C_LINE_COMMENT = new Bracket("//", "\\r\\n|\\n|\\r", false);
    public static final Bracket PERL_LINE_COMMENT = new Bracket("#", "\\r\\n|\\n|\\r", false);
    public static final Bracket C_BLOCK_COMMENT = Bracket.literal("/*", "*/", false);
    public static final Bracket ML_BLOCK_COMMENT = Bracket.literal("(*", "*)", true);

    public Bracket(String leftRegex, String rightRegex, boolean nests) {
        this._left = Pattern.compile(leftRegex);
        this._right = Pattern.compile(rightRegex);
        this._nests = nests;
    }

    public Pattern left() {
        return this._left;
    }

    public Pattern right() {
        return this._right;
    }

    public boolean nests() {
        return this._nests;
    }

    public static Bracket literal(String leftLiteral, String rightLiteral, boolean nests) {
        return new Bracket(Pattern.quote(leftLiteral), Pattern.quote(rightLiteral), nests);
    }
}

