/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.BinaryMappedIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMappedIterable<T1, T2, R>
extends AbstractIterable<R>
implements SizedIterable<R>,
OptimizedLastIterable<R>,
Composite,
Serializable {
    private final Iterable<? extends T1> _source1;
    private final Iterable<? extends T2> _source2;
    private final Lambda2<? super T1, ? super T2, ? extends R> _map;

    public BinaryMappedIterable(Iterable<? extends T1> source1, Iterable<? extends T2> source2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        this._source1 = source1;
        this._source2 = source2;
        this._map = map;
    }

    public BinaryMappedIterator<T1, T2, R> iterator() {
        return new BinaryMappedIterator<T1, T2, R>(this._source1.iterator(), this._source2.iterator(), this._map);
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._source1, this._source2) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._source1, this._source2) + 1;
    }

    @Override
    public boolean isEmpty() {
        return IterUtil.isEmpty(this._source1);
    }

    @Override
    public int size() {
        return IterUtil.sizeOf(this._source1);
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._source1, bound);
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._source1);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._source1);
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public R last() {
        return this._map.value(IterUtil.last(this._source1), IterUtil.last(this._source2));
    }

    public static <T1, T2, R> BinaryMappedIterable<T1, T2, R> make(Iterable<? extends T1> source1, Iterable<? extends T2> source2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        return new BinaryMappedIterable<T1, T2, R>(source1, source2, map);
    }

    public static <T1, T2, R> SnapshotIterable<R> makeSnapshot(Iterable<? extends T1> source1, Iterable<? extends T2> source2, Lambda2<? super T1, ? super T2, ? extends R> map) {
        return new SnapshotIterable(new BinaryMappedIterable<T1, T2, R>(source1, source2, map));
    }
}

