/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectReader;
import edu.rice.cs.plt.io.DirectWriter;
import edu.rice.cs.plt.io.ExpandingCharBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class LinkedReaderAndWriter {
    private final DirectReader _linkedReader;
    private final DirectWriter _linkedWriter;
    private long _readIndex = 0L;
    private boolean _eof = false;
    private long _writeIndex = 0L;

    public LinkedReaderAndWriter(final Reader r, final Writer w) {
        final ExpandingCharBuffer buffer = new ExpandingCharBuffer();
        final DirectReader fromBuffer = buffer.reader();
        final DirectWriter toBuffer = buffer.writer();
        this._linkedReader = new DirectReader(){

            public int read(char[] cbuf, int offset, int chars) throws IOException {
                int read = 0;
                if (!buffer.isEmpty()) {
                    int bufferReadResult = fromBuffer.read(cbuf, offset, chars);
                    if (bufferReadResult < 0) {
                        throw new IllegalStateException("Unexpected negative result from ExpandingCharBuffer read");
                    }
                    if (bufferReadResult > 0) {
                        read += bufferReadResult;
                        chars -= bufferReadResult;
                    }
                }
                if (buffer.isEmpty() && chars >= 0) {
                    int readResult = r.read(cbuf, offset + read, chars);
                    if (readResult < 0) {
                        LinkedReaderAndWriter.this._eof = true;
                        return read > 0 ? read : readResult;
                    }
                    read += readResult;
                    chars -= readResult;
                    LinkedReaderAndWriter.this._readIndex += readResult;
                }
                return read;
            }

            public void close() throws IOException {
                r.close();
            }

            public boolean ready() throws IOException {
                return r.ready();
            }
        };
        this._linkedWriter = new DirectWriter(){

            public void write(char[] cbuf, int offset, int chars) throws IOException {
                long newIndex = LinkedReaderAndWriter.this._writeIndex + (long)chars;
                while (newIndex > LinkedReaderAndWriter.this._readIndex) {
                    if (LinkedReaderAndWriter.this._eof) {
                        LinkedReaderAndWriter.this._readIndex = newIndex;
                        continue;
                    }
                    int bufferWriteResult = toBuffer.write(r, (int)(newIndex - LinkedReaderAndWriter.this._readIndex));
                    if (bufferWriteResult < 0) {
                        LinkedReaderAndWriter.this._eof = true;
                        continue;
                    }
                    LinkedReaderAndWriter.this._readIndex += bufferWriteResult;
                }
                w.write(cbuf, offset, chars);
                LinkedReaderAndWriter.this._writeIndex = newIndex;
            }

            public void close() throws IOException {
                w.close();
            }

            public void flush() throws IOException {
                w.flush();
            }
        };
    }

    public DirectReader reader() {
        return this._linkedReader;
    }

    public DirectWriter writer() {
        return this._linkedWriter;
    }
}

