/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.Log;
import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.debug.ThreadSnapshot;

public class StandardLog
implements Log {
    private static final String[] EMPTY = new String[0];
    private final LogSink _sink;

    public StandardLog(LogSink sink) {
        this._sink = sink;
    }

    public void log() {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), EMPTY, EMPTY));
    }

    public void log(String message) {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), message, EMPTY, EMPTY));
    }

    public void log(Throwable t) {
        this._sink.logError(new LogSink.ErrorMessage(new ThreadSnapshot(), t));
    }

    public void log(String message, Throwable t) {
        this._sink.logError(new LogSink.ErrorMessage(new ThreadSnapshot(), message, t));
    }

    public void logEnd() {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), EMPTY, EMPTY));
    }

    public void logEnd(String message) {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), message, EMPTY, EMPTY));
    }

    public void logEnd(String name, Object value) {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), new String[]{name}, new Object[]{value}));
    }

    public void logEnd(String message, String name, Object value) {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), message, new String[]{name}, new Object[]{value}));
    }

    public void logEnd(String[] names, Object ... values) {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), names, values));
    }

    public void logEnd(String message, String[] names, Object ... values) {
        this._sink.logEnd(new LogSink.EndMessage(new ThreadSnapshot(), message, names, values));
    }

    public void logStack() {
        this._sink.logStack(new LogSink.StackMessage(new ThreadSnapshot()));
    }

    public void logStack(String message) {
        this._sink.logStack(new LogSink.StackMessage(new ThreadSnapshot(), message));
    }

    public void logStart() {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), EMPTY, EMPTY));
    }

    public void logStart(String message) {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), message, EMPTY, EMPTY));
    }

    public void logStart(String name, Object value) {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), new String[]{name}, new Object[]{value}));
    }

    public void logStart(String message, String name, Object value) {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), message, new String[]{name}, new Object[]{value}));
    }

    public void logStart(String[] names, Object ... values) {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), names, values));
    }

    public void logStart(String message, String[] names, Object ... values) {
        this._sink.logStart(new LogSink.StartMessage(new ThreadSnapshot(), message, names, values));
    }

    public void logValue(String name, Object value) {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), new String[]{name}, new Object[]{value}));
    }

    public void logValue(String message, String name, Object value) {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), message, new String[]{name}, new Object[]{value}));
    }

    public void logValues(String[] names, Object ... values) {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), names, values));
    }

    public void logValues(String message, String[] names, Object ... values) {
        this._sink.log(new LogSink.StandardMessage(new ThreadSnapshot(), message, names, values));
    }
}

