/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.debug.ThreadSnapshot;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;

public interface LogSink
extends Closeable {
    public void log(StandardMessage var1);

    public void logStart(StartMessage var1);

    public void logEnd(EndMessage var1);

    public void logError(ErrorMessage var1);

    public void logStack(StackMessage var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MessageVisitor<T> {
        public T forStandard(StandardMessage var1);

        public T forStart(StartMessage var1);

        public T forEnd(EndMessage var1);

        public T forError(ErrorMessage var1);

        public T forStack(StackMessage var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StackMessage
    extends Message {
        public StackMessage(ThreadSnapshot thread) {
            super(thread);
        }

        public StackMessage(ThreadSnapshot thread, String text) {
            super(thread, text);
        }

        public StackMessage(StackMessage copy) {
            super(copy);
        }

        @Override
        public void send(LogSink sink) {
            sink.logStack(this);
        }

        @Override
        public <T> T apply(MessageVisitor<? extends T> visitor) {
            return visitor.forStack(this);
        }

        @Override
        public StackMessage serializable() {
            return new StackMessage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorMessage
    extends Message {
        private final Throwable _error;

        public ErrorMessage(ThreadSnapshot thread, Throwable error) {
            super(thread);
            this._error = error;
        }

        public ErrorMessage(ThreadSnapshot thread, String text, Throwable error) {
            super(thread, text);
            this._error = error;
        }

        public ErrorMessage(ErrorMessage copy) {
            super(copy);
            this._error = IOUtil.ensureSerializable(copy._error);
        }

        public Throwable error() {
            return this._error;
        }

        @Override
        public void send(LogSink sink) {
            sink.logError(this);
        }

        @Override
        public <T> T apply(MessageVisitor<? extends T> visitor) {
            return visitor.forError(this);
        }

        @Override
        public ErrorMessage serializable() {
            return new ErrorMessage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EndMessage
    extends ValueMessage {
        public EndMessage(ThreadSnapshot thread, String[] names, Object[] vals) {
            super(thread, names, vals);
        }

        public EndMessage(ThreadSnapshot thread, String message, String[] names, Object[] vals) {
            super(thread, message, names, vals);
        }

        protected EndMessage(EndMessage copy) {
            super(copy);
        }

        @Override
        public void send(LogSink sink) {
            sink.logEnd(this);
        }

        @Override
        public <T> T apply(MessageVisitor<? extends T> visitor) {
            return visitor.forEnd(this);
        }

        @Override
        public EndMessage serializable() {
            return new EndMessage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartMessage
    extends ValueMessage {
        public StartMessage(ThreadSnapshot thread, String[] names, Object[] vals) {
            super(thread, names, vals);
        }

        public StartMessage(ThreadSnapshot thread, String message, String[] names, Object[] vals) {
            super(thread, message, names, vals);
        }

        protected StartMessage(StartMessage copy) {
            super(copy);
        }

        @Override
        public void send(LogSink sink) {
            sink.logStart(this);
        }

        @Override
        public <T> T apply(MessageVisitor<? extends T> visitor) {
            return visitor.forStart(this);
        }

        @Override
        public StartMessage serializable() {
            return new StartMessage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardMessage
    extends ValueMessage {
        public StandardMessage(ThreadSnapshot thread, String[] names, Object[] vals) {
            super(thread, names, vals);
        }

        public StandardMessage(ThreadSnapshot thread, String message, String[] names, Object[] vals) {
            super(thread, message, names, vals);
        }

        protected StandardMessage(StandardMessage copy) {
            super(copy);
        }

        @Override
        public void send(LogSink sink) {
            sink.log(this);
        }

        @Override
        public <T> T apply(MessageVisitor<? extends T> visitor) {
            return visitor.forStandard(this);
        }

        @Override
        public StandardMessage serializable() {
            return new StandardMessage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ValueMessage
    extends Message {
        private final Iterable<Pair<String, Object>> _values;

        protected ValueMessage(ThreadSnapshot thread, String[] names, Object[] vals) {
            super(thread);
            this._values = this.makeValues(names, vals);
        }

        protected ValueMessage(ThreadSnapshot thread, String message, String[] names, Object[] vals) {
            super(thread, message);
            this._values = this.makeValues(names, vals);
        }

        protected ValueMessage(ValueMessage copy) {
            super(copy);
            LinkedList<Pair<String, Object>> safeVals = new LinkedList<Pair<String, Object>>();
            for (Pair<String, Object> p : copy._values) {
                safeVals.add(Pair.make(p.first(), IOUtil.ensureSerializable(p.second())));
            }
            this._values = safeVals;
        }

        private Iterable<Pair<String, Object>> makeValues(String[] names, Object[] vals) {
            if (names.length != vals.length) {
                throw new IllegalArgumentException("Lengths of names and values are inconsistent");
            }
            return IterUtil.zip(IterUtil.make(names), IterUtil.make(vals));
        }

        public Iterable<Pair<String, Object>> values() {
            return this._values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Message
    implements Serializable {
        private final ThreadSnapshot _thread;
        private final Option<String> _text;

        protected Message(ThreadSnapshot thread) {
            this._thread = thread;
            this._text = Option.none();
        }

        protected Message(ThreadSnapshot thread, String text) {
            this._thread = thread;
            this._text = Option.some(text);
        }

        protected Message(Message copy) {
            this._thread = copy._thread;
            this._text = copy._text;
        }

        public ThreadSnapshot thread() {
            return this._thread;
        }

        public Option<String> text() {
            return this._text;
        }

        public Date time() {
            return this._thread.snapshotTime();
        }

        public Option<StackTraceElement> caller() {
            return Option.wrap(this._thread.callingLocation());
        }

        public Iterable<StackTraceElement> stack() {
            return IterUtil.skipFirst(this._thread.getStackTrace());
        }

        public abstract void send(LogSink var1);

        public abstract <T> T apply(MessageVisitor<? extends T> var1);

        public abstract Message serializable();
    }
}

