/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.PollingTaskController;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureTaskController<T>
extends PollingTaskController<T> {
    private volatile Thunk<? extends Future<? extends T>> _futureThunk;
    private volatile Future<? extends T> _future;

    public FutureTaskController(Thunk<? extends Future<? extends T>> futureThunk) {
        this._futureThunk = futureThunk;
        this._future = null;
    }

    @Override
    protected void doStart() {
        this._future = this._futureThunk.value();
        this.started();
    }

    @Override
    protected void doStop() {
        this._future.cancel(true);
    }

    @Override
    protected void discard() {
        this._futureThunk = null;
        this._future = null;
    }

    @Override
    protected void update() {
        if (this._future.isDone()) {
            if (this._future.isCancelled()) {
                this.stopped();
            } else {
                try {
                    this.finish();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void finish() throws InterruptedException {
        try {
            this.finishedCleanly(this._future.get());
        }
        catch (CancellationException e) {
            this.stopped();
        }
        catch (ExecutionException e) {
            this.handleExecutionException(e);
        }
        catch (RuntimeException e) {
            this.finishedWithImplementationException(e);
        }
    }

    @Override
    protected void finish(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.finishedCleanly(this._future.get(timeout, unit));
        }
        catch (CancellationException e) {
            this.stopped();
        }
        catch (ExecutionException e) {
            this.handleExecutionException(e);
        }
        catch (RuntimeException e) {
            this.finishedWithImplementationException(e);
        }
    }

    private void handleExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof Exception) {
            this.finishedWithTaskException((Exception)cause);
        } else {
            this.finishedWithImplementationException(new WrappedException(e));
        }
    }
}

