/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.collect.IterableCollection;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.MappedIterator;
import edu.rice.cs.plt.lambda.Lambda;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyBasedMap<K, V>
implements LambdaMap<K, V> {
    @Override
    public abstract V get(Object var1);

    @Override
    public abstract PredicateSet<K> keySet();

    @Override
    public V value(K key) {
        return this.get(key);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return IterUtil.contains(IterUtil.map(this.keySet(), this), val);
    }

    @Override
    public Collection<V> values() {
        return new IterableCollection(IterUtil.map(this.keySet(), this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V put(K key, V val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> elts) {
        for (Map.Entry<K, V> entry : elts.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return IterUtil.toString(this.entrySet(), "{", ", ", "}");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return ((Object)this.entrySet()).equals(((Map)o).entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    protected static <K, V> Map.Entry<K, V> mapEntryForKey(final Map<K, V> map, final K key) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return map.get(key);
            }

            @Override
            public V setValue(V value) {
                return map.put(key, value);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry cast = (Map.Entry)o;
                if (key == null ? cast.getKey() == null : key.equals(cast.getKey())) {
                    Object val = map.get(key);
                    return val == null ? cast.getValue() == null : val.equals(cast.getValue());
                }
                return false;
            }

            @Override
            public int hashCode() {
                Object val = map.get(key);
                return (key == null ? 0 : key.hashCode()) ^ (val == null ? 0 : val.hashCode());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySet
    extends AbstractPredicateSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry;
            Object key;
            if (o instanceof Map.Entry && AbstractKeyBasedMap.this.containsKey(key = (entry = (Map.Entry)o).getKey())) {
                Object val = entry.getValue();
                Object mapVal = AbstractKeyBasedMap.this.get(key);
                return val == null ? mapVal == null : val.equals(mapVal);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return MappedIterator.make(AbstractKeyBasedMap.this.keySet().iterator(), new Lambda<K, Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> value(K key) {
                    return AbstractKeyBasedMap.mapEntryForKey(AbstractKeyBasedMap.this, key);
                }
            });
        }

        @Override
        public boolean isInfinite() {
            return AbstractKeyBasedMap.this.keySet().isInfinite();
        }

        @Override
        public boolean hasFixedSize() {
            return AbstractKeyBasedMap.this.keySet().hasFixedSize();
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        @Override
        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        @Override
        public int size(int bound) {
            return AbstractKeyBasedMap.this.keySet().size(bound);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            boolean present = this.contains(entry);
            AbstractKeyBasedMap.this.put(entry.getKey(), entry.getValue());
            return !present;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                boolean present = AbstractKeyBasedMap.this.containsKey(entry.getKey());
                AbstractKeyBasedMap.this.remove(entry.getKey());
                return present;
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }
    }
}

