/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileStatement
extends Statement {
    private final Expression _condition;
    private final Statement _code;

    public WhileStatement(SourceInfo in_sourceInfo, Expression in_condition, Statement in_code) {
        super(in_sourceInfo);
        if (in_condition == null) {
            throw new IllegalArgumentException("Parameter 'condition' to the WhileStatement constructor was null. This class may not have null field values.");
        }
        this._condition = in_condition;
        if (in_code == null) {
            throw new IllegalArgumentException("Parameter 'code' to the WhileStatement constructor was null. This class may not have null field values.");
        }
        this._code = in_code;
    }

    public final Expression getCondition() {
        return this._condition;
    }

    public final Statement getCode() {
        return this._code;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forWhileStatement(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forWhileStatement(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("WhileStatement:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("condition = ");
        Expression temp_condition = this.getCondition();
        if (temp_condition == null) {
            writer.print("null");
        } else {
            temp_condition.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("code = ");
        Statement temp_code = this.getCode();
        if (temp_code == null) {
            writer.print("null");
        } else {
            temp_code.outputHelp(writer);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        WhileStatement casted = (WhileStatement)obj;
        if (!this.getCondition().equals(casted.getCondition())) {
            return false;
        }
        return this.getCode().equals(casted.getCode());
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getCondition().hashCode();
        return code ^= this.getCode().hashCode();
    }
}

