/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.ImportStatement;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.PackageStatement;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.TypeDefBase;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFile
extends JExpression {
    private final PackageStatement[] _packageStatements;
    private final ImportStatement[] _importStatements;
    private final TypeDefBase[] _types;

    public SourceFile(SourceInfo in_sourceInfo, PackageStatement[] in_packageStatements, ImportStatement[] in_importStatements, TypeDefBase[] in_types) {
        super(in_sourceInfo);
        if (in_packageStatements == null) {
            throw new IllegalArgumentException("Parameter 'packageStatements' to the SourceFile constructor was null. This class may not have null field values.");
        }
        this._packageStatements = in_packageStatements;
        if (in_importStatements == null) {
            throw new IllegalArgumentException("Parameter 'importStatements' to the SourceFile constructor was null. This class may not have null field values.");
        }
        this._importStatements = in_importStatements;
        if (in_types == null) {
            throw new IllegalArgumentException("Parameter 'types' to the SourceFile constructor was null. This class may not have null field values.");
        }
        this._types = in_types;
    }

    public final PackageStatement[] getPackageStatements() {
        return this._packageStatements;
    }

    public final ImportStatement[] getImportStatements() {
        return this._importStatements;
    }

    public final TypeDefBase[] getTypes() {
        return this._types;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forSourceFile(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forSourceFile(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        int i;
        writer.print("SourceFile:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("packageStatements = ");
        writer.print("{");
        writer.indent();
        for (i = 0; i < this.getPackageStatements().length; ++i) {
            PackageStatement temp_packageStatements = this.getPackageStatements()[i];
            writer.startLine("#" + i + ": ");
            if (temp_packageStatements == null) {
                writer.print("null");
                continue;
            }
            temp_packageStatements.outputHelp(writer);
        }
        writer.unindent();
        if (this.getPackageStatements().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.startLine("");
        writer.print("importStatements = ");
        writer.print("{");
        writer.indent();
        for (i = 0; i < this.getImportStatements().length; ++i) {
            ImportStatement temp_importStatements = this.getImportStatements()[i];
            writer.startLine("#" + i + ": ");
            if (temp_importStatements == null) {
                writer.print("null");
                continue;
            }
            temp_importStatements.outputHelp(writer);
        }
        writer.unindent();
        if (this.getImportStatements().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.startLine("");
        writer.print("types = ");
        writer.print("{");
        writer.indent();
        for (i = 0; i < this.getTypes().length; ++i) {
            TypeDefBase temp_types = this.getTypes()[i];
            writer.startLine("#" + i + ": ");
            if (temp_types == null) {
                writer.print("null");
                continue;
            }
            temp_types.outputHelp(writer);
        }
        writer.unindent();
        if (this.getTypes().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.unindent();
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        SourceFile casted = (SourceFile)obj;
        if (this.getPackageStatements().length != casted.getPackageStatements().length) {
            return false;
        }
        for (i = 0; i < this.getPackageStatements().length; ++i) {
            if (this.getPackageStatements()[i].equals(casted.getPackageStatements()[i])) continue;
            return false;
        }
        if (this.getImportStatements().length != casted.getImportStatements().length) {
            return false;
        }
        for (i = 0; i < this.getImportStatements().length; ++i) {
            if (this.getImportStatements()[i].equals(casted.getImportStatements()[i])) continue;
            return false;
        }
        if (this.getTypes().length != casted.getTypes().length) {
            return false;
        }
        for (i = 0; i < this.getTypes().length; ++i) {
            if (this.getTypes()[i].equals(casted.getTypes()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int generateHashCode() {
        int i;
        int code = this.getClass().hashCode();
        code ^= 0;
        for (i = 0; i < this.getPackageStatements().length; ++i) {
            code ^= this.getPackageStatements()[i].hashCode();
        }
        for (i = 0; i < this.getImportStatements().length; ++i) {
            code ^= this.getImportStatements()[i].hashCode();
        }
        for (i = 0; i < this.getTypes().length; ++i) {
            code ^= this.getTypes()[i].hashCode();
        }
        return code;
    }
}

