/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.Expression;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.SwitchCase;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.UnbracedBody;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabeledCase
extends SwitchCase {
    private final Expression _label;

    public LabeledCase(SourceInfo in_sourceInfo, Expression in_label, UnbracedBody in_code) {
        super(in_sourceInfo, in_code);
        if (in_label == null) {
            throw new IllegalArgumentException("Parameter 'label' to the LabeledCase constructor was null. This class may not have null field values.");
        }
        this._label = in_label;
    }

    public final Expression getLabel() {
        return this._label;
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forLabeledCase(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forLabeledCase(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("LabeledCase:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("label = ");
        Expression temp_label = this.getLabel();
        if (temp_label == null) {
            writer.print("null");
        } else {
            temp_label.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("code = ");
        UnbracedBody temp_code = this.getCode();
        if (temp_code == null) {
            writer.print("null");
        } else {
            temp_code.outputHelp(writer);
        }
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        LabeledCase casted = (LabeledCase)obj;
        if (!this.getLabel().equals(casted.getLabel())) {
            return false;
        }
        return this.getCode().equals(casted.getCode());
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getLabel().hashCode();
        return code ^= this.getCode().hashCode();
    }
}

