/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.InstanceData;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.PrimitiveData;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.TypeChecker;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolData
extends TypeData {
    public static final SymbolData BOOLEAN_TYPE = new PrimitiveData("boolean"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version);
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            if (toCheck == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !toCheck.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Boolean");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(toCheck, version);
            }
            return toCheck == BOOLEAN_TYPE;
        }
    };
    public static final SymbolData CHAR_TYPE = new PrimitiveData("char"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == SHORT_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Character");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == INT_TYPE || assignTo == LONG_TYPE || assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE || assignTo == CHAR_TYPE;
        }
    };
    public static final SymbolData BYTE_TYPE = new PrimitiveData("byte"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Byte");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == BYTE_TYPE || assignTo == SHORT_TYPE || assignTo == INT_TYPE || assignTo == LONG_TYPE || assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData SHORT_TYPE = new PrimitiveData("short"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Short");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == SHORT_TYPE || assignTo == INT_TYPE || assignTo == LONG_TYPE || assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData INT_TYPE = new PrimitiveData("int"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE || castTo == SHORT_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Integer");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == INT_TYPE || assignTo == LONG_TYPE || assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData LONG_TYPE = new PrimitiveData("long"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE || castTo == INT_TYPE || castTo == SHORT_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Long");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == LONG_TYPE || assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData FLOAT_TYPE = new PrimitiveData("float"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE || castTo == INT_TYPE || castTo == LONG_TYPE || castTo == SHORT_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Float");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == FLOAT_TYPE || assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData DOUBLE_TYPE = new PrimitiveData("double"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version) || castTo == CHAR_TYPE || castTo == INT_TYPE || castTo == LONG_TYPE || castTo == DOUBLE_TYPE || castTo == SHORT_TYPE || castTo == BYTE_TYPE;
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            if (assignTo == null) {
                return false;
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version) && !assignTo.isPrimitiveType()) {
                SymbolData autoBoxMe = LanguageLevelConverter.symbolTable.get("java.lang.Double");
                return autoBoxMe != null && autoBoxMe.isAssignableTo(assignTo, version);
            }
            return assignTo == DOUBLE_TYPE;
        }
    };
    public static final SymbolData VOID_TYPE = new PrimitiveData("void"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return this == toCheck;
        }
    };
    public static final SymbolData EXCEPTION = new SymbolData("exception"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return true;
        }
    };
    public static final SymbolData NOT_FOUND = new SymbolData("not found"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return false;
        }
    };
    public static final SymbolData NULL_TYPE = new SymbolData("null"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return this.isAssignableTo(castTo, version);
        }

        public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
            return assignTo != null && !assignTo.isPrimitiveType();
        }
    };
    public static final SymbolData AMBIGUOUS_REFERENCE = new SymbolData("ambiguous reference"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return false;
        }
    };
    public static final SymbolData THIS_CONSTRUCTOR = new SymbolData("this constructor"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return false;
        }
    };
    public static final SymbolData SUPER_CONSTRUCTOR = new SymbolData("super constructor"){

        public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
            return false;
        }

        public boolean isAssignableTo(SymbolData toCheck, JavaVersion version) {
            return false;
        }
    };
    private boolean _isContinuation;
    private boolean _hasAutoGeneratedJunitImport;
    private TypeParameter[] _typeParameters;
    private LinkedList<MethodData> _methods;
    private SymbolData _superClass;
    private LinkedList<SymbolData> _interfaces;
    private LinkedList<SymbolData> _innerInterfaces;
    private boolean _isInterface;
    private String _package;
    private InstanceData _instanceData;
    private int _constructorNumber;
    private int _localClassNum;
    private int _anonymousInnerClassNum;

    public SymbolData(String name, ModifiersAndVisibility modifiersAndVisibility, TypeParameter[] typeParameters, SymbolData superClass, LinkedList<SymbolData> interfaces, Data outerData) {
        super(outerData);
        this._name = name;
        this._modifiersAndVisibility = modifiersAndVisibility;
        this._typeParameters = typeParameters;
        this._methods = new LinkedList();
        this._superClass = superClass;
        this._interfaces = interfaces;
        for (int i = 0; i < interfaces.size(); ++i) {
            this.addEnclosingData(this._interfaces.get(i));
        }
        this._enclosingData.addFirst(this._superClass);
        this._innerClasses = new LinkedList();
        this._innerInterfaces = new LinkedList();
        this._isContinuation = false;
        this._hasAutoGeneratedJunitImport = false;
        this._isInterface = false;
        this._localClassNum = 0;
        this._anonymousInnerClassNum = 0;
        this._package = "";
        this._constructorNumber = 0;
        this._instanceData = new InstanceData(this);
    }

    public SymbolData(String name, ModifiersAndVisibility modifiersAndVisibility, TypeParameter[] typeParameters, SymbolData superClass, LinkedList<SymbolData> interfaces, Data outerData, String pkg) {
        this(name, modifiersAndVisibility, typeParameters, superClass, interfaces, outerData);
        this._package = pkg;
    }

    public SymbolData(String name, ModifiersAndVisibility modifiersAndVisibility, TypeParameter[] typeParameters, LinkedList<SymbolData> interfaces, Data outerData) {
        this(name, modifiersAndVisibility, typeParameters, null, interfaces, outerData);
        this._isInterface = true;
    }

    public SymbolData(String name) {
        super(null);
        this._name = name;
        this._modifiersAndVisibility = new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[0]);
        this._typeParameters = new TypeParameter[0];
        this._methods = new LinkedList();
        this._superClass = null;
        this._interfaces = new LinkedList();
        this._innerClasses = new LinkedList();
        this._innerInterfaces = new LinkedList();
        this._isContinuation = true;
        this._isInterface = false;
        this._package = "";
        this._instanceData = new InstanceData(this);
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public String toString() {
        if (this._isContinuation) {
            return "? " + this._name;
        }
        return "!" + this._name;
    }

    public boolean isAssignableTo(SymbolData assignTo, JavaVersion version) {
        if (assignTo != null) {
            if (assignTo.isPrimitiveType() && LanguageLevelConverter.versionSupportsAutoboxing(version)) {
                SymbolData unboxedType = this.unbox();
                if (unboxedType == null) {
                    return false;
                }
                return unboxedType.isAssignableTo(assignTo, version);
            }
            return this.isSubClassOf(assignTo);
        }
        return false;
    }

    private SymbolData unbox() {
        String name = this.getName();
        if (name.equals("java.lang.Integer")) {
            return INT_TYPE;
        }
        if (name.equals("java.lang.Character")) {
            return CHAR_TYPE;
        }
        if (name.equals("java.lang.Short")) {
            return SHORT_TYPE;
        }
        if (name.equals("java.lang.Byte")) {
            return BYTE_TYPE;
        }
        if (name.equals("java.lang.Float")) {
            return FLOAT_TYPE;
        }
        if (name.equals("java.lang.Double")) {
            return DOUBLE_TYPE;
        }
        if (name.equals("java.lang.Long")) {
            return LONG_TYPE;
        }
        if (name.equals("java.lang.Boolean")) {
            return BOOLEAN_TYPE;
        }
        return null;
    }

    public boolean isCastableTo(SymbolData castTo, JavaVersion version) {
        if (castTo != null) {
            if (castTo.isPrimitiveType()) {
                if (LanguageLevelConverter.versionSupportsAutoboxing(version)) {
                    SymbolData unboxedType = this.unbox();
                    if (unboxedType == null) {
                        return false;
                    }
                    return unboxedType.isCastableTo(castTo, version);
                }
                return false;
            }
            if (!this.isInterface()) {
                if (!castTo.isInterface()) {
                    return this.isSubClassOf(castTo) || castTo.isSubClassOf(this);
                }
                return !castTo.hasModifier("final") || castTo.isSubClassOf(this);
            }
            if (!castTo.isInterface()) {
                return !castTo.hasModifier("final") || castTo.isSubClassOf(this);
            }
            if (LanguageLevelConverter.versionSupportsAutoboxing(version)) {
                return true;
            }
            for (MethodData md : this.getMethods()) {
                if (!SymbolData.checkDifferentReturnTypes(md, castTo, false, version)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSubClassOf(SymbolData superClass) {
        if (superClass == null) {
            return false;
        }
        if (this == superClass) {
            return true;
        }
        if (superClass.isInterface()) {
            for (SymbolData d : this._interfaces) {
                if (d == null) continue;
                if (d == superClass) {
                    return true;
                }
                if (!d.isSubClassOf(superClass)) continue;
                return true;
            }
        }
        if (this._superClass != null) {
            return this._superClass.isSubClassOf(superClass);
        }
        return false;
    }

    public boolean isInnerClassOf(SymbolData outerClass, boolean stopAtStatic) {
        if (this == outerClass) {
            return true;
        }
        Data outerData = this.getOuterData();
        if (outerData == null) {
            return false;
        }
        if (stopAtStatic && this.hasModifier("static")) {
            return false;
        }
        return outerData.getSymbolData().isInnerClassOf(outerClass, stopAtStatic);
    }

    @Override
    public boolean isInstanceType() {
        return false;
    }

    @Override
    public SymbolData getSymbolData() {
        return this;
    }

    @Override
    public InstanceData getInstanceData() {
        return this._instanceData;
    }

    public void setInstanceData(InstanceData id) {
        this._instanceData = id;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String pkg) {
        this._package = pkg;
    }

    public TypeParameter[] getTypeParameters() {
        return this._typeParameters;
    }

    public void setTypeParameters(TypeParameter[] typeParameters) {
        this._typeParameters = typeParameters;
    }

    public boolean isInterface() {
        return this._isInterface;
    }

    public void setInterface(boolean ii) {
        this._isInterface = ii;
    }

    public LinkedList<SymbolData> getInnerInterfaces() {
        return this._innerInterfaces;
    }

    @Override
    protected SymbolData getInnerClassOrInterfaceHelper(String nameToMatch, int firstIndexOfDot) {
        Iterator<SymbolData> iter2 = this.innerClassesAndInterfacesIterator();
        while (iter2.hasNext()) {
            SymbolData sd = iter2.next();
            String sdName = sd.getName();
            sdName = LanguageLevelVisitor.getUnqualifiedClassName(sdName);
            if (firstIndexOfDot == -1) {
                if (!sdName.equals(nameToMatch)) continue;
                return sd;
            }
            if (!sdName.equals(nameToMatch.substring(0, firstIndexOfDot))) continue;
            return sd.getInnerClassOrInterface(nameToMatch.substring(firstIndexOfDot + 1));
        }
        SymbolData result = null;
        SymbolData newResult = null;
        SymbolData privateResult = null;
        if (this._superClass != null && (newResult = this._superClass.getInnerClassOrInterfaceHelper(nameToMatch, firstIndexOfDot)) != null) {
            SymbolData outerPiece = firstIndexOfDot > 0 ? this._superClass.getInnerClassOrInterfaceHelper(nameToMatch.substring(0, firstIndexOfDot), -1) : newResult;
            if (TypeChecker.checkAccessibility(outerPiece.getMav(), outerPiece, this)) {
                result = newResult;
            } else {
                privateResult = newResult;
            }
        }
        for (SymbolData id : this._interfaces) {
            newResult = id.getInnerClassOrInterfaceHelper(nameToMatch, firstIndexOfDot);
            if (newResult == null) continue;
            SymbolData outerPiece = firstIndexOfDot > 0 ? this._superClass.getInnerClassOrInterfaceHelper(nameToMatch.substring(0, firstIndexOfDot), -1) : newResult;
            if (TypeChecker.checkAccessibility(outerPiece.getMav(), outerPiece, this)) {
                if (result == null) {
                    result = newResult;
                    continue;
                }
                return AMBIGUOUS_REFERENCE;
            }
            privateResult = newResult;
        }
        if (result != null) {
            return result;
        }
        return privateResult;
    }

    @Override
    public Iterator<SymbolData> innerClassesAndInterfacesIterator() {
        return new Iterator<SymbolData>(){
            private Iterator<SymbolData> _first;
            private Iterator<SymbolData> _second;
            {
                this._first = SymbolData.this._innerClasses.iterator();
                this._second = SymbolData.this._innerInterfaces.iterator();
            }

            @Override
            public boolean hasNext() {
                return this._first.hasNext() || this._second.hasNext();
            }

            @Override
            public SymbolData next() {
                if (this._first.hasNext()) {
                    return this._first.next();
                }
                return this._second.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addInnerInterface(SymbolData innerInterface) {
        this._innerInterfaces.addLast(innerInterface);
    }

    public int preincrementLocalClassNum() {
        return ++this._localClassNum;
    }

    public void setAnonymousInnerClassNum(int i) {
        this._anonymousInnerClassNum = i;
    }

    public int preincrementAnonymousInnerClassNum() {
        return ++this._anonymousInnerClassNum;
    }

    public int getAnonymousInnerClassNum() {
        return this._anonymousInnerClassNum;
    }

    public int postdecrementLocalClassNum() {
        return this._localClassNum--;
    }

    public int postdecrementAnonymousInnerClassNum() {
        return this._anonymousInnerClassNum--;
    }

    @Override
    public boolean addVar(VariableData var) {
        return super.addVar(var);
    }

    @Override
    public boolean addVars(VariableData[] vars) {
        boolean success = true;
        for (int i = 0; i < vars.length; ++i) {
            LinkedList<SymbolData> seen = new LinkedList<SymbolData>();
            if (!this._repeatedName(vars[i], seen)) {
                if (!vars[i].isFinal()) {
                    vars[i].gotValue();
                }
                this._vars.addLast(vars[i]);
                continue;
            }
            success = false;
        }
        return success;
    }

    @Override
    public boolean addFinalVars(VariableData[] vars) {
        boolean success = true;
        for (int i = 0; i < vars.length; ++i) {
            LinkedList<SymbolData> seen = new LinkedList<SymbolData>();
            if (!this._repeatedNameInHierarchy(vars[i], seen)) {
                vars[i].setFinal();
                this._vars.addLast(vars[i]);
                continue;
            }
            success = false;
        }
        return success;
    }

    private boolean _repeatedName(VariableData vr, LinkedList<SymbolData> seen) {
        seen.addLast(this);
        Iterator iter2 = this._vars.iterator();
        while (iter2.hasNext()) {
            if (!vr.getName().equals(((VariableData)iter2.next()).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _repeatedNameInHierarchy(VariableData vr, LinkedList<SymbolData> seen) {
        seen.addLast(this);
        Iterator iter2 = this._vars.iterator();
        while (iter2.hasNext()) {
            if (!vr.getName().equals(((VariableData)iter2.next()).getName())) continue;
            return true;
        }
        if (this._superClass != null && this._superClass._repeatedNameInHierarchy(vr, seen)) {
            return true;
        }
        for (int i = 0; i < this._interfaces.size(); ++i) {
            if (!this._interfaces.get(i)._repeatedNameInHierarchy(vr, seen)) continue;
            return true;
        }
        return false;
    }

    public LinkedList<MethodData> getMethods() {
        return this._methods;
    }

    public boolean hasMethod(String name) {
        for (int i = 0; i < this._methods.size(); ++i) {
            MethodData currMd = this._methods.get(i);
            if (!currMd.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MethodData getMethod(String name, TypeData[] paramTypes) {
        for (int i = 0; i < this._methods.size(); ++i) {
            MethodData currMd = this._methods.get(i);
            if (!currMd.getName().equals(name) || paramTypes.length != currMd.getParams().length) continue;
            boolean match = true;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (paramTypes[j].getSymbolData() == currMd.getParams()[j].getType().getSymbolData()) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return currMd;
        }
        return null;
    }

    public void setMethods(LinkedList<MethodData> methods) {
        this._methods = methods;
    }

    public static MethodData repeatedSignature(LinkedList<MethodData> listOfMethods, MethodData method) {
        return SymbolData.repeatedSignature(listOfMethods, method, false);
    }

    public static MethodData repeatedSignature(LinkedList<MethodData> listOfMethods, MethodData method, boolean fromClassFile) {
        Iterator iter2 = listOfMethods.iterator();
        VariableData[] methodParams = method.getParams();
        while (iter2.hasNext()) {
            VariableData[] currMdParams;
            boolean match = true;
            MethodData currMd = (MethodData)iter2.next();
            if (!currMd.getName().equals(method.getName()) || fromClassFile && currMd.getReturnType() != method.getReturnType() || (currMdParams = currMd.getParams()).length != methodParams.length) continue;
            for (int i = 0; i < currMdParams.length; ++i) {
                if (currMdParams[i].getType() == methodParams[i].getType()) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return currMd;
        }
        return null;
    }

    boolean isBooleanType(JavaVersion version) {
        return this == BOOLEAN_TYPE || this.getName().equals("java.lang.Boolean") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isCharType(JavaVersion version) {
        return this == CHAR_TYPE || this.getName().equals("java.lang.Character") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isByteType(JavaVersion version) {
        return this == BYTE_TYPE || this.getName().equals("java.lang.Byte") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isShortType(JavaVersion version) {
        return this == SHORT_TYPE || this.getName().equals("java.lang.Short") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isIntType(JavaVersion version) {
        return this == INT_TYPE || this.getName().equals("java.lang.Integer") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isLongType(JavaVersion version) {
        return this == LONG_TYPE || this.getName().equals("java.lang.Long") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isFloatType(JavaVersion version) {
        return this == FLOAT_TYPE || this.getName().equals("java.lang.Float") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    boolean isDoubleType(JavaVersion version) {
        return this == DOUBLE_TYPE || this.getName().equals("java.lang.Double") && LanguageLevelConverter.versionSupportsAutoboxing(version);
    }

    private static boolean _isCompatible(MethodData overwritten, MethodData overwriting) {
        if (overwritten.hasModifier("public")) {
            return overwriting.hasModifier("public");
        }
        if (overwritten.hasModifier("protected")) {
            return overwriting.hasModifier("protected") || overwriting.hasModifier("public");
        }
        if (!overwritten.hasModifier("private")) {
            return !overwriting.hasModifier("private");
        }
        return true;
    }

    protected static boolean checkDifferentReturnTypes(MethodData md, SymbolData sd, JavaVersion version) {
        return SymbolData.checkDifferentReturnTypes(md, sd, true, version);
    }

    protected static boolean checkDifferentReturnTypes(MethodData md, SymbolData sd, boolean addError, JavaVersion version) {
        LinkedList<SymbolData> interfaces = sd.getInterfaces();
        LinkedList<SymbolData> enclosingData = new LinkedList<SymbolData>();
        enclosingData.addAll(interfaces);
        SymbolData superClass = sd.getSuperClass();
        if (superClass != null) {
            enclosingData.add(superClass);
        }
        for (SymbolData currSd : enclosingData) {
            MethodData matchingMd = SymbolData.repeatedSignature(currSd.getMethods(), md);
            if (matchingMd != null) {
                if (matchingMd.hasModifier("private")) {
                    return false;
                }
                boolean subclass = md.getReturnType().isSubClassOf(matchingMd.getReturnType());
                if (!(matchingMd.getReturnType() == md.getReturnType() || subclass && LanguageLevelConverter.versionIs15(version))) {
                    StringBuffer methodSignature = new StringBuffer(md.getName() + "(");
                    VariableData[] params = md.getParams();
                    for (int i = 0; i < params.length; ++i) {
                        if (i > 0) {
                            methodSignature.append(", ");
                        }
                        methodSignature.append(params[i].getType().getName());
                    }
                    methodSignature.append(")");
                    String methodSigString = methodSignature.toString();
                    if (addError) {
                        TypeChecker.errors.addLast(new Pair<String, JExpression>(methodSigString + " in " + sd.getName() + " cannot override " + methodSigString + " in " + currSd.getName() + "; attempting to use different return types", md.getJExpression()));
                    }
                    return true;
                }
                if (SymbolData._isCompatible(matchingMd, md)) continue;
                String access = "package";
                if (matchingMd.hasModifier("private")) {
                    access = "private";
                }
                if (matchingMd.hasModifier("public")) {
                    access = "public";
                }
                if (matchingMd.hasModifier("protected")) {
                    access = "protected";
                }
                if (addError) {
                    TypeChecker.errors.addLast(new Pair<String, JExpression>(md.getName() + " in " + md.getSymbolData().getName() + " cannot override " + matchingMd.getName() + " in " + matchingMd.getSymbolData().getName() + ".  You are attempting to assign weaker access priviledges. In " + matchingMd.getSymbolData().getName() + ", " + matchingMd.getName() + " was " + access, md.getJExpression()));
                }
                return true;
            }
            if (!SymbolData.checkDifferentReturnTypes(md, currSd, version)) continue;
            return true;
        }
        return false;
    }

    public String createUniqueMethodName(String methodName) {
        int counter;
        LinkedList<SymbolData> toCheck = new LinkedList<SymbolData>();
        toCheck.add(this);
        HashSet<String> names = new HashSet<String>();
        while (toCheck.size() > 0) {
            SymbolData sd = (SymbolData)toCheck.removeFirst();
            LinkedList<MethodData> methods = sd.getMethods();
            for (MethodData md : methods) {
                names.add(md.getName());
            }
            if (sd.getSuperClass() != null) {
                toCheck.add(sd.getSuperClass());
            }
            toCheck.addAll(sd.getInterfaces());
            if (sd.getOuterData() == null) continue;
            toCheck.add(sd.getOuterData().getSymbolData());
        }
        String newName = methodName;
        for (counter = 0; names.contains(newName) && counter != -1; ++counter) {
            newName = methodName + counter;
        }
        if (counter == -1) {
            throw new RuntimeException("Internal Program Error: Unable to rename method " + methodName + ".  All possible names were taken.  Please report this bug.");
        }
        return newName;
    }

    private String _createErrorMessage(MethodData md) {
        StringBuffer message = new StringBuffer("In the class \"" + md.getSymbolData().getName() + "\", you cannot have two methods with the same name: \"" + md.getName() + "\"");
        VariableData[] params = md.getParams();
        if (params.length > 0) {
            message.append(" and parameter type");
            if (params.length > 1) {
                message.append("s");
            }
            message.append(":");
        }
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                message.append(",");
            }
            message.append(" " + params[i].getType().getName());
        }
        return message.toString();
    }

    public void addMethod(MethodData method) {
        if (SymbolData.repeatedSignature(this._methods, method) != null) {
            LanguageLevelVisitor.errors.addLast(new Pair<String, JExpression>(this._createErrorMessage(method), method.getJExpression()));
        } else {
            this._methods.addLast(method);
        }
    }

    public void addMethod(MethodData method, boolean isAugmentedCode) {
        MethodData md = SymbolData.repeatedSignature(this._methods, method);
        if (md != null) {
            LanguageLevelVisitor.errors.addLast(new Pair<String, JExpression>("This method's signature conflicts with an automatically generated method's signature", md.getJExpression()));
        } else {
            this._methods.addLast(method);
        }
    }

    public void addMethod(MethodData method, boolean isAugmentedCode, boolean fromClassFile) {
        MethodData md = SymbolData.repeatedSignature(this._methods, method, fromClassFile);
        if (md != null) {
            LanguageLevelVisitor.errors.addLast(new Pair<String, JExpression>(this._createErrorMessage(method), md.getJExpression()));
        } else {
            this._methods.addLast(method);
        }
    }

    public SymbolData getSuperClass() {
        return this._superClass;
    }

    public void setSuperClass(SymbolData superClass) {
        this._superClass = superClass;
        this.addEnclosingData(superClass);
    }

    public LinkedList<SymbolData> getInterfaces() {
        return this._interfaces;
    }

    public void addInterface(SymbolData interphace) {
        this._interfaces.addLast(interphace);
        this.addEnclosingData(interphace);
    }

    public void setInterfaces(LinkedList<SymbolData> interfaces) {
        this._interfaces = interfaces;
        for (int i = 0; i < interfaces.size(); ++i) {
            this.addEnclosingData(interfaces.get(i));
        }
    }

    public void incrementConstructorCount() {
        ++this._constructorNumber;
    }

    public void decrementConstructorCount() {
        --this._constructorNumber;
    }

    public int getConstructorCount() {
        return this._constructorNumber;
    }

    public boolean isContinuation() {
        return this._isContinuation;
    }

    public void setIsContinuation(boolean isContinuation) {
        this._isContinuation = isContinuation;
    }

    public boolean hasAutoGeneratedJunitImport() {
        return this._hasAutoGeneratedJunitImport;
    }

    public void setHasAutoGeneratedJunitImport(boolean hasAutoGeneratedJunitImport) {
        this._hasAutoGeneratedJunitImport = hasAutoGeneratedJunitImport;
    }

    public boolean isNumberTypeWithoutAutoboxing() {
        return this == INT_TYPE || this == DOUBLE_TYPE || this == LONG_TYPE || this == CHAR_TYPE || this == FLOAT_TYPE || this == SHORT_TYPE || this == BYTE_TYPE;
    }

    public boolean isNumberType(JavaVersion version) {
        if (!LanguageLevelConverter.versionSupportsAutoboxing(version)) {
            return this.isNumberTypeWithoutAutoboxing();
        }
        return this.isDoubleType(version) || this.isFloatType(version) || this.isLongType(version) || this.isIntType(version) || this.isCharType(version) || this.isShortType(version) || this.isByteType(version);
    }

    public boolean isNonFloatOrBooleanType(JavaVersion version) {
        if (!LanguageLevelConverter.versionSupportsAutoboxing(version)) {
            return this.isNonFloatOrBooleanTypeWithoutAutoboxing();
        }
        return this.isIntType(version) || this.isLongType(version) || this.isCharType(version) || this.isShortType(version) || this.isByteType(version) || this.isBooleanType(version);
    }

    public boolean isNonFloatOrBooleanTypeWithoutAutoboxing() {
        return this == INT_TYPE || this == LONG_TYPE || this == CHAR_TYPE || this == SHORT_TYPE || this == BYTE_TYPE || this == BOOLEAN_TYPE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SymbolData sd = (SymbolData)obj;
        return this.isContinuation() == sd.isContinuation() && this.getMav().equals(sd.getMav()) && LanguageLevelVisitor.arrayEquals(this.getTypeParameters(), sd.getTypeParameters()) && this.getMethods().equals(sd.getMethods()) && this.getSuperClass() == sd.getSuperClass() && this.getInterfaces().equals(sd.getInterfaces()) && this.getOuterData() == sd.getOuterData() && this.getInnerClasses().equals(sd.getInnerClasses()) && this.getName().equals(sd.getName()) && this.getInnerInterfaces().equals(sd.getInnerInterfaces()) && this.getPackage().equals(sd.getPackage()) && this.isInterface() == sd.isInterface();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implementsRunnable() {
        return this.getName().equals("java.lang.Thread") || this.getName().equals("java.util.TimerTask") || this.getName().equals("javax.swing.text.AsyncBoxView$ChildState") || this.getName().equals("java.awt.image.renderable.RenderableImageProducer") || this.getName().equals("java.util.concurrent.FutureTask");
    }

    public boolean hasInterface(SymbolData i) {
        if (i == null) {
            return false;
        }
        if (this.getInterfaces().contains(i)) {
            return true;
        }
        if (this.getSuperClass() != null && this.getSuperClass().hasInterface(i)) {
            return true;
        }
        for (int j = 0; j < this.getInterfaces().size(); ++j) {
            if (!this.getInterfaces().get(j).hasInterface(i)) continue;
            return true;
        }
        return false;
    }

    public LinkedList<VariableData> getAllSuperVars() {
        LinkedList<VariableData> myVars = new LinkedList<VariableData>();
        if (this.getSuperClass() != null) {
            myVars.addAll(this.getSuperClass().getVars());
            myVars.addAll(this.getSuperClass().getAllSuperVars());
        }
        for (int i = 0; i < this.getInterfaces().size(); ++i) {
            myVars.addAll(this.getInterfaces().get(i).getVars());
            myVars.addAll(this.getInterfaces().get(i).getAllSuperVars());
        }
        return myVars;
    }

    static /* synthetic */ String access$100(SymbolData x0, MethodData x1) {
        return x0._createErrorMessage(x1);
    }

    static /* synthetic */ boolean access$200(MethodData x0, MethodData x1) {
        return SymbolData._isCompatible(x0, x1);
    }

    static /* synthetic */ boolean access$300(SymbolData x0, VariableData x1, LinkedList x2) {
        return x0._repeatedNameInHierarchy(x1, x2);
    }

    static /* synthetic */ SymbolData access$402(SymbolData x0, SymbolData x1) {
        x0._superClass = x1;
        return x0._superClass;
    }

    static {
        ModifiersAndVisibility _publicMav = new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[]{"public"});
        VOID_TYPE.setIsContinuation(false);
        VOID_TYPE.setMav(_publicMav);
        NOT_FOUND.setIsContinuation(false);
        NOT_FOUND.setMav(_publicMav);
        EXCEPTION.setMav(_publicMav);
        EXCEPTION.setIsContinuation(false);
    }
}

