/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.Bob;
import edu.rice.cs.javalanglevels.Data;
import edu.rice.cs.javalanglevels.LanguageLevelConverter;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.TypeData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.Type;
import edu.rice.cs.javalanglevels.tree.UninitializedVariableDeclarator;
import java.io.File;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBodyTypeChecker
extends Bob {
    private SymbolData _symbolData;

    public InterfaceBodyTypeChecker(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<VariableData> vars, LinkedList<Pair<SymbolData, JExpression>> thrown) {
        super(sd, file, packageName, importedFiles, importedPackages, vars, thrown);
        this._vars.addAll(sd.getVars());
        this._symbolData = sd;
    }

    @Override
    protected Data _getData() {
        return this._symbolData;
    }

    @Override
    public TypeData forUninitializedVariableDeclarator(UninitializedVariableDeclarator that) {
        InterfaceBodyTypeChecker._addError("All fields in interfaces must be initialized", that);
        return null;
    }

    @Override
    public TypeData forAbstractMethodDef(AbstractMethodDef that) {
        TypeData mav_result = that.getMav().visit(this);
        TypeData[] typeParams_result = this.makeArrayOfRetType(that.getTypeParams().length);
        for (int i = 0; i < that.getTypeParams().length; ++i) {
            typeParams_result[i] = that.getTypeParams()[i].visit(this);
        }
        SymbolData result_result = this.getSymbolData(that.getResult().getName(), this._symbolData, that);
        TypeData name_result = that.getName().visit(this);
        TypeData[] params_result = this.makeArrayOfRetType(that.getParams().length);
        for (int i = 0; i < params_result.length; ++i) {
            params_result[i] = this.getSymbolData(that.getParams()[i].getDeclarator().getType().getName(), this._symbolData, that.getParams()[i]);
        }
        TypeData[] throws_result = this.makeArrayOfRetType(that.getThrows().length);
        for (int i = 0; i < that.getThrows().length; ++i) {
            throws_result[i] = this.getSymbolData(that.getThrows()[i].getName(), this._symbolData, that.getThrows()[i]);
        }
        MethodData md = this._symbolData.getMethod(that.getName().getText(), params_result);
        if (md == null) {
            throw new RuntimeException("Internal Program Error: Could not find the method " + that.getName().getText() + " in interface " + this._symbolData.getName() + ".  Please report this bug.");
        }
        SymbolData.checkDifferentReturnTypes(md, this._symbolData, LanguageLevelConverter.OPT.javaVersion());
        return result_result;
    }

    @Override
    public TypeData forConcreteMethodDef(ConcreteMethodDef that) {
        InterfaceBodyTypeChecker._addError("Concrete method definitions cannot appear in interfaces", that);
        return null;
    }

    @Override
    public TypeData forTypeOnly(Type that) {
        Data sd = this.getSymbolData(that.getName(), this._symbolData, that);
        if (sd != null) {
            sd = sd.getOuterData();
        }
        while (sd != null && !LanguageLevelVisitor.isJavaLibraryClass(sd.getSymbolData().getName())) {
            if (!InterfaceBodyTypeChecker.checkAccessibility(that, sd.getMav(), sd.getName(), sd.getSymbolData(), this._symbolData, "class or interface")) {
                return null;
            }
            sd = sd.getOuterData();
        }
        return null;
    }

    static /* synthetic */ SymbolData access$000(InterfaceBodyTypeChecker x0) {
        return x0._symbolData;
    }
}

