/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.StatementEvaluator;
import edu.rice.cs.dynamicjava.interpreter.TreeClassLoader;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TreeClass;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ArrayType;
import edu.rice.cs.dynamicjava.symbol.type.BooleanType;
import edu.rice.cs.dynamicjava.symbol.type.BottomType;
import edu.rice.cs.dynamicjava.symbol.type.ByteType;
import edu.rice.cs.dynamicjava.symbol.type.CharType;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.DoubleType;
import edu.rice.cs.dynamicjava.symbol.type.FloatType;
import edu.rice.cs.dynamicjava.symbol.type.IntType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.LongType;
import edu.rice.cs.dynamicjava.symbol.type.NullType;
import edu.rice.cs.dynamicjava.symbol.type.ParameterizedClassType;
import edu.rice.cs.dynamicjava.symbol.type.PrimitiveType;
import edu.rice.cs.dynamicjava.symbol.type.ReferenceType;
import edu.rice.cs.dynamicjava.symbol.type.ShortType;
import edu.rice.cs.dynamicjava.symbol.type.TopType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.TypeAbstractVisitor_void;
import edu.rice.cs.dynamicjava.symbol.type.UnionType;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.dynamicjava.symbol.type.VoidType;
import edu.rice.cs.dynamicjava.symbol.type.Wildcard;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Runnable2;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.tuple.Pair;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Initializer;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.tiger.TypeParameter;
import koala.dynamicjava.tree.visitor.AbstractVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCompiler {
    private static final String ADAPTER_FIELD = "$adapter";
    private static final String BINDINGS_FACTORY_FIELD = "$bindingsFactory";
    private static final String RUNTIME_BINDINGS_NAME = org.objectweb.asm.Type.getInternalName(RuntimeBindings.class);
    private static final String EVALUATION_ADAPTER_NAME = org.objectweb.asm.Type.getInternalName(EvaluationAdapter.class);
    private static final String BINDINGS_FACTORY_NAME = org.objectweb.asm.Type.getInternalName(BindingsFactory.class);
    private static final String TREE_CLASS_LOADER_NAME = org.objectweb.asm.Type.getInternalName(TreeClassLoader.class);
    private static final String OBJECT_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Object.class);
    private static final String CLASS_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Class.class);
    private static final String CLASS_LOADER_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(ClassLoader.class);
    private static final String STRING_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(String.class);
    private static final String BOOLEAN_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Boolean.class);
    private static final String CHARACTER_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Character.class);
    private static final String BYTE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Byte.class);
    private static final String SHORT_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Short.class);
    private static final String INTEGER_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Integer.class);
    private static final String LONG_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Long.class);
    private static final String FLOAT_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Float.class);
    private static final String DOUBLE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Double.class);
    private static final String RUNTIME_BINDINGS_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(RuntimeBindings.class);
    private static final String EVALUATION_ADAPTER_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(EvaluationAdapter.class);
    private static final String BINDINGS_FACTORY_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(BindingsFactory.class);
    private final TreeClass _treeClass;
    private final Options _opt;
    private ClassWriter _classWriter;
    private final EvaluationAdapter _adapter;
    private final String _name;
    private final boolean _java5;
    private final Map<String, MethodDeclaration> _methods;
    private final Map<String, ConstructorDeclaration> _constructors;
    private final Map<String, Initializer> _initializers;
    private final Map<String, Expression> _expressions;
    private final List<Runnable2<MethodVisitor, StackSizeTracker>> _staticInits;
    private final List<Runnable2<MethodVisitor, StackSizeTracker>> _instanceInits;
    private static final String EVALUATE_METHOD_DESCRIPTOR = "(" + STRING_DESCRIPTOR + RUNTIME_BINDINGS_DESCRIPTOR + "[" + OBJECT_DESCRIPTOR + ")" + OBJECT_DESCRIPTOR;
    private static final String EVALUATE_EXPRESSION_DESCRIPTOR = "(" + STRING_DESCRIPTOR + RUNTIME_BINDINGS_DESCRIPTOR + ")" + OBJECT_DESCRIPTOR;
    private static final String EVALUATE_CONSTRUCTOR_CALL_ARG_DESCRIPTOR = "(" + STRING_DESCRIPTOR + "I" + RUNTIME_BINDINGS_DESCRIPTOR + "[" + OBJECT_DESCRIPTOR + ")" + OBJECT_DESCRIPTOR;
    private static final String EVALUATE_CONSTRUCTOR_BODY_DESCRIPTOR = "(" + STRING_DESCRIPTOR + RUNTIME_BINDINGS_DESCRIPTOR + "[" + OBJECT_DESCRIPTOR + ")V";
    private static final String EVALUATE_INITIALIZER_DESCRIPTOR = "(" + STRING_DESCRIPTOR + RUNTIME_BINDINGS_DESCRIPTOR + ")V";
    private static final String MAKE_BINDINGS_FACTORY_DESCRIPTOR = "(" + RUNTIME_BINDINGS_DESCRIPTOR + ")" + BINDINGS_FACTORY_DESCRIPTOR;
    private static final String BINDINGS_FACTORY_VALUE_DESCRIPTOR = "(" + OBJECT_DESCRIPTOR + ")" + RUNTIME_BINDINGS_DESCRIPTOR;

    public TreeCompiler(TreeClass treeClass, Options opt) {
        this._treeClass = treeClass;
        this._opt = opt;
        this._classWriter = null;
        this._adapter = new EvaluationAdapter();
        this._name = TreeCompiler.className(this._treeClass);
        this._java5 = JavaVersion.CURRENT.supports(JavaVersion.JAVA_5);
        this._methods = new HashMap<String, MethodDeclaration>();
        this._constructors = new HashMap<String, ConstructorDeclaration>();
        this._initializers = new HashMap<String, Initializer>();
        this._expressions = new HashMap<String, Expression>();
        this._staticInits = new LinkedList<Runnable2<MethodVisitor, StackSizeTracker>>();
        this._instanceInits = new LinkedList<Runnable2<MethodVisitor, StackSizeTracker>>();
    }

    public byte[] bytecode() {
        if (this._classWriter == null) {
            this._classWriter = new ClassWriter(0);
            this.compileClass(this._treeClass.declaration());
        }
        return this._classWriter.toByteArray();
    }

    private void dumpClassFile() {
        try {
            String name = this._treeClass.fullName();
            int dot = name.lastIndexOf(46);
            if (dot >= 0) {
                name = name.substring(dot);
            }
            FileOutputStream out = new FileOutputStream(name + ".class");
            ((OutputStream)out).write(this._classWriter.toByteArray());
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            System.out.println("Can't write bytes");
        }
    }

    public EvaluationAdapter evaluationAdapter() {
        return this._adapter;
    }

    private void compileClass(Node ast) {
        boolean isInterface;
        Type extendsT = TypeSystem.OBJECT;
        List<Object> implementsTs = CollectUtil.emptyList();
        List<Object> members = CollectUtil.emptyList();
        int accessFlags = 0;
        if (ast instanceof ClassDeclaration) {
            ClassDeclaration cd = (ClassDeclaration)ast;
            extendsT = NodeProperties.getType(cd.getSuperclass());
            if (cd.getInterfaces() != null) {
                implementsTs = cd.getInterfaces();
            }
            members = cd.getMembers();
            accessFlags = cd.getModifiers().getBitVector(new ModifierSet.Modifier[0]);
            isInterface = false;
        } else if (ast instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)ast;
            if (id.getInterfaces() != null) {
                implementsTs = id.getInterfaces();
            }
            members = id.getMembers();
            accessFlags = id.getModifiers().getBitVector(ModifierSet.Modifier.INTERFACE);
            isInterface = true;
        } else if (ast instanceof AnonymousAllocation) {
            AnonymousAllocation aa = (AnonymousAllocation)ast;
            ReferenceTypeName parent = aa.getCreationType();
            Type parentT = NodeProperties.getType(parent);
            if (TreeCompiler.extractClass(parentT).isInterface()) {
                implementsTs = Collections.singletonList(parent);
            } else {
                extendsT = parentT;
            }
            members = aa.getMembers();
            isInterface = false;
        } else if (ast instanceof AnonymousInnerAllocation) {
            extendsT = NodeProperties.getSuperType(ast);
            members = ((AnonymousInnerAllocation)ast).getMembers();
            isInterface = false;
        } else {
            throw new RuntimeException("Unexpected class AST node type: " + ast);
        }
        accessFlags = TreeCompiler.defaultToPublicAccess(accessFlags);
        String classSig = null;
        if (this._java5) {
            List paramAsts = Collections.emptyList();
            if (ast instanceof TypeDeclaration) {
                paramAsts = ((TypeDeclaration)ast).getTypeParams().unwrap(paramAsts);
            }
            StringBuilder sigBuilder = new StringBuilder();
            if (!paramAsts.isEmpty()) {
                sigBuilder.append(TreeCompiler.typeParamListSignature(paramAsts));
            }
            sigBuilder.append(TreeCompiler.typeSignature(extendsT));
            for (ReferenceTypeName referenceTypeName : implementsTs) {
                sigBuilder.append(TreeCompiler.typeSignature(NodeProperties.getType(referenceTypeName)));
            }
            classSig = sigBuilder.toString();
        }
        this._classWriter.visit(this._java5 ? 49 : 48, accessFlags, this._name, classSig, TreeCompiler.className(TreeCompiler.extractClass(extendsT)), TreeCompiler.extractClassNames(implementsTs));
        DJClass declaring = this._treeClass.declaringClass();
        if (declaring != null) {
            this._classWriter.visitOuterClass(TreeCompiler.className(declaring), null, null);
            this._classWriter.visitInnerClass(this._name, TreeCompiler.className(declaring), this._treeClass.declaredName(), accessFlags);
        }
        if (isInterface) {
            this._classWriter.visitField(4121, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR, null, null).visitEnd();
        } else {
            this._classWriter.visitField(4122, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR, null, null).visitEnd();
            this._classWriter.visitField(4112, BINDINGS_FACTORY_FIELD, BINDINGS_FACTORY_DESCRIPTOR, null, null).visitEnd();
        }
        final LinkedList constructors = new LinkedList();
        for (Node node : members) {
            node.acceptVisitor(new AbstractVisitor<Void>(){

                @Override
                public Void defaultCase(Node member) {
                    return null;
                }

                @Override
                public Void visit(ClassDeclaration member) {
                    TreeCompiler.this.recordInnerClass(member, isInterface);
                    return null;
                }

                @Override
                public Void visit(InterfaceDeclaration member) {
                    TreeCompiler.this.recordInnerClass(member, isInterface);
                    return null;
                }

                @Override
                public Void visit(ConstructorDeclaration member) {
                    constructors.add(member);
                    return null;
                }

                @Override
                public Void visit(MethodDeclaration member) {
                    TreeCompiler.this.compileMethod(member, isInterface);
                    return null;
                }

                @Override
                public Void visit(FieldDeclaration member) {
                    TreeCompiler.this.compileField(member, isInterface);
                    return null;
                }

                @Override
                public Void visit(ClassInitializer member) {
                    TreeCompiler.this.compileInitializerBlock(member, true);
                    return null;
                }

                @Override
                public Void visit(InstanceInitializer member) {
                    TreeCompiler.this.compileInitializerBlock(member, false);
                    return null;
                }
            });
        }
        this.compileClassInitializer();
        if (ast instanceof AnonymousAllocation) {
            this.compileAnonymousConstructor((AnonymousAllocation)ast);
        } else if (ast instanceof AnonymousInnerAllocation) {
            this.compileAnonymousInnerConstructor((AnonymousInnerAllocation)ast);
        } else if (ast instanceof ClassDeclaration) {
            if (constructors.isEmpty()) {
                this.compileDefaultConstructor(extendsT);
            } else {
                for (ConstructorDeclaration constructorDeclaration : constructors) {
                    this.compileConstructor(constructorDeclaration, extendsT);
                }
            }
        }
        this._classWriter.visitEnd();
    }

    private void recordInnerClass(TypeDeclaration ast, boolean isInterface) {
        int access = isInterface ? ast.getModifiers().getBitVector(ModifierSet.Modifier.STATIC, ModifierSet.Modifier.FINAL) : ast.getModifiers().getBitVector(new ModifierSet.Modifier[0]);
        this._classWriter.visitInnerClass(TreeCompiler.className(NodeProperties.getDJClass(ast)), this._name, ast.getName(), access);
    }

    private void compileDefaultConstructor(Type extendsT) {
        String methodSig;
        String methodDescriptor;
        DJClass outerC = SymbolUtil.dynamicOuterClass(this._treeClass);
        if (outerC == null) {
            methodDescriptor = "(" + RUNTIME_BINDINGS_DESCRIPTOR + ")V";
            methodSig = null;
        } else {
            ClassType outerT = SymbolUtil.thisType(outerC);
            methodDescriptor = "(" + this.typeDescriptor(outerT) + ")V";
            methodSig = this._java5 ? "(" + TreeCompiler.typeSignature(outerT) + ")V" : null;
        }
        MethodVisitor mv = this._classWriter.visitMethod(1, "<init>", methodDescriptor, methodSig, null);
        StackSizeTracker stack = new StackSizeTracker(2);
        mv.visitCode();
        int bindingsVar = this.emitPartialBindingsVar(mv, outerC, stack);
        this.emitBindingsFactoryAssignment(mv, bindingsVar, stack);
        this.emitDefaultSuperCall(mv, extendsT, bindingsVar, stack);
        for (Runnable2<MethodVisitor, StackSizeTracker> initCode : this._instanceInits) {
            initCode.run(mv, stack);
        }
        mv.visitInsn(177);
        mv.visitMaxs(stack.maxStack(), stack.maxLocals());
        mv.visitEnd();
    }

    private void compileAnonymousConstructor(AnonymousAllocation ast) {
        MethodVisitor mv = this._classWriter.visitMethod(1, "<init>", "(" + RUNTIME_BINDINGS_DESCRIPTOR + ")V", null, null);
        StackSizeTracker stack = new StackSizeTracker(2);
        mv.visitCode();
        this.emitBindingsFactoryAssignment(mv, 1, stack);
        Type superT = NodeProperties.getType(ast.getCreationType());
        DJClass superC = TreeCompiler.extractClass(superT);
        if (superC.isInterface()) {
            this.emitDefaultSuperCall(mv, TypeSystem.OBJECT, 1, stack);
        } else {
            stack.mark();
            mv.visitVarInsn(25, 0);
            stack.adjust(1);
            boolean includeBindings = superC.hasRuntimeBindingsParams();
            String extraArg = "";
            if (includeBindings) {
                extraArg = RUNTIME_BINDINGS_DESCRIPTOR;
                mv.visitVarInsn(25, 1);
                stack.adjust(1);
            }
            DJConstructor superTarget = NodeProperties.getConstructor(ast).declaredSignature();
            List<Expression> superArgs = ast.getArguments();
            if (superArgs != null) {
                this.emitAnonSuperArgs(mv, superTarget, superArgs, stack);
            }
            mv.visitMethodInsn(183, TreeCompiler.className(superC), "<init>", this.paramListDescriptor(extraArg, superTarget.parameters()) + "V");
            stack.reset();
        }
        for (Runnable2<MethodVisitor, StackSizeTracker> initCode : this._instanceInits) {
            initCode.run(mv, stack);
        }
        mv.visitInsn(177);
        mv.visitMaxs(stack.maxStack(), stack.maxLocals());
        mv.visitEnd();
    }

    private void compileAnonymousInnerConstructor(AnonymousInnerAllocation ast) {
        MethodVisitor mv = this._classWriter.visitMethod(1, "<init>", "(" + RUNTIME_BINDINGS_DESCRIPTOR + ")V", null, null);
        StackSizeTracker stack = new StackSizeTracker(2);
        mv.visitCode();
        this.emitBindingsFactoryAssignment(mv, 1, stack);
        Type superT = NodeProperties.getSuperType(ast);
        DJClass superC = TreeCompiler.extractClass(superT);
        DJClass superOuterC = SymbolUtil.dynamicOuterClass(superC);
        stack.mark();
        mv.visitVarInsn(25, 0);
        stack.adjust(1);
        String outerExpKey = "anon super arg outer";
        this._expressions.put(outerExpKey, ast.getExpression());
        mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
        mv.visitLdcInsn(outerExpKey);
        mv.visitVarInsn(25, 1);
        stack.adjust(3);
        mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateExpression", EVALUATE_EXPRESSION_DESCRIPTOR);
        stack.adjust(-2);
        DJConstructor superTarget = NodeProperties.getConstructor(ast).declaredSignature();
        List<Expression> superArgs = ast.getArguments();
        if (superArgs != null) {
            this.emitAnonSuperArgs(mv, superTarget, superArgs, stack);
        }
        String callDescriptor = this.paramListDescriptor(this.typeDescriptor(SymbolUtil.thisType(superOuterC)), superTarget.parameters()) + "V";
        mv.visitMethodInsn(183, TreeCompiler.className(superC), "<init>", callDescriptor);
        stack.reset();
        for (Runnable2<MethodVisitor, StackSizeTracker> initCode : this._instanceInits) {
            initCode.run(mv, stack);
        }
        mv.visitInsn(177);
        mv.visitMaxs(stack.maxStack(), stack.maxLocals());
        mv.visitEnd();
    }

    private void compileConstructor(ConstructorDeclaration ast, Type extendsT) {
        boolean callsSuper;
        DJClass outerC = SymbolUtil.dynamicOuterClass(this._treeClass);
        ClassType outerT = outerC == null ? null : SymbolUtil.thisType(outerC);
        List<FormalParameter> params = ast.getParameters();
        List<? extends ReferenceTypeName> exceptions = ast.getExceptions();
        String firstArgDescriptor = outerT == null ? RUNTIME_BINDINGS_DESCRIPTOR : this.typeDescriptor(outerT);
        String methodDescriptor = this.paramListDescriptor(firstArgDescriptor, TreeCompiler.extractVars(params)) + "V";
        String methodSig = null;
        if (this._java5) {
            List typeParamAsts = ast.getTypeParams().unwrap(Collections.emptyList());
            StringBuilder sigBuilder = new StringBuilder();
            if (!typeParamAsts.isEmpty()) {
                sigBuilder.append(TreeCompiler.typeParamListSignature(typeParamAsts));
            }
            String firstArgSig = outerT == null ? RUNTIME_BINDINGS_DESCRIPTOR : TreeCompiler.typeSignature(outerT);
            sigBuilder.append(TreeCompiler.paramListSignature(firstArgSig, TreeCompiler.extractVars(params)));
            sigBuilder.append("V");
            for (ReferenceTypeName referenceTypeName : exceptions) {
                sigBuilder.append('^').append(TreeCompiler.typeSignature(NodeProperties.getType(referenceTypeName)));
            }
            methodSig = sigBuilder.toString();
        }
        int access = TreeCompiler.defaultToProtectedAccess(ast.getModifiers().getBitVector(new ModifierSet.Modifier[0]));
        MethodVisitor mv = this._classWriter.visitMethod(access, "<init>", methodDescriptor, methodSig, TreeCompiler.extractClassNames(exceptions));
        String key = methodDescriptor;
        this._constructors.put(key, ast);
        int[] paramLocations = TreeCompiler.computeParamLocations(params, 2);
        StackSizeTracker stackSizeTracker = new StackSizeTracker(paramLocations[params.size()]);
        mv.visitCode();
        int bindingsVar = this.emitPartialBindingsVar(mv, outerC, stackSizeTracker);
        int boxedParamsVar = this.emitBoxParams(mv, params, paramLocations, stackSizeTracker);
        ConstructorCall call = ast.getConstructorCall();
        if (call == null) {
            callsSuper = true;
            this.emitBindingsFactoryAssignment(mv, bindingsVar, stackSizeTracker);
            this.emitDefaultSuperCall(mv, extendsT, bindingsVar, stackSizeTracker);
        } else {
            callsSuper = call.isSuper();
            if (callsSuper) {
                this.emitBindingsFactoryAssignment(mv, bindingsVar, stackSizeTracker);
            }
            DJConstructor callTarget = NodeProperties.getConstructor(call).declaredSignature();
            DJClass extendsC = TreeCompiler.extractClass(extendsT);
            stackSizeTracker.mark();
            mv.visitVarInsn(25, 0);
            stackSizeTracker.adjust(1);
            String extraArg = "";
            if (call.getExpression() == null) {
                if (callsSuper) {
                    if (extendsC.hasRuntimeBindingsParams()) {
                        extraArg = RUNTIME_BINDINGS_DESCRIPTOR;
                        mv.visitVarInsn(25, bindingsVar);
                        stackSizeTracker.adjust(1);
                    }
                } else if (outerC == null) {
                    extraArg = RUNTIME_BINDINGS_DESCRIPTOR;
                    mv.visitVarInsn(25, bindingsVar);
                    stackSizeTracker.adjust(1);
                } else {
                    extraArg = this.typeDescriptor(outerT);
                    mv.visitVarInsn(25, 1);
                    stackSizeTracker.adjust(1);
                }
            } else {
                extraArg = callsSuper ? this.typeDescriptor(SymbolUtil.thisType(SymbolUtil.dynamicOuterClass(extendsC))) : this.typeDescriptor(outerT);
                mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
                mv.visitLdcInsn(key);
                stackSizeTracker.adjust(2);
                this.emitIntConstant(mv, -1, stackSizeTracker);
                mv.visitVarInsn(25, bindingsVar);
                mv.visitVarInsn(25, boxedParamsVar);
                stackSizeTracker.adjust(2);
                mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateConstructorCallArg", EVALUATE_CONSTRUCTOR_CALL_ARG_DESCRIPTOR);
                stackSizeTracker.adjust(-4);
            }
            int i = 0;
            for (Pair pair : IterUtil.zip(callTarget.parameters(), call.getArguments())) {
                Type paramT = ((LocalVariable)pair.first()).type();
                Object val = TreeCompiler.expressionConstantVal((Expression)pair.second());
                if (val == null) {
                    mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
                    mv.visitLdcInsn(key);
                    stackSizeTracker.adjust(2);
                    this.emitIntConstant(mv, i, stackSizeTracker);
                    mv.visitVarInsn(25, bindingsVar);
                    mv.visitVarInsn(25, boxedParamsVar);
                    stackSizeTracker.adjust(2);
                    mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateConstructorCallArg", EVALUATE_CONSTRUCTOR_CALL_ARG_DESCRIPTOR);
                    stackSizeTracker.adjust(-4);
                    this.emitConvert(mv, paramT, stackSizeTracker);
                } else {
                    this.emitConstant(mv, val, stackSizeTracker);
                }
                ++i;
            }
            mv.visitMethodInsn(183, callsSuper ? TreeCompiler.className(extendsC) : this._name, "<init>", this.paramListDescriptor(extraArg, callTarget.parameters()) + "V");
            stackSizeTracker.reset();
        }
        if (callsSuper) {
            for (Runnable2<MethodVisitor, StackSizeTracker> initCode : this._instanceInits) {
                initCode.run(mv, stackSizeTracker);
            }
        }
        mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
        mv.visitLdcInsn(key);
        stackSizeTracker.adjust(2);
        this.emitLoadBindings(mv, 0, this._name, stackSizeTracker);
        mv.visitVarInsn(25, boxedParamsVar);
        stackSizeTracker.adjust(1);
        mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateConstructorBody", EVALUATE_CONSTRUCTOR_BODY_DESCRIPTOR);
        stackSizeTracker.adjust(-4);
        mv.visitInsn(177);
        mv.visitMaxs(stackSizeTracker.maxStack(), stackSizeTracker.maxLocals());
        mv.visitEnd();
    }

    private void compileClassInitializer() {
        MethodVisitor mv = this._classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        StackSizeTracker stack = new StackSizeTracker(0);
        mv.visitCode();
        mv.visitLdcInsn(this._treeClass.fullName());
        stack.adjust(1);
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(" + STRING_DESCRIPTOR + ")" + CLASS_DESCRIPTOR);
        mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()" + CLASS_LOADER_DESCRIPTOR);
        mv.visitTypeInsn(192, TREE_CLASS_LOADER_NAME);
        mv.visitLdcInsn(this._treeClass.fullName());
        stack.adjust(1);
        mv.visitMethodInsn(182, TREE_CLASS_LOADER_NAME, "getAdapter", "(" + STRING_DESCRIPTOR + ")" + EVALUATION_ADAPTER_DESCRIPTOR);
        stack.adjust(-1);
        mv.visitFieldInsn(179, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
        stack.adjust(-1);
        for (Runnable2<MethodVisitor, StackSizeTracker> initCode : this._staticInits) {
            initCode.run(mv, stack);
        }
        mv.visitInsn(177);
        mv.visitMaxs(stack.maxStack(), stack.maxLocals());
        mv.visitEnd();
    }

    private void compileMethod(MethodDeclaration ast, boolean isInterface) {
        int access;
        int n = access = isInterface ? ast.getModifiers().getBitVector(ModifierSet.Modifier.ABSTRACT) : ast.getModifiers().getBitVector(new ModifierSet.Modifier[0]);
        if (isInterface) {
            access = TreeCompiler.defaultToPublicAccess(access);
        }
        List<FormalParameter> params = ast.getParameters();
        Type returnT = NodeProperties.getType(ast.getReturnType());
        List<? extends ReferenceTypeName> exceptions = ast.getExceptions();
        boolean isStatic = Modifier.isStatic(access);
        String extraArg = isStatic ? RUNTIME_BINDINGS_DESCRIPTOR : "";
        String methodDescriptor = this.paramListDescriptor(extraArg, TreeCompiler.extractVars(params)) + this.typeDescriptor(returnT);
        String methodSig = null;
        if (this._java5) {
            List typeParamAsts = ast.getTypeParams().unwrap(Collections.emptyList());
            StringBuilder sigBuilder = new StringBuilder();
            if (!typeParamAsts.isEmpty()) {
                sigBuilder.append(TreeCompiler.typeParamListSignature(typeParamAsts));
            }
            sigBuilder.append(TreeCompiler.paramListSignature(extraArg, TreeCompiler.extractVars(params)));
            sigBuilder.append(TreeCompiler.typeSignature(returnT));
            for (ReferenceTypeName referenceTypeName : exceptions) {
                sigBuilder.append('^').append(TreeCompiler.typeSignature(NodeProperties.getType(referenceTypeName)));
            }
            methodSig = sigBuilder.toString();
        }
        final MethodVisitor mv = this._classWriter.visitMethod(access, ast.getName(), methodDescriptor, methodSig, TreeCompiler.extractClassNames(exceptions));
        if (!Modifier.isAbstract(access) && !Modifier.isNative(access)) {
            String key = ast.getName() + methodDescriptor;
            this._methods.put(key, ast);
            int[] paramLocations = TreeCompiler.computeParamLocations(params, 1);
            StackSizeTracker stackSizeTracker = new StackSizeTracker(paramLocations[params.size()]);
            mv.visitCode();
            int boxedParamsVar = this.emitBoxParams(mv, params, paramLocations, stackSizeTracker);
            mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
            mv.visitLdcInsn(key);
            stackSizeTracker.adjust(2);
            if (isStatic) {
                mv.visitVarInsn(25, 0);
                stackSizeTracker.adjust(1);
            } else {
                this.emitLoadBindings(mv, 0, this._name, stackSizeTracker);
            }
            mv.visitVarInsn(25, boxedParamsVar);
            stackSizeTracker.adjust(1);
            mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateMethod", EVALUATE_METHOD_DESCRIPTOR);
            stackSizeTracker.adjust(-3);
            stackSizeTracker.mark();
            this.emitConvert(mv, returnT, stackSizeTracker);
            this._opt.typeSystem().erase(returnT).apply(new TypeAbstractVisitor_void(){

                public void forReferenceType(ReferenceType t) {
                    mv.visitInsn(176);
                }

                public void forPrimitiveType(PrimitiveType t) {
                    mv.visitInsn(172);
                }

                public void forLongType(LongType t) {
                    mv.visitInsn(173);
                }

                public void forFloatType(FloatType t) {
                    mv.visitInsn(174);
                }

                public void forDoubleType(DoubleType t) {
                    mv.visitInsn(175);
                }

                public void forVoidType(VoidType t) {
                    mv.visitInsn(177);
                }
            });
            stackSizeTracker.reset();
            mv.visitMaxs(stackSizeTracker.maxStack(), stackSizeTracker.maxLocals());
        }
        mv.visitEnd();
    }

    private void compileField(final FieldDeclaration ast, boolean isInterface) {
        int access;
        int n = access = isInterface ? ast.getModifiers().getBitVector(ModifierSet.Modifier.STATIC, ModifierSet.Modifier.FINAL) : ast.getModifiers().getBitVector(new ModifierSet.Modifier[0]);
        if (isInterface) {
            access = TreeCompiler.defaultToPublicAccess(access);
        }
        final boolean isStatic = Modifier.isStatic(access);
        final Type t = NodeProperties.getType(ast.getType());
        Expression init = ast.getInitializer();
        Object val = null;
        if (isStatic && init != null) {
            val = TreeCompiler.expressionConstantVal(init);
        }
        this._classWriter.visitField(access, ast.getName(), this.typeDescriptor(t), TreeCompiler.typeSignature(t), val).visitEnd();
        if (init != null && val == null) {
            final String key = ast.getName();
            this._expressions.put(key, init);
            (isStatic ? this._staticInits : this._instanceInits).add(new Runnable2<MethodVisitor, StackSizeTracker>(){

                @Override
                public void run(MethodVisitor mv, StackSizeTracker stack) {
                    stack.mark();
                    if (!isStatic) {
                        mv.visitVarInsn(25, 0);
                        stack.adjust(1);
                    }
                    mv.visitFieldInsn(178, TreeCompiler.this._name, TreeCompiler.ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
                    mv.visitLdcInsn(key);
                    stack.adjust(2);
                    if (isStatic) {
                        mv.visitFieldInsn(178, RUNTIME_BINDINGS_NAME, "EMPTY", RUNTIME_BINDINGS_DESCRIPTOR);
                        stack.adjust(1);
                    } else {
                        TreeCompiler.this.emitLoadBindings(mv, 0, TreeCompiler.this._name, stack);
                    }
                    mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateExpression", EVALUATE_EXPRESSION_DESCRIPTOR);
                    stack.adjust(-2);
                    TreeCompiler.this.emitConvert(mv, t, stack);
                    if (isStatic) {
                        mv.visitFieldInsn(179, TreeCompiler.this._name, ast.getName(), TreeCompiler.this.typeDescriptor(t));
                    } else {
                        mv.visitFieldInsn(181, TreeCompiler.this._name, ast.getName(), TreeCompiler.this.typeDescriptor(t));
                    }
                    stack.reset();
                }
            });
        }
    }

    private void compileInitializerBlock(Initializer ast, final boolean isStatic) {
        final String key = (isStatic ? "class init " : "instance init ") + this._initializers.size();
        this._initializers.put(key, ast);
        (isStatic ? this._staticInits : this._instanceInits).add(new Runnable2<MethodVisitor, StackSizeTracker>(){

            @Override
            public void run(MethodVisitor mv, StackSizeTracker stack) {
                mv.visitFieldInsn(178, TreeCompiler.this._name, TreeCompiler.ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
                mv.visitLdcInsn(key);
                stack.adjust(2);
                if (isStatic) {
                    mv.visitFieldInsn(178, RUNTIME_BINDINGS_NAME, "EMPTY", RUNTIME_BINDINGS_DESCRIPTOR);
                    stack.adjust(1);
                } else {
                    TreeCompiler.this.emitLoadBindings(mv, 0, TreeCompiler.this._name, stack);
                }
                mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateInitializer", EVALUATE_INITIALIZER_DESCRIPTOR);
                stack.adjust(-3);
            }
        });
    }

    private void emitConstant(MethodVisitor mv, Object val, StackSizeTracker stack) {
        if (val instanceof Integer) {
            this.emitIntConstant(mv, (Integer)val, stack);
        } else {
            mv.visitLdcInsn(val);
            if (val instanceof Long || val instanceof Double) {
                stack.adjust(2);
            } else {
                stack.adjust(1);
            }
        }
    }

    private void emitIntConstant(MethodVisitor mv, int val, StackSizeTracker stack) {
        switch (val) {
            case -1: {
                mv.visitInsn(2);
                break;
            }
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                if (val >= -128 && val <= 127) {
                    mv.visitIntInsn(16, val);
                    break;
                }
                if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                    mv.visitIntInsn(17, val);
                    break;
                }
                mv.visitLdcInsn(val);
            }
        }
        stack.adjust(1);
    }

    private int emitPartialBindingsVar(MethodVisitor mv, DJClass outerC, StackSizeTracker stack) {
        if (outerC == null) {
            return 1;
        }
        int result = stack.newVariable();
        this.emitLoadBindings(mv, 1, TreeCompiler.className(outerC), stack);
        mv.visitVarInsn(58, result);
        stack.adjust(-1);
        return result;
    }

    private void emitBindingsFactoryAssignment(MethodVisitor mv, int bindingsVar, StackSizeTracker stack) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
        mv.visitVarInsn(25, bindingsVar);
        stack.adjust(3);
        mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "makeBindingsFactory", MAKE_BINDINGS_FACTORY_DESCRIPTOR);
        stack.adjust(-1);
        mv.visitFieldInsn(181, this._name, BINDINGS_FACTORY_FIELD, BINDINGS_FACTORY_DESCRIPTOR);
        stack.adjust(-2);
    }

    private void emitDefaultSuperCall(MethodVisitor mv, Type extendsT, int bindingsVar, StackSizeTracker stack) {
        DJClass extendsC = TreeCompiler.extractClass(extendsT);
        mv.visitVarInsn(25, 0);
        stack.adjust(1);
        if (extendsC.hasRuntimeBindingsParams()) {
            mv.visitVarInsn(25, bindingsVar);
            stack.adjust(1);
            mv.visitMethodInsn(183, TreeCompiler.className(extendsC), "<init>", "(" + RUNTIME_BINDINGS_DESCRIPTOR + ")V");
            stack.adjust(-2);
        } else {
            mv.visitMethodInsn(183, TreeCompiler.className(extendsC), "<init>", "()V");
            stack.adjust(-1);
        }
    }

    private void emitLoadBindings(MethodVisitor mv, int thisVar, String thisClassName, StackSizeTracker stack) {
        mv.visitVarInsn(25, thisVar);
        stack.adjust(1);
        mv.visitFieldInsn(180, thisClassName, BINDINGS_FACTORY_FIELD, BINDINGS_FACTORY_DESCRIPTOR);
        mv.visitVarInsn(25, thisVar);
        stack.adjust(1);
        mv.visitMethodInsn(182, BINDINGS_FACTORY_NAME, "value", BINDINGS_FACTORY_VALUE_DESCRIPTOR);
        stack.adjust(-1);
    }

    private void emitAnonSuperArgs(MethodVisitor mv, DJConstructor k, List<Expression> args, StackSizeTracker stack) {
        int i = 0;
        for (Pair pair : IterUtil.zip(k.parameters(), args)) {
            String key = "anon super arg " + i;
            this._expressions.put(key, (Expression)pair.second());
            Type paramT = ((LocalVariable)pair.first()).type();
            Object val = TreeCompiler.expressionConstantVal((Expression)pair.second());
            if (val == null) {
                mv.visitFieldInsn(178, this._name, ADAPTER_FIELD, EVALUATION_ADAPTER_DESCRIPTOR);
                mv.visitLdcInsn(key);
                mv.visitVarInsn(25, 1);
                stack.adjust(3);
                mv.visitMethodInsn(182, EVALUATION_ADAPTER_NAME, "evaluateExpression", EVALUATE_EXPRESSION_DESCRIPTOR);
                stack.adjust(-2);
                this.emitConvert(mv, paramT, stack);
            } else {
                this.emitConstant(mv, val, stack);
            }
            ++i;
        }
    }

    private int emitBoxParams(MethodVisitor mv, List<FormalParameter> params, int[] paramLocations, StackSizeTracker stack) {
        this.emitIntConstant(mv, params.size(), stack);
        mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        for (FormalParameter param : params) {
            Type t = NodeProperties.getVariable(param).type();
            mv.visitInsn(89);
            stack.adjust(1);
            this.emitIntConstant(mv, i, stack);
            this.emitLoadAndBox(mv, t, paramLocations[i], stack);
            mv.visitInsn(83);
            stack.adjust(-3);
            ++i;
        }
        int result = stack.newVariable();
        mv.visitVarInsn(58, result);
        stack.adjust(-1);
        return result;
    }

    private void emitLoadAndBox(final MethodVisitor mv, Type t, final int var, final StackSizeTracker stack) {
        t.apply(new TypeAbstractVisitor_void(){

            public void defaultCase(Type t) {
                mv.visitVarInsn(25, var);
                stack.adjust(1);
            }

            public void forBooleanType(BooleanType t) {
                mv.visitVarInsn(21, var);
                stack.adjust(1);
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)" + BOOLEAN_DESCRIPTOR);
            }

            public void forCharType(CharType t) {
                this.generateBoxingCode(21, 1, "java/lang/Character", CHARACTER_DESCRIPTOR, "C");
            }

            public void forByteType(ByteType t) {
                this.generateBoxingCode(21, 1, "java/lang/Byte", BYTE_DESCRIPTOR, "B");
            }

            public void forShortType(ShortType t) {
                this.generateBoxingCode(21, 1, "java/lang/Short", SHORT_DESCRIPTOR, "S");
            }

            public void forIntType(IntType t) {
                this.generateBoxingCode(21, 1, "java/lang/Integer", INTEGER_DESCRIPTOR, "I");
            }

            public void forLongType(LongType t) {
                this.generateBoxingCode(22, 2, "java/lang/Long", LONG_DESCRIPTOR, "J");
            }

            public void forFloatType(FloatType t) {
                this.generateBoxingCode(23, 1, "java/lang/Float", FLOAT_DESCRIPTOR, "F");
            }

            public void forDoubleType(DoubleType t) {
                this.generateBoxingCode(24, 2, "java/lang/Double", DOUBLE_DESCRIPTOR, "D");
            }

            private void generateBoxingCode(int loadOp, int size, String className, String boxedDescriptor, String primDescriptor) {
                if (TreeCompiler.this._java5) {
                    mv.visitVarInsn(loadOp, var);
                    stack.adjust(size);
                    mv.visitMethodInsn(184, className, "valueOf", "(" + primDescriptor + ")" + boxedDescriptor);
                    stack.adjust(-size + 1);
                } else {
                    mv.visitTypeInsn(187, className);
                    mv.visitInsn(89);
                    stack.adjust(2);
                    mv.visitVarInsn(loadOp, var);
                    stack.adjust(size);
                    mv.visitMethodInsn(183, className, "<init>", "(" + primDescriptor + ")V");
                    stack.adjust(-size - 1);
                }
            }
        });
    }

    private void emitConvert(final MethodVisitor mv, Type expectedT, final StackSizeTracker stack) {
        this._opt.typeSystem().erase(expectedT).apply(new TypeAbstractVisitor_void(){

            public void forArrayType(ArrayType t) {
                mv.visitTypeInsn(192, TreeCompiler.this.typeDescriptor(t));
            }

            public void forClassType(ClassType t) {
                if (!t.equals(TypeSystem.OBJECT)) {
                    mv.visitTypeInsn(192, TreeCompiler.className(t.ofClass()));
                }
            }

            public void forBooleanType(BooleanType t) {
                this.generateUnboxingCode(1, "java/lang/Boolean", "booleanValue", "Z");
            }

            public void forCharType(CharType t) {
                this.generateUnboxingCode(1, "java/lang/Character", "charValue", "C");
            }

            public void forByteType(ByteType t) {
                this.generateUnboxingCode(1, "java/lang/Byte", "byteValue", "B");
            }

            public void forShortType(ShortType t) {
                this.generateUnboxingCode(1, "java/lang/Short", "shortValue", "S");
            }

            public void forIntType(IntType t) {
                this.generateUnboxingCode(1, "java/lang/Integer", "intValue", "I");
            }

            public void forLongType(LongType t) {
                this.generateUnboxingCode(2, "java/lang/Long", "longValue", "J");
            }

            public void forFloatType(FloatType t) {
                this.generateUnboxingCode(1, "java/lang/Float", "floatValue", "F");
            }

            public void forDoubleType(DoubleType t) {
                this.generateUnboxingCode(2, "java/lang/Double", "doubleValue", "D");
            }

            private void generateUnboxingCode(int size, String className, String methodName, String primDescriptor) {
                mv.visitTypeInsn(192, className);
                mv.visitMethodInsn(182, className, methodName, "()" + primDescriptor);
                stack.adjust(-1 + size);
            }
        });
    }

    private void emitDebug(MethodVisitor mv, String message, StackSizeTracker stack) {
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mv.visitLdcInsn(message);
        stack.adjust(2);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        stack.adjust(-2);
    }

    private void emitPrintToString(MethodVisitor mv, StackSizeTracker stack) {
        mv.visitInsn(89);
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        stack.adjust(2);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V");
        stack.adjust(-2);
    }

    private static String typeSignature(Type t) {
        return TreeCompiler.encodeType(t);
    }

    private String typeDescriptor(Type t) {
        return TreeCompiler.encodeType(this._opt.typeSystem().erase(t));
    }

    private static String className(DJClass c) {
        return c.fullName().replace('.', '/');
    }

    private static DJClass extractClass(Type t) {
        if (t instanceof ClassType) {
            return ((ClassType)t).ofClass();
        }
        throw new IllegalArgumentException("Expected ClassType, but given " + t.getClass().getName());
    }

    private static String[] extractClassNames(List<? extends ReferenceTypeName> types) {
        String[] result = new String[types.size()];
        int i = 0;
        for (ReferenceTypeName referenceTypeName : types) {
            result[i++] = TreeCompiler.className(TreeCompiler.extractClass(NodeProperties.getType(referenceTypeName)));
        }
        return result;
    }

    private static String typeParamListSignature(Iterable<? extends TypeParameter> params) {
        StringBuilder result = new StringBuilder();
        result.append('<');
        for (TypeParameter typeParameter : params) {
            VariableType t = NodeProperties.getTypeVariable(typeParameter);
            result.append(t.symbol().name());
            Type upper = t.symbol().upperBound();
            boolean validIntersection = false;
            if (upper instanceof IntersectionType) {
                for (Type type : ((IntersectionType)upper).ofTypes()) {
                    validIntersection = true;
                    result.append(':').append(TreeCompiler.typeSignature(type));
                }
            }
            if (validIntersection) continue;
            result.append(':').append(TreeCompiler.typeSignature(upper));
        }
        result.append('>');
        return result.toString();
    }

    private static Iterable<LocalVariable> extractVars(Iterable<? extends FormalParameter> params) {
        return IterUtil.map(params, NodeProperties.NODE_VARIABLE);
    }

    private static String paramListSignature(String prefix, Iterable<LocalVariable> params) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        result.append(prefix);
        for (LocalVariable var : params) {
            result.append(TreeCompiler.typeSignature(var.type()));
        }
        result.append(')');
        return result.toString();
    }

    private String paramListDescriptor(String prefix, Iterable<LocalVariable> params) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        result.append(prefix);
        for (LocalVariable var : params) {
            result.append(this.typeDescriptor(var.type()));
        }
        result.append(')');
        return result.toString();
    }

    private static String encodeType(Type t) {
        final StringBuilder result = new StringBuilder();
        t.apply(new TypeAbstractVisitor_void(){

            public void forBooleanType(BooleanType t) {
                result.append('Z');
            }

            public void forCharType(CharType t) {
                result.append('C');
            }

            public void forByteType(ByteType t) {
                result.append('B');
            }

            public void forShortType(ShortType t) {
                result.append('S');
            }

            public void forIntType(IntType t) {
                result.append('I');
            }

            public void forLongType(LongType t) {
                result.append('J');
            }

            public void forFloatType(FloatType t) {
                result.append('F');
            }

            public void forDoubleType(DoubleType t) {
                result.append('D');
            }

            public void forNullType(NullType t) {
                result.append(OBJECT_DESCRIPTOR);
            }

            public void forArrayType(ArrayType t) {
                result.append('[');
                t.ofType().apply(this);
            }

            public void forClassType(ClassType t) {
                result.append('L');
                boolean first = true;
                for (DJClass c : SymbolUtil.outerClassChain(t.ofClass())) {
                    if (first) {
                        result.append(TreeCompiler.className(c));
                        first = false;
                        continue;
                    }
                    result.append('$').append(c.declaredName());
                }
                result.append(';');
            }

            public void forParameterizedClassType(ParameterizedClassType t) {
                result.append('L');
                Character classDelim = null;
                Iterator<? extends Type> args = t.typeArguments().iterator();
                DJClass tClass = t.ofClass();
                for (DJClass c : SymbolUtil.outerClassChain(tClass)) {
                    Iterable<VariableType> params;
                    if (classDelim == null) {
                        result.append(TreeCompiler.className(c));
                    } else {
                        result.append(classDelim).append(c.declaredName());
                    }
                    classDelim = Character.valueOf('$');
                    if (!SymbolUtil.dynamicallyEncloses(c, tClass) || IterUtil.isEmpty(params = c.declaredTypeParameters())) continue;
                    result.append('<');
                    for (VariableType param : params) {
                        args.next().apply(this);
                    }
                    result.append('>');
                    classDelim = Character.valueOf('.');
                }
                result.append(';');
            }

            public void forVariableType(VariableType t) {
                result.append('T');
                result.append(t.symbol().name());
                result.append(';');
            }

            public void forIntersectionType(IntersectionType t) {
                if (IterUtil.isEmpty(t.ofTypes())) {
                    result.append(OBJECT_DESCRIPTOR);
                } else {
                    IterUtil.first(t.ofTypes()).apply(this);
                }
            }

            public void forUnionType(UnionType t) {
                result.append("Ljava/lang/Object;");
            }

            public void forTopType(TopType t) {
                result.append(OBJECT_DESCRIPTOR);
            }

            public void forBottomType(BottomType t) {
                result.append(OBJECT_DESCRIPTOR);
            }

            public void forVoidType(VoidType v) {
                result.append("V");
            }

            public void forWildcard(Wildcard w) {
                if (w.symbol().upperBound().equals(TypeSystem.OBJECT)) {
                    if (w.symbol().lowerBound().equals(TypeSystem.NULL)) {
                        result.append('*');
                    } else {
                        result.append('-');
                        w.symbol().lowerBound().apply(this);
                    }
                } else {
                    result.append('+');
                    w.symbol().upperBound().apply(this);
                }
            }
        });
        return result.toString();
    }

    private static int[] computeParamLocations(List<FormalParameter> params, int reservedSize) {
        int[] result = new int[params.size() + 1];
        int index = reservedSize;
        int paramI = 0;
        for (FormalParameter p : params) {
            result[paramI] = index++;
            Type t = NodeProperties.getVariable(p).type();
            if (t instanceof LongType || t instanceof DoubleType) {
                index += 2;
            }
            ++paramI;
        }
        result[paramI] = index;
        return result;
    }

    private static Object expressionConstantVal(Expression exp) {
        Object result = null;
        if (!(!NodeProperties.hasValue(exp) || (result = NodeProperties.getValue(exp)) instanceof Integer || result instanceof Float || result instanceof Long || result instanceof Double || result instanceof String)) {
            result = null;
        }
        return result;
    }

    private static int defaultToPublicAccess(int accessFlags) {
        if (!(Modifier.isPublic(accessFlags) || Modifier.isProtected(accessFlags) || Modifier.isPrivate(accessFlags))) {
            accessFlags |= ModifierSet.Modifier.PUBLIC.getBits();
        }
        return accessFlags;
    }

    private static int defaultToProtectedAccess(int accessFlags) {
        if (!(Modifier.isPublic(accessFlags) || Modifier.isProtected(accessFlags) || Modifier.isPrivate(accessFlags))) {
            accessFlags |= ModifierSet.Modifier.PROTECTED.getBits();
        }
        return accessFlags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindingsFactory
    implements Lambda<Object, RuntimeBindings> {
        private final RuntimeBindings _bindings;
        private final DJClass _thisClass;
        private RuntimeBindings _cachedResult;

        public BindingsFactory(RuntimeBindings bindings, DJClass thisClass) {
            this._bindings = bindings;
            this._thisClass = thisClass;
            this._cachedResult = null;
        }

        @Override
        public RuntimeBindings value(Object thisVal) {
            if (this._cachedResult == null) {
                this._cachedResult = new RuntimeBindings(this._bindings, this._thisClass, thisVal);
            }
            return this._cachedResult;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EvaluationAdapter {
        public Object evaluateMethod(String key, RuntimeBindings bindings, Object[] args) throws Throwable {
            MethodDeclaration decl = (MethodDeclaration)TreeCompiler.this._methods.get(key);
            RuntimeBindings methodBindings = this.bindArgs(bindings, decl.getParameters(), args);
            return this.evaluateBlock(decl.getBody(), NodeProperties.getErasedType(decl).value(), methodBindings);
        }

        public Object evaluateExpression(String key, RuntimeBindings bindings) throws Throwable {
            Expression exp = (Expression)TreeCompiler.this._expressions.get(key);
            return this.evaluateExpression(exp, bindings);
        }

        public Object evaluateConstructorCallArg(String key, int index, RuntimeBindings bindings, Object[] args) throws Throwable {
            ConstructorDeclaration decl = (ConstructorDeclaration)TreeCompiler.this._constructors.get(key);
            Expression exp = index == -1 ? decl.getConstructorCall().getExpression() : decl.getConstructorCall().getArguments().get(index);
            RuntimeBindings constructorBindings = this.bindArgs(bindings, decl.getParameters(), args);
            return this.evaluateExpression(exp, constructorBindings);
        }

        public void evaluateConstructorBody(String key, RuntimeBindings bindings, Object[] args) throws Throwable {
            ConstructorDeclaration decl = (ConstructorDeclaration)TreeCompiler.this._constructors.get(key);
            RuntimeBindings constructorBindings = this.bindArgs(bindings, decl.getParameters(), args);
            this.evaluateBlock(new BlockStatement(decl.getStatements()), Void.TYPE, constructorBindings);
        }

        public void evaluateInitializer(String key, RuntimeBindings bindings) throws Throwable {
            Initializer decl = (Initializer)TreeCompiler.this._initializers.get(key);
            this.evaluateBlock(decl.getBlock(), Void.TYPE, bindings);
        }

        public BindingsFactory makeBindingsFactory(RuntimeBindings bindings) {
            return new BindingsFactory(bindings, TreeCompiler.this._treeClass);
        }

        private RuntimeBindings bindArgs(RuntimeBindings parent, List<FormalParameter> params, Object[] args) {
            return new RuntimeBindings(parent, TreeCompiler.extractVars(params), IterUtil.asIterable(args));
        }

        private Object evaluateExpression(Expression exp, RuntimeBindings bindings) throws Throwable {
            try {
                return new ExpressionEvaluator(bindings, TreeCompiler.this._opt).value(exp);
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof EvaluatorException) {
                    throw ((EvaluatorException)e.getCause()).getCause();
                }
                throw e;
            }
        }

        private Object evaluateBlock(BlockStatement block, Class<?> returnType, RuntimeBindings bindings) throws Throwable {
            try {
                block.acceptVisitor(new StatementEvaluator(bindings, TreeCompiler.this._opt));
                return SymbolUtil.initialValue(returnType);
            }
            catch (StatementEvaluator.ReturnException e) {
                return e.value().unwrap(null);
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof EvaluatorException) {
                    throw ((EvaluatorException)e.getCause()).getCause();
                }
                throw e;
            }
        }
    }

    private static class StackSizeTracker {
        private int _maxStack = 0;
        private int _maxLocals;
        private int _currentStack;
        private int _markedStack;

        public StackSizeTracker(int reservedParamsSize) {
            this._maxLocals = reservedParamsSize;
            this._currentStack = 0;
            this._markedStack = 0;
        }

        public void adjust(int delta) {
            this._currentStack += delta;
            if (this._currentStack > this._maxStack) {
                this._maxStack = this._currentStack;
            }
            if (this._currentStack < 0) {
                throw new IllegalStateException("Stack has negative size");
            }
        }

        public void mark() {
            this._markedStack = this._currentStack;
        }

        public void reset() {
            this._currentStack = this._markedStack;
        }

        public int newVariable() {
            return this._maxLocals++;
        }

        public int newBigVariable() {
            int result = this._maxLocals;
            this._maxLocals += 2;
            return result;
        }

        public int maxStack() {
            return this._maxStack;
        }

        public int maxLocals() {
            return this._maxLocals;
        }
    }
}

