/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.ClassContext;
import edu.rice.cs.dynamicjava.interpreter.ClassSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.ExpressionChecker;
import edu.rice.cs.dynamicjava.interpreter.FunctionContext;
import edu.rice.cs.dynamicjava.interpreter.FunctionSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.InitializerContext;
import edu.rice.cs.dynamicjava.interpreter.StatementChecker;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.interpreter.TypeNameChecker;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.DJConstructor;
import edu.rice.cs.dynamicjava.symbol.DJMethod;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.debug.DebugUtil;
import java.util.Collections;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.ModifierSet;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.visitor.AbstractVisitor;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassChecker {
    private final DJClass _c;
    private final ClassLoader _loader;
    private final TypeContext _context;
    private final Options _opt;

    public ClassChecker(DJClass c, ClassLoader loader, TypeContext context, Options opt) {
        this._c = c;
        this._loader = loader;
        this._context = context;
        this._opt = opt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeClassSignatures(TypeDeclaration ast) {
        ClassSignatureContext sigContext = new ClassSignatureContext(this._context, this._c, this._loader);
        TypeNameChecker sigChecker = new TypeNameChecker(sigContext, this._opt);
        DebugUtil.debug.logStart("Initializing type parameters", "class", (Object)ast.getName());
        try {
            Iterable tparams = ast.getTypeParams().unwrap(Collections.emptyList());
            sigChecker.checkStructureForTypeParameters(tparams);
        }
        finally {
            DebugUtil.debug.logEnd();
        }
        DebugUtil.debug.logStart("Initializing supertypes", "class", (Object)ast.getName());
        try {
            if (ast instanceof ClassDeclaration) {
                sigChecker.checkStructure(((ClassDeclaration)ast).getSuperclass());
            }
            if (ast.getInterfaces() != null) {
                for (ReferenceTypeName referenceTypeName : ast.getInterfaces()) {
                    sigChecker.checkStructure(referenceTypeName);
                }
            }
        }
        finally {
            DebugUtil.debug.logEnd();
        }
        this.initializeNestedClassSignatures(ast.getMembers(), sigContext);
    }

    public void initializeClassSignatures(AnonymousAllocation ast) {
        this.initializeNestedClassSignatures(ast.getMembers(), new ClassSignatureContext(this._context, this._c, this._loader));
    }

    public void initializeClassSignatures(AnonymousInnerAllocation ast) {
        this.initializeNestedClassSignatures(ast.getMembers(), new ClassSignatureContext(this._context, this._c, this._loader));
    }

    private void initializeNestedClassSignatures(Iterable<? extends Node> members, TypeContext sigContext) {
        ClassContext bodyContext = new ClassContext(sigContext, this._c);
        ExecutionError error = null;
        for (Node node : members) {
            try {
                if (!(node instanceof TypeDeclaration)) continue;
                ClassChecker nestedChecker = new ClassChecker(NodeProperties.getDJClass(node), this._loader, bodyContext, this._opt);
                nestedChecker.initializeClassSignatures((TypeDeclaration)node);
            }
            catch (ExecutionError e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSignatures(TypeDeclaration ast) {
        ClassSignatureContext sigContext = new ClassSignatureContext(this._context, this._c, this._loader);
        TypeNameChecker sigChecker = new TypeNameChecker(sigContext, this._opt);
        DebugUtil.debug.logStart("Check type parameters");
        try {
            Iterable tparams = ast.getTypeParams().unwrap(Collections.emptyList());
            sigChecker.ensureWellFormedTypeParameters(tparams);
        }
        finally {
            DebugUtil.debug.logEnd();
        }
        DebugUtil.debug.logStart("Check supertypes");
        try {
            if (ast instanceof ClassDeclaration) {
                sigChecker.ensureWellFormed(((ClassDeclaration)ast).getSuperclass());
            }
            if (ast.getInterfaces() != null) {
                for (ReferenceTypeName referenceTypeName : ast.getInterfaces()) {
                    sigChecker.ensureWellFormed(referenceTypeName);
                }
            }
        }
        finally {
            DebugUtil.debug.logEnd();
        }
        if (ast instanceof InterfaceDeclaration) {
            this.checkInterfaceMemberSignatures(ast.getMembers(), sigContext);
        } else {
            this.checkClassMemberSignatures(ast.getMembers(), sigContext);
        }
    }

    public void checkSignatures(AnonymousAllocation ast) {
        this.checkClassMemberSignatures(ast.getMembers(), new ClassSignatureContext(this._context, this._c, this._loader));
    }

    public void checkSignatures(AnonymousInnerAllocation ast) {
        this.checkClassMemberSignatures(ast.getMembers(), new ClassSignatureContext(this._context, this._c, this._loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitMembers(Iterable<? extends Node> members, Visitor<?> v) {
        ExecutionError error = null;
        for (Node node : members) {
            DebugUtil.debug.logStart();
            try {
                node.acceptVisitor(v);
            }
            catch (ExecutionError e) {
                if (error != null) continue;
                error = e;
            }
            finally {
                DebugUtil.debug.logEnd();
            }
        }
        if (error != null) {
            throw error;
        }
    }

    private void checkClassMemberSignatures(Iterable<? extends Node> members, TypeContext sigContext) {
        ClassContext bodyContext = new ClassContext(sigContext, this._c);
        this.visitMembers(members, new ClassMemberSignatureVisitor(bodyContext));
    }

    private void checkInterfaceMemberSignatures(Iterable<? extends Node> members, TypeContext sigContext) {
        ClassContext bodyContext = new ClassContext(sigContext, this._c);
        this.visitMembers(members, new InterfaceMemberSignatureVisitor(bodyContext));
    }

    public void checkBodies(TypeDeclaration ast) {
        this.checkBodies(ast.getMembers());
    }

    public void checkBodies(AnonymousAllocation ast) {
        this.checkBodies(ast.getMembers());
    }

    public void checkBodies(AnonymousInnerAllocation ast) {
        this.checkBodies(ast.getMembers());
    }

    private void checkBodies(Iterable<? extends Node> members) {
        ClassSignatureContext sigContext = new ClassSignatureContext(this._context, this._c, this._loader);
        ClassContext bodyContext = new ClassContext(sigContext, this._c);
        this.visitMembers(members, new MemberBodyVisitor(bodyContext));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberBodyVisitor
    extends AbstractVisitor<Void> {
        private final TypeContext _bodyContext;

        public MemberBodyVisitor(TypeContext bodyContext) {
            this._bodyContext = bodyContext;
        }

        @Override
        public Void visit(ClassDeclaration node) {
            new ClassChecker(NodeProperties.getDJClass(node), ClassChecker.this._loader, this._bodyContext, ClassChecker.this._opt).checkBodies(node);
            return null;
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            new ClassChecker(NodeProperties.getDJClass(node), ClassChecker.this._loader, this._bodyContext, ClassChecker.this._opt).checkBodies(node);
            return null;
        }

        @Override
        public Void visit(MethodDeclaration node) {
            if (node.getBody() != null) {
                DJMethod m = NodeProperties.getMethod(node);
                FunctionSignatureContext sigContext = new FunctionSignatureContext(this._bodyContext, m);
                FunctionContext bodyContext = new FunctionContext(sigContext, m);
                node.getBody().acceptVisitor(new StatementChecker(bodyContext, ClassChecker.this._opt));
            }
            return null;
        }

        @Override
        public Void visit(ConstructorDeclaration node) {
            ExecutionError error;
            ConstructorCall call;
            ExpressionChecker callChecker;
            block7: {
                DJConstructor k = NodeProperties.getConstructor(node);
                FunctionSignatureContext sigContext = new FunctionSignatureContext(this._bodyContext, k);
                FunctionContext bodyContext = new FunctionContext(sigContext, k);
                callChecker = new ExpressionChecker(bodyContext, ClassChecker.this._opt);
                call = node.getConstructorCall();
                error = null;
                if (call != null) {
                    try {
                        callChecker.checkConstructorCall(call);
                    }
                    catch (ExecutionError e) {
                        error = e;
                    }
                }
                try {
                    new StatementChecker(bodyContext, ClassChecker.this._opt).checkList(node.getStatements());
                }
                catch (ExecutionError e) {
                    if (error == null) break block7;
                    error = e;
                }
            }
            if (call == null && error == null) {
                callChecker.checkConstructorCall(new ConstructorCall(null, null, true));
            }
            if (error != null) {
                throw error;
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            Expression init = node.getInitializer();
            if (init != null) {
                InitializerContext c = new InitializerContext(this._bodyContext, NodeProperties.getField(node).isStatic(), ClassChecker.this._c);
                Type expectedT = NodeProperties.getType(node.getType());
                Type initT = new ExpressionChecker(c, ClassChecker.this._opt).check(init, expectedT);
                TypeSystem ts = ClassChecker.this._opt.typeSystem();
                try {
                    Expression newInit = ts.assign(expectedT, init);
                    node.setInitializer(newInit);
                }
                catch (TypeSystem.UnsupportedConversionException e) {
                    TypeSystem.TypePrinter printer = ts.typePrinter();
                    NodeProperties.setErrorStrings(node, printer.print(initT), printer.print(expectedT));
                    throw new ExecutionError("assignment.types", node);
                }
            }
            return null;
        }

        @Override
        public Void visit(ClassInitializer node) {
            InitializerContext c = new InitializerContext(this._bodyContext, true, ClassChecker.this._c);
            node.getBlock().acceptVisitor(new StatementChecker(c, ClassChecker.this._opt));
            return null;
        }

        @Override
        public Void visit(InstanceInitializer node) {
            InitializerContext c = new InitializerContext(this._bodyContext, false, ClassChecker.this._c);
            node.getBlock().acceptVisitor(new StatementChecker(c, ClassChecker.this._opt));
            return null;
        }
    }

    private class InterfaceMemberSignatureVisitor
    extends MemberSignatureVisitor {
        public InterfaceMemberSignatureVisitor(TypeContext bodyContext) {
            super(bodyContext);
        }

        public Void visit(MethodDeclaration node) {
            super.visit(node);
            if (node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            return null;
        }

        public Void visit(FieldDeclaration node) {
            super.visit(node);
            if (node.getInitializer() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("uninitialized.variable", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(ClassInitializer node) {
            throw new ExecutionError("interface.member", node);
        }

        public Void visit(InstanceInitializer node) {
            throw new ExecutionError("interface.member", node);
        }
    }

    private class ClassMemberSignatureVisitor
    extends MemberSignatureVisitor {
        public ClassMemberSignatureVisitor(TypeContext bodyContext) {
            super(bodyContext);
        }

        public Void visit(MethodDeclaration node) {
            super.visit(node);
            ModifierSet mods = node.getModifiers();
            if (mods.isAbstract() && node.getBody() != null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("abstract.method.body", node);
            }
            if (!mods.isAbstract() && !mods.isNative() && node.getBody() == null) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("missing.method.body", node);
            }
            return null;
        }

        public Void visit(ConstructorDeclaration node) {
            DJConstructor k = NodeProperties.getConstructor(node);
            if (ClassChecker.this._c.isAnonymous() || !ClassChecker.this._c.declaredName().equals(node.getName())) {
                NodeProperties.setErrorStrings(node, node.getName());
                throw new ExecutionError("constructor.name", node);
            }
            FunctionSignatureContext sigContext = new FunctionSignatureContext(this._bodyContext, k);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassChecker.this._opt);
            Iterable tparams = node.getTypeParams().unwrap(Collections.emptyList());
            sigChecker.checkTypeParameters(tparams);
            for (FormalParameter formalParameter : node.getParameters()) {
                Type t = sigChecker.check(formalParameter.getType());
                NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.getModifiers().isFinal()));
            }
            for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
                sigChecker.check(referenceTypeName);
            }
            return null;
        }

        public Void visit(ClassInitializer node) {
            return null;
        }

        public Void visit(InstanceInitializer node) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MemberSignatureVisitor
    extends AbstractVisitor<Void> {
        protected final TypeContext _bodyContext;

        protected MemberSignatureVisitor(TypeContext bodyContext) {
            this._bodyContext = bodyContext;
        }

        @Override
        public Void visit(ClassDeclaration node) {
            new ClassChecker(NodeProperties.getDJClass(node), ClassChecker.this._loader, this._bodyContext, ClassChecker.this._opt).checkSignatures(node);
            return null;
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            new ClassChecker(NodeProperties.getDJClass(node), ClassChecker.this._loader, this._bodyContext, ClassChecker.this._opt).checkSignatures(node);
            return null;
        }

        @Override
        public Void visit(MethodDeclaration node) {
            DJMethod m = NodeProperties.getMethod(node);
            FunctionSignatureContext sigContext = new FunctionSignatureContext(this._bodyContext, m);
            TypeNameChecker sigChecker = new TypeNameChecker(sigContext, ClassChecker.this._opt);
            Iterable tparams = node.getTypeParams().unwrap(Collections.emptyList());
            sigChecker.checkTypeParameters(tparams);
            Type returnT = sigChecker.check(node.getReturnType());
            NodeProperties.setErasedType(node, ClassChecker.this._opt.typeSystem().erasedClass(returnT));
            for (FormalParameter formalParameter : node.getParameters()) {
                Type t = sigChecker.check(formalParameter.getType());
                NodeProperties.setVariable(formalParameter, new LocalVariable(formalParameter.getName(), t, formalParameter.getModifiers().isFinal()));
            }
            for (ReferenceTypeName referenceTypeName : node.getExceptions()) {
                sigChecker.check(referenceTypeName);
            }
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            new TypeNameChecker(this._bodyContext, ClassChecker.this._opt).check(node.getType());
            return null;
        }

        @Override
        public abstract Void visit(ConstructorDeclaration var1);

        @Override
        public abstract Void visit(ClassInitializer var1);

        @Override
        public abstract Void visit(InstanceInitializer var1);
    }
}

