/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.ConfigOptionListeners;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.junit.ConcJUnitUtils;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.DirectoryFilter;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.BooleanOptionComponent;
import edu.rice.cs.drjava.ui.config.ButtonComponent;
import edu.rice.cs.drjava.ui.config.ColorOptionComponent;
import edu.rice.cs.drjava.ui.config.ConfigPanel;
import edu.rice.cs.drjava.ui.config.DirectoryOptionComponent;
import edu.rice.cs.drjava.ui.config.FileOptionComponent;
import edu.rice.cs.drjava.ui.config.FontOptionComponent;
import edu.rice.cs.drjava.ui.config.ForcedChoiceOptionComponent;
import edu.rice.cs.drjava.ui.config.IntegerOptionComponent;
import edu.rice.cs.drjava.ui.config.LabelComponent;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.StringOptionComponent;
import edu.rice.cs.drjava.ui.config.ToolbarOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorKeyStrokeOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorStringOptionComponent;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFrame
extends SwingFrame {
    private static final int FRAME_WIDTH = 850;
    private static final int FRAME_HEIGHT = 550;
    private final MainFrame _mainFrame;
    private final JTree _tree;
    private final DefaultTreeModel _treeModel;
    private final PanelTreeNode _rootNode;
    private final JButton _okButton;
    private final JButton _applyButton;
    private final JButton _cancelButton;
    private final JPanel _mainPanel;
    private final JFileChooser _fileOptionChooser;
    private final JFileChooser _browserChooser;
    private final JFileChooser _jarChooser;
    private final DirectoryChooser _dirChooser;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<Boolean> _junitLocationEnabledListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<File> _junitLocationListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<String> _concJUnitChecksEnabledListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<File> _rtConcJUnitLocationListener;
    private StringOptionComponent javadocCustomParams;
    protected final String SEPS = " \t\n-,;.(";
    private OptionComponent.ChangeListener _changeListener = new OptionComponent.ChangeListener(){

        public Object value(Object oc) {
            ConfigFrame.this._applyButton.setEnabled(true);
            return null;
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ConfigFrame.this.cancel();
        }
    };

    public ConfigFrame(MainFrame frame) {
        super("Preferences");
        this._mainFrame = frame;
        this._junitLocationEnabledListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "Use External JUnit");
        this._junitLocationListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "JUnit Location");
        this._concJUnitChecksEnabledListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "Enabled ConcJUnit Checks");
        this._rtConcJUnitLocationListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "ConcJUnit Runtime Location");
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigFrame.this.saveSettings();
                    ConfigFrame.this._applyButton.setEnabled(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this._applyButton = new JButton(applyAction);
        this._applyButton.setEnabled(false);
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                try {
                    successful = ConfigFrame.this.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (successful) {
                    ConfigFrame.this._applyButton.setEnabled(false);
                }
                ConfigFrame.this.setVisible(false);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        File workDir = this._getWorkDir();
        if (workDir == null || workDir == FileOps.NULL_FILE) {
            workDir = new File(System.getProperty("user.dir"));
        }
        this._fileOptionChooser = new JFileChooser(workDir);
        this._jarChooser = new JFileChooser(workDir);
        this._browserChooser = new JFileChooser(workDir);
        this._dirChooser = new DirectoryChooser(this);
        this._rootNode = new PanelTreeNode("Preferences");
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel);
        this._initTree();
        this._createPanels();
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BorderLayout());
        this._tree.addTreeSelectionListener(new PanelTreeSelectionListener());
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        if (this._rootNode.getChildCount() != 0) {
            PanelTreeNode firstChild = (PanelTreeNode)this._rootNode.getChildAt(0);
            Object[] firstChildPath = firstChild.getPath();
            TreePath path = new TreePath(firstChildPath);
            this._tree.expandPath(path);
            this._tree.setSelectionPath(path);
        }
        JScrollPane treeScroll = new JScrollPane(this._tree);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories"));
        treePanel.add((Component)treeScroll, "Center");
        cp.add((Component)treePanel, "West");
        cp.add((Component)this._mainPanel, "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        cp.add((Component)bottom, "South");
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dim.width = dim.width > 850 ? 850 : (dim.width -= 80);
        dim.height = dim.height > 550 ? 550 : (dim.height -= 80);
        this.setSize(dim);
        this._mainFrame.setPopupLoc(this);
        for (int row = 0; row < this._tree.getRowCount(); ++row) {
            this._tree.expandRow(row);
        }
        this.initDone();
    }

    public void setUp() {
        assert (EventQueue.isDispatchThread());
        this._fileOptionChooser.setDialogTitle("Select");
        this._fileOptionChooser.setApproveButtonText("Select");
        this._fileOptionChooser.setFileSelectionMode(2);
        this._fileOptionChooser.setFileFilter(ClassPathFilter.ONLY);
        this._jarChooser.setDialogTitle("Select");
        this._jarChooser.setApproveButtonText("Select");
        this._jarChooser.setFileSelectionMode(0);
        this._jarChooser.setFileFilter(ClassPathFilter.ONLY);
        this._browserChooser.setDialogTitle("Select Web Browser");
        this._browserChooser.setApproveButtonText("Select");
        this._browserChooser.setFileSelectionMode(0);
        this._dirChooser.setSelectedFile(this._getWorkDir());
        this._dirChooser.setDialogTitle("Select");
        this._dirChooser.setApproveButtonText("Select");
        this._dirChooser.setMultiSelectionEnabled(false);
    }

    private void enableChangeListeners() {
        DrJava.getConfig().addOptionListener(OptionConstants.JUNIT_LOCATION_ENABLED, this._junitLocationEnabledListener);
        DrJava.getConfig().addOptionListener(OptionConstants.JUNIT_LOCATION, this._junitLocationListener);
        DrJava.getConfig().addOptionListener(OptionConstants.CONCJUNIT_CHECKS_ENABLED, this._concJUnitChecksEnabledListener);
        DrJava.getConfig().addOptionListener(OptionConstants.RT_CONCJUNIT_LOCATION, this._rtConcJUnitLocationListener);
    }

    private void disableChangeListeners() {
        DrJava.getConfig().removeOptionListener(OptionConstants.JUNIT_LOCATION_ENABLED, this._junitLocationEnabledListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.JUNIT_LOCATION, this._junitLocationListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.CONCJUNIT_CHECKS_ENABLED, this._concJUnitChecksEnabledListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.RT_CONCJUNIT_LOCATION, this._rtConcJUnitLocationListener);
    }

    private File _getWorkDir() {
        File workDir = this._mainFrame.getModel().getMasterWorkingDirectory();
        assert (workDir != null);
        if (workDir.isDirectory()) {
            return workDir;
        }
        if (workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        return workDir;
    }

    public boolean apply() {
        return this._rootNode.update();
    }

    public void resetToCurrent() {
        this._rootNode.resetToCurrent();
        VectorKeyStrokeOptionComponent.resetCurrentKeyStrokeMap();
    }

    public void cancel() {
        this.resetToCurrent();
        this._applyButton.setEnabled(false);
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this.enableChangeListeners();
            this.toFront();
        } else {
            this.disableChangeListeners();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    public boolean saveSettings() throws IOException {
        boolean successful = this.apply();
        if (successful) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Could not save changes to your \".drjava\" file in your home directory. \n\n" + ioe, "Could Not Save Changes", 0);
                throw ioe;
            }
        }
        return successful;
    }

    private void _displayPanel(ConfigPanel cf) {
        this._mainPanel.removeAll();
        this._mainPanel.add((Component)cf, "Center");
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    private void _initTree() {
        this._tree.setEditable(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        dtcr.setLeafIcon(null);
        dtcr.setOpenIcon(null);
        dtcr.setClosedIcon(null);
        this._tree.setCellRenderer(dtcr);
    }

    private PanelTreeNode _createPanel(String t, PanelTreeNode parent) {
        PanelTreeNode ptNode = new PanelTreeNode(t);
        this._treeModel.insertNodeInto(ptNode, parent, parent.getChildCount());
        Object[] pathArray = ptNode.getPath();
        TreePath path = new TreePath(pathArray);
        this._tree.expandPath(path);
        return ptNode;
    }

    private PanelTreeNode _createPanel(String t) {
        return this._createPanel(t, this._rootNode);
    }

    private void _createPanels() {
        PanelTreeNode resourceLocNode = this._createPanel("Resource Locations");
        this._setupResourceLocPanel(resourceLocNode.getPanel());
        PanelTreeNode displayNode = this._createPanel("Display Options");
        this._setupDisplayPanel(displayNode.getPanel());
        PanelTreeNode fontNode = this._createPanel("Fonts", displayNode);
        this._setupFontPanel(fontNode.getPanel());
        PanelTreeNode colorNode = this._createPanel("Colors", displayNode);
        this._setupColorPanel(colorNode.getPanel());
        PanelTreeNode positionsNode = this._createPanel("Window Positions", displayNode);
        this._setupPositionsPanel(positionsNode.getPanel());
        PanelTreeNode keystrokesNode = this._createPanel("Key Bindings");
        this._setupKeyBindingsPanel(keystrokesNode.getPanel());
        PanelTreeNode compilerOptionsNode = this._createPanel("Compiler Options");
        this._setupCompilerPanel(compilerOptionsNode.getPanel());
        PanelTreeNode interactionsNode = this._createPanel("Interactions Pane");
        this._setupInteractionsPanel(interactionsNode.getPanel());
        PanelTreeNode debugNode = this._createPanel("Debugger");
        this._setupDebugPanel(debugNode.getPanel());
        PanelTreeNode junitNode = this._createPanel("JUnit");
        this._setupJUnitPanel(junitNode.getPanel());
        PanelTreeNode javadocNode = this._createPanel("Javadoc");
        this._setupJavadocPanel(javadocNode.getPanel());
        PanelTreeNode notificationsNode = this._createPanel("Notifications");
        this._setupNotificationsPanel(notificationsNode.getPanel());
        PanelTreeNode miscNode = this._createPanel("Miscellaneous");
        this._setupMiscPanel(miscNode.getPanel());
        PanelTreeNode fileTypesNode = this._createPanel("File Types", miscNode);
        this._setupFileTypesPanel(fileTypesNode.getPanel());
        PanelTreeNode jvmsNode = this._createPanel("JVMs", miscNode);
        this._setupJVMsPanel(jvmsNode.getPanel());
    }

    public <X, C extends JComponent> void addOptionComponent(ConfigPanel panel, OptionComponent<X, C> oc) {
        panel.addComponent(oc);
        oc.addChangeListener(this._changeListener);
    }

    private void _setupResourceLocPanel(ConfigPanel panel) {
        FileOptionComponent browserLoc = new FileOptionComponent(OptionConstants.BROWSER_FILE, "Web Browser", (SwingFrame)this, "<html>Location of a web browser to use for Javadoc and Help links.<br>If left blank, only the Web Browser Command will be used.<br>This is not necessary if a default browser is available on your system.", this._browserChooser);
        this.addOptionComponent(panel, browserLoc);
        StringOptionComponent browserCommand = new StringOptionComponent(OptionConstants.BROWSER_STRING, "Web Browser Command", this, "<html>Command to send to the web browser to view a web location.<br>The string <code>&lt;URL&gt;</code> will be replaced with the URL address.<br>This is not necessary if a default browser is available on your system.");
        this.addOptionComponent(panel, browserCommand);
        FileOptionComponent javacLoc = new FileOptionComponent(OptionConstants.JAVAC_LOCATION, "Tools.jar Location", (SwingFrame)this, "Optional location of the JDK's tools.jar, which contains the compiler and debugger.", this._fileOptionChooser);
        javacLoc.setFileFilter(ClassPathFilter.ONLY);
        this.addOptionComponent(panel, javacLoc);
        BooleanOptionComponent displayAllCompilerVersions = new BooleanOptionComponent(OptionConstants.DISPLAY_ALL_COMPILER_VERSIONS, "Display All Compiler Versions", (SwingFrame)this, "Display all compiler versions, even if they have the same major version.");
        this.addOptionComponent(panel, displayAllCompilerVersions);
        this.addOptionComponent(panel, new VectorFileOptionComponent(OptionConstants.EXTRA_CLASSPATH, "Extra Classpath", (SwingFrame)this, "<html>Any directories or jar files to add to the classpath<br>of the Compiler and Interactions Pane.</html>", true));
        panel.displayComponents();
    }

    private void _setupDisplayPanel(ConfigPanel panel) {
        final ForcedChoiceOptionComponent lookAndFeelComponent = new ForcedChoiceOptionComponent(OptionConstants.LOOK_AND_FEEL, "Look and Feel", this, "Changes the general appearance of DrJava.");
        this.addOptionComponent(panel, lookAndFeelComponent);
        final ForcedChoiceOptionComponent plasticComponent = new ForcedChoiceOptionComponent(OptionConstants.PLASTIC_THEMES, "Plastic Theme", this, "Pick the theme to be used by the Plastic family of Look and Feels");
        lookAndFeelComponent.addChangeListener(new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                ((JComboBox)plasticComponent.getComponent()).setEnabled(lookAndFeelComponent.getCurrentComboBoxValue().startsWith("com.jgoodies.looks.plastic."));
                return null;
            }
        });
        ((JComboBox)plasticComponent.getComponent()).setEnabled(lookAndFeelComponent.getCurrentComboBoxValue().startsWith("com.jgoodies.looks.plastic."));
        this.addOptionComponent(panel, plasticComponent);
        this.addOptionComponent(panel, new ToolbarOptionComponent("Toolbar Buttons", this, "How to display the toolbar buttons."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.LINEENUM_ENABLED, "Show All Line Numbers", (SwingFrame)this, "Whether to show line numbers on the left side of the Definitions Pane."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING, "Show sample of source code when fast switching", (SwingFrame)this, "Whether to show a sample of the source code under the document's filename when fast switching documents."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_CODE_PREVIEW_POPUPS, "Show Code Preview Popups", (SwingFrame)this, "<html>Whether to show a popup window with a code preview when the mouse is hovering<br>over an item in the Breakpoints, Bookmarks and Find All panes.</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.CLIPBOARD_HISTORY_SIZE, "Size of Clipboard History", this, "Determines how many entries are kept in the clipboard history."));
        BooleanOptionComponent checkbox = new BooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_FULLY_QUALIFIED, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Display Fully-Qualified Class Names in \"Go to File\" Dialog", 40, "<br>", " \t\n-,;.(") + "</p></html>", (SwingFrame)this, "<html>Whether to also display fully-qualified class names in the \"Go to File\" dialog.<br>Enabling this option on network drives might cause the dialog to display after a slight delay.</html>");
        this.addOptionComponent(panel, checkbox);
        checkbox = new BooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_SCAN_CLASS_FILES, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Scan Class Files After Each Compile for Auto-Completion and Auto-Import", 40, "<br>", " \t\n-,;.(") + "</p></html>", (SwingFrame)this, "<html>Whether to scan the class files after a compile to generate class names<br>used for auto-completion and auto-import.<br>Enabling this option will slow compiles down.</html>");
        this.addOptionComponent(panel, checkbox);
        checkbox = new BooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_JAVAAPI, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Consider Java API Classes for Auto-Completion", 40, "<br>", " \t\n-,;.(") + "</p></html>", (SwingFrame)this, "Whether to use the names of the Java API classes for auto-completion as well.");
        this.addOptionComponent(panel, checkbox);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        final BooleanOptionComponent drmComponent = new BooleanOptionComponent(OptionConstants.DISPLAY_RIGHT_MARGIN, "Display right margin", (SwingFrame)this, "Whether to display a line at the right margin.");
        this.addOptionComponent(panel, drmComponent);
        final IntegerOptionComponent rmcComponent = new IntegerOptionComponent(OptionConstants.RIGHT_MARGIN_COLUMNS, "Right Margin Position", this, "The number of columns after which the right margin is displayed.");
        this.addOptionComponent(panel, rmcComponent);
        OptionComponent.ChangeListener drmListener = new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                ((JTextField)rmcComponent.getComponent()).setEnabled(((JCheckBox)drmComponent.getComponent()).isSelected());
                return null;
            }
        };
        drmComponent.addChangeListener(drmListener);
        drmListener.value(drmComponent);
        panel.displayComponents();
    }

    private void _setupFontPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_MAIN, "Main Font", this, "The font used for most text in DrJava."));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_LINE_NUMBERS, "Line Numbers Font", this, "<html>The font for displaying line numbers on the left side of<br>the Definitions Pane if Show All Line Numbers is enabled.<br>Cannot be displayed larger than the Main Font.</html>"));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_DOCLIST, "Document List Font", this, "The font used in the list of open documents."));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_TOOLBAR, "Toolbar Font", this, "The font used in the toolbar buttons."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.TEXT_ANTIALIAS, "Use anti-aliased text", (SwingFrame)this, "Whether to graphically smooth the text."));
        panel.displayComponents();
    }

    private void _setupColorPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_NORMAL_COLOR, "Normal Color", (SwingFrame)this, "The default color for text in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_KEYWORD_COLOR, "Keyword Color", (SwingFrame)this, "The color for Java keywords in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_TYPE_COLOR, "Type Color", (SwingFrame)this, "The color for classes and types in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_COMMENT_COLOR, "Comment Color", (SwingFrame)this, "The color for comments in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, "Double-quoted Color", (SwingFrame)this, "The color for quoted strings (eg. \"...\") in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, "Single-quoted Color", (SwingFrame)this, "The color for quoted characters (eg. 'a') in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_NUMBER_COLOR, "Number Color", (SwingFrame)this, "The color for numbers in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, "Background Color", (SwingFrame)this, "The background color of the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_LINE_NUMBER_COLOR, "Line Number Color", (SwingFrame)this, "The color for line numbers in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_LINE_NUMBER_BACKGROUND_COLOR, "Line Number Background Color", (SwingFrame)this, "The background color for line numbers in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_MATCH_COLOR, "Brace-matching Color", (SwingFrame)this, "The color for matching brace highlights in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.COMPILER_ERROR_COLOR, "Compiler Error Color", (SwingFrame)this, "The color for compiler error highlights in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.BOOKMARK_COLOR, "Bookmark Color", (SwingFrame)this, "The color for bookmarks in the Definitions Pane.", true));
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.FIND_RESULTS_COLORS[i], "Find Results Color " + (i + 1), (SwingFrame)this, "A color for highlighting find results in the Definitions Pane.", true));
        }
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_COLOR, "Debugger Breakpoint Color", (SwingFrame)this, "The color for breakpoints in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, "Disabled Debugger Breakpoint Color", (SwingFrame)this, "The color for disabled breakpoints in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_THREAD_COLOR, "Debugger Location Color", (SwingFrame)this, "The color for the location of the current suspended thread in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_OUT_COLOR, "System.out Color", (SwingFrame)this, "The color for System.out in the Interactions and Console Panes."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_ERR_COLOR, "System.err Color", (SwingFrame)this, "The color for System.err in the Interactions and Console Panes."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_IN_COLOR, "System.in Color", (SwingFrame)this, "The color for System.in in the Interactions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.INTERACTIONS_ERROR_COLOR, "Interactions Error Color", this, "The color for interactions errors in the Interactions Pane.", false, true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_MESSAGE_COLOR, "Debug Message Color", this, "The color for debugger messages in the Interactions Pane.", false, true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DRJAVA_ERRORS_BUTTON_COLOR, "DrJava Errors Button Background Color", (SwingFrame)this, "The background color of the \"Errors\" button used to show internal DrJava errors.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.RIGHT_MARGIN_COLOR, "Right Margin Color", (SwingFrame)this, "The color of the right margin line, if displayed.", true));
        panel.displayComponents();
    }

    private void _setupPositionsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WINDOW_STORE_POSITION, "Save Main Window Position", this, "Whether to save and restore the size and position of the main window.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION, "Save \"Clipboard History\" Dialog Position", this, "Whether to save and restore the size and position of the \"Clipboard History\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetClipboardHistoryDialogPosition();
            }
        }, "Reset \"Clipboard History\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_STORE_POSITION, "Save \"Go to File\" Dialog Position", this, "Whether to save and restore the size and position of the \"Go to File\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetGotoFileDialogPosition();
            }
        }, "Reset \"Go to File\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_WORD_STORE_POSITION, "Save \"Auto-Complete Word\" Dialog Position", this, "Whether to save and restore the size and position of the \"Auto-Complete Word\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetCompleteWordDialogPosition();
            }
        }, "Reset \"Auto-Complete Word\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_JAROPTIONS_STORE_POSITION, "Save \"Create Jar File from Project\" Dialog Position", this, "Whether to save and restore the position of the \"Create Jar File from Project\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetJarOptionsDialogPosition();
            }
        }, "Reset \"Create Jar File from Project\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, "Save \"Open Javadoc\" Dialog Position", this, "Whether to save and restore the size and position of the \"Open Javadoc\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetOpenJavadocDialogPosition();
            }
        }, "Reset \"Open Javadoc\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_STORE_POSITION, "Save \"Auto Import\" Dialog Position", this, "Whether to save and restore the size and position of the \"Auto Import\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetAutoImportDialogPosition();
            }
        }, "Reset \"Auto Import\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_EXTERNALPROCESS_STORE_POSITION, "Save \"Execute External Process\" Dialog Position", this, "Whether to save and restore the position of the \"Execute External Process\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetExecuteExternalProcessPosition();
            }
        }, "Reset \"Execute External Process\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_EDITEXTERNALPROCESS_STORE_POSITION, "Save \"Edit External Process\" Dialog Position", this, "Whether to save and restore the position of the \"Edit External Process\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetEditExternalProcessPosition();
            }
        }, "Reset \"Execute External Process\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, "Save \"Open Javadoc\" Dialog Position", this, "Whether to save and restore the position of the \"Open Javadoc\" dialog.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetOpenJavadocDialogPosition();
            }
        }, "Reset \"Open Javadoc\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_TABBEDPANES_STORE_POSITION, "Save \"Tabbed Panes\" Window Position", this, "Whether to save and restore the position of the \"Tabbed Panes\" window.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetTabbedPanesFrame();
            }
        }, "Reset \"Tabbed Panes\" Window Position", this, "This resets the window position to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DETACH_TABBEDPANES, "Detach Tabbed Panes", this, "Whether to detach the tabbed panes and display them in a separate window.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_DEBUGFRAME_STORE_POSITION, "Save \"Debugger\" Window Position", this, "Whether to save and restore the position of the \"Debugger\" window.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetDebugFrame();
            }
        }, "Reset \"Debugger\" Window Position", this, "This resets the window position to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DETACH_DEBUGGER, "Detach Debugger", this, "Whether to detach the debugger and display it in a separate window.", false).setEntireColumn(true));
        panel.displayComponents();
    }

    private void _setupKeyBindingsPanel(ConfigPanel panel) {
        TreeMap<String, VectorKeyStrokeOptionComponent> _comps = new TreeMap<String, VectorKeyStrokeOptionComponent>();
        for (KeyBindingManager.KeyStrokeData ksd : KeyBindingManager.ONLY.getKeyStrokeData()) {
            VectorKeyStrokeOptionComponent vksoc;
            String desc;
            if (ksd.getOption() == null) continue;
            Action a = ksd.getAction();
            String name = (String)a.getValue("ShortDescription");
            if (name == null || name.trim().equals("")) {
                name = ksd.getName();
            }
            if ((desc = (String)a.getValue("LongDescription")) == null || desc.trim().equals("")) {
                desc = name;
            }
            if (_comps.containsKey(name) && _comps.containsKey(name = desc)) {
                name = ksd.getOption().getName();
            }
            if ((vksoc = new VectorKeyStrokeOptionComponent(ksd.getOption(), name, (SwingFrame)this, desc)) == null) continue;
            _comps.put(name, vksoc);
        }
        for (VectorKeyStrokeOptionComponent x : _comps.values()) {
            this.addOptionComponent(panel, x);
        }
        panel.displayComponents();
    }

    private void _setupDebugPanel(ConfigPanel panel) {
        if (!this._mainFrame.getModel().getDebugger().isAvailable()) {
            String howto = "\nThe debugger is not currently available. To use the debugger,\nyou can enter the location of the tools.jar file in the\n\"Resource Locations\" pane, in case DrJava does not automatically find it.\nSee the user documentation for more details.\n";
            LabelComponent label = new LabelComponent(howto, this);
            label.setEntireColumn(true);
            this.addOptionComponent(panel, label);
        }
        VectorFileOptionComponent sourcePath = new VectorFileOptionComponent(OptionConstants.DEBUG_SOURCEPATH, "Sourcepath", (SwingFrame)this, "<html>Any directories in which to search for source<br>files when stepping in the Debugger.</html>", true);
        sourcePath.getFileChooser().setFileFilter(new DirectoryFilter("Source Directories"));
        this.addOptionComponent(panel, sourcePath);
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_JAVA, "Step Into Java Classes", (SwingFrame)this, "<html>Whether the Debugger should step into Java library classes,<br>including java.*, javax.*, sun.*, com.sun.*, com.apple.eawt.*, and com.apple.eio.*</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_INTERPRETER, "Step Into Interpreter Classes", (SwingFrame)this, "<html>Whether the Debugger should step into the classes<br>used by the Interactions Pane (DynamicJava).</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_DRJAVA, "Step Into DrJava Classes", (SwingFrame)this, "Whether the Debugger should step into DrJava's own class files."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new VectorStringOptionComponent(OptionConstants.DEBUG_STEP_EXCLUDE, "Classes/Packages To Exclude", (SwingFrame)this, "<html>Any classes that the debuggger should not step into.<br>Should be a list of fully-qualified class names.<br>To exclude a package, add <code>packagename.*</code> to the list.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_AUTO_IMPORT, "Auto-Import after Breakpoint/Step", (SwingFrame)this, "<html>Whether the Debugger should automatically import packages<br>and classes again after a breakpoint or step.</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.AUTO_STEP_RATE, "Auto-Step Rate in ms", this, "<html>A defined rate in ms at which the debugger automatically steps into/over each line of code.<br>Value entered must be an integer value. </html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_EXPRESSIONS_AND_METHODS_IN_WATCHES, "Allow Expressions and Method Calls in Watches", (SwingFrame)this, "<html>Whether the Debugger should allow expressions and method<br>calls in watches. These may have side effects and can cause<br>delays during the debug process.</html>"));
        panel.displayComponents();
    }

    private void _setupJavadocPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_API_REF_VERSION, "Java Version for \"Open Java API Javadoc\"", this, "Version of the Java API documentation to be used."));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_ACCESS_LEVEL, "Access Level", this, "<html>Fields and methods with access modifiers at this level<br>or higher will be included in the generated Javadoc.</html>"));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_LINK_VERSION, "Java Version for Javadoc Links", this, "Version of Java for generating links to online Javadoc documentation."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_1_5_LINK, "Javadoc 1.5 URL", this, "URL for the Java 1.5 API, for generating links to library classes."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_1_6_LINK, "Javadoc 1.6 URL", this, "URL for the Java 1.6 API, for generating links to library classes."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JUNIT_LINK, "JUnit URL", this, "URL for the JUnit API, for \"Open Java API Javadoc\"."));
        VectorStringOptionComponent additionalJavadoc = new VectorStringOptionComponent(OptionConstants.JAVADOC_ADDITIONAL_LINKS, "Additional Javadoc URLs", this, "<html>Additional URLs with Javadoc, for \"Open Java API Javadoc\"<br>and auto-completion.</html>"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean verify(String s) {
                boolean result = true;
                try {
                    URL url = new URL(s + "/allclasses-frame.html");
                    InputStream urls = url.openStream();
                    InputStreamReader is = null;
                    BufferedReader br = null;
                    try {
                        is = new InputStreamReader(urls);
                        br = new BufferedReader(is);
                        String line = br.readLine();
                        if (line == null) {
                            result = false;
                        }
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (urls != null) {
                            urls.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    result = false;
                }
                if (!result) {
                    JOptionPane.showMessageDialog(ConfigFrame.this, "Could not find the Javadoc at the URL\n" + s, "Error Adding Javadoc", 0);
                }
                return result;
            }
        };
        this.addOptionComponent(panel, additionalJavadoc);
        this.addOptionComponent(panel, new DirectoryOptionComponent(OptionConstants.JAVADOC_DESTINATION, "Default Destination Directory", this, "Optional default directory for saving Javadoc documentation.", this._dirChooser));
        this.javadocCustomParams = new StringOptionComponent(OptionConstants.JAVADOC_CUSTOM_PARAMS, "Custom Javadoc Parameters", this, "Any extra flags or parameters to pass to Javadoc.");
        this.addOptionComponent(panel, this.javadocCustomParams);
        panel.displayComponents();
    }

    private void _setupNotificationsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.QUIT_PROMPT, "Prompt Before Quit", this, "Whether DrJava should prompt the user before quitting.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.INTERACTIONS_RESET_PROMPT, "Prompt Before Resetting Interactions Pane", this, "<html>Whether DrJava should prompt the user before<br>manually resetting the interactions pane.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.INTERACTIONS_EXIT_PROMPT, "Prompt if Interactions Pane Exits Unexpectedly", this, "<html>Whether DrJava should show a dialog box if a program<br>in the Interactions Pane exits without the user clicking Reset.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, "Prompt for Javadoc Destination", this, "<html>Whether Javadoc should always prompt the user<br>to select a destination directory.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.PROMPT_BEFORE_CLEAN, "Prompt before Cleaning Build Directory", this, "<html>Whether DrJava should prompt before cleaning the<br>build directory of a project</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.PROMPT_RENAME_LL_FILES, "Prompt to Rename Old Language Level Files When Saving", this, "<html>Whether DrJava should prompt the user to rename old language level files.<br>DrJava suggests to rename .dj0 and .dj1 files to .dj, and .dj2 files to .java.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, "Automatically Save Before Compiling", this, "<html>Whether DrJava should automatically save before<br>recompiling or ask the user each time.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT, "Automatically Compile Before Testing", this, "<html>Whether DrJava should automatically compile before<br>testing with JUnit or ask the user each time.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, "Automatically Save Before Generating Javadoc", this, "<html>Whether DrJava should automatically save before<br>generating Javadoc or ask the user each time.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JAVADOC, "Automatically Compile Before Generating Javadoc", this, "<html>Whether DrJava should automatically compile before<br>generating Javadoc or ask the user each time.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_BREAKPOINT_OUT_OF_SYNC, "Warn on Breakpoint if Out of Sync", this, "<html>Whether DrJava should warn the user if the class file<br>is out of sync before setting a breakpoint in that file.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_DEBUG_MODIFIED_FILE, "Warn if Debugging Modified File", this, "<html>Whether DrJava should warn the user if the file being<br>debugged has been modified since its last save.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_LAF, "Warn to Restart to Change Look and Feel", this, "<html>Whether DrJava should warn the user that look and feel<br>changes will not be applied until DrJava is restarted.</html>.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_THEME, "Warn to Restart to Change Theme", this, "<html>Whether DrJava should warn the user that theme<br>changes will not be applied until DrJava is restarted.</html>.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_DCP, "Warn to Restart to Change Default Compiler Preference", this, "<html>Whether DrJava should warn the user that default compiler preference<br>changes will not be applied until DrJava is restarted.</html>.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_MISC, "Warn to Restart to Change Preferences (other)", this, "<html>Whether DrJava should warn the user that preference<br>changes will not be applied until DrJava is restarted.</html>.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_INTERACTIONS, "Warn to Reset to Change Interactions", this, "<html>Whether DrJava should warn the user that preference<br>changes will not be applied until the Interactions Pane<br>is reset.</html>.", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_PATH_CONTAINS_POUND, "Warn if File's Path Contains a '#' Symbol", this, "<html>Whether DrJava should warn the user if the file being<br>saved has a path that contains a '#' symbol.<br>Users cannot use such files in the Interactions Pane<br>because of a bug in Java.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED, "Show a notification window when the first DrJava error occurs", this, "<html>Whether to show a notification window when the first DrJava error occurs.<br>If this is disabled, only the \"DrJava Error\" button will appear.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_IF_COMPIZ, "Warn If Compiz Detected", this, "<html>Whether DrJava should warn the user if Compiz is running.<br>Compiz and Java Swing are incompatible and can lead to crashes.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.DELETE_LL_CLASS_FILES, "Delete language level class files?", this, "Whether DrJava should delete class files in directories with language level files."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.NEW_VERSION_NOTIFICATION, "Check for new versions?", this, "Whether DrJava should check for new versions on drjava.org."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.NEW_VERSION_NOTIFICATION_DAYS, "Days between new version check", this, "The number of days between automatic new version checks."));
        panel.displayComponents();
    }

    private void _setupMiscPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.INDENT_LEVEL, "Indent Level", this, "The number of spaces to use for each level of indentation."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.RECENT_FILES_MAX_SIZE, "Recent Files List Size", this, "<html>The number of files to remember in<br>the recently used files list in the File menu.</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.BROWSER_HISTORY_MAX_SIZE, "Maximum Size of Browser History", this, "Determines how many entries are kept in the browser history."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.AUTO_CLOSE_COMMENTS, "Automatically Close Block Comments", (SwingFrame)this, "<html>Whether to automatically insert a closing comment tag (\"*/\")<br>when the enter key is pressed after typing a new block comment<br>tag (\"/*\" or \"/**\").</html>"));
        String runWithAssertMsg = "<html>Whether to execute <code>assert</code> statements in classes running in the interactions pane.</html>";
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.RUN_WITH_ASSERT, "Enable Assert Statement Execution", (SwingFrame)this, runWithAssertMsg));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.BACKUP_FILES, "Keep Emacs-style Backup Files", (SwingFrame)this, "<html>Whether DrJava should keep a backup copy of each file that<br>the user modifies, saved with a '~' at the end of the filename.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.RESET_CLEAR_CONSOLE, "Clear Console After Interactions Reset", (SwingFrame)this, "Whether to clear the Console output after resetting the Interactions Pane."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE, "Focus on the definitions pane after find/replace", (SwingFrame)this, "<html>Whether to focus on the definitions pane after executing a find/replace operation.<br>If this is not selected, the focus will be in the Find/Replace pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DRJAVA_USE_FORCE_QUIT, "Forcefully Quit DrJava", (SwingFrame)this, "<html>On some platforms, DrJava does not shut down properly when files are open<br>(namely tablet PCs). Check this option to force DrJava to close.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.REMOTE_CONTROL_ENABLED, "Enable Remote Control", (SwingFrame)this, "<html>Whether DrJava should listen to a socket (see below) so it<br>can be remote controlled and told to open files.<br>(Changes will not be applied until DrJava is restarted.)</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.REMOTE_CONTROL_PORT, "Remote Control Port", this, "<html>A running instance of DrJava can be remote controlled and<br>told to open files. This specifies the port used for remote control.<br>(Changes will not be applied until DrJava is restarted.)</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.FOLLOW_FILE_DELAY, "Follow File Delay", this, "<html>The delay in milliseconds that has to elapse before DrJava will check<br>if a file that is being followed or the output of an external process has changed.</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.FOLLOW_FILE_LINES, "Maximum Lines in \"Follow File\" Window", this, "<html>The maximum number of lines to keep in a \"Follow File\"<br>or \"External Process\" pane. Enter 0 for unlimited.</html>"));
        panel.displayComponents();
    }

    private void _setupJVMsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.MASTER_JVM_XMX, "Maximum Heap Size for Main JVM in MB", this, "The maximum heap the Main JVM can use. Select blank for default."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.MASTER_JVM_ARGS, "JVM Args for Main JVM", this, "The command-line arguments to pass to the Main JVM."));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.SLAVE_JVM_XMX, "Maximum Heap Size for Interactions JVM in MB", this, "The maximum heap the Interactions JVM can use. Select blank for default"));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.SLAVE_JVM_ARGS, "JVM Args for Interactions JVM", this, "The command-line arguments to pass to the Interactions JVM."));
        panel.displayComponents();
    }

    private void _setupFileTypesPanel(ConfigPanel panel) {
        if (PlatformFactory.ONLY.canRegisterFileExtensions()) {
            this.addOptionComponent(panel, new LabelComponent("<html>Assign DrJava project files and DrJava extensions<br>(with the extensions .drjava and .djapp) to DrJava.<br>When double-clicking on a .drjava file, DrJava will open it.</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.registerDrJavaFileExtensions()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully set .drjava and .djapp file associations.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not set .drjava and .djapp file associations.", "File Types Error", 0);
                    }
                }
            }, "Associate .drjava and .djapp Files with DrJava", this, "This associates .drjava and .djapp files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.unregisterDrJavaFileExtensions()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully removed .drjava and .djapp file associations.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not remove .drjava and .djapp file associations.", "File Types Error", 0);
                    }
                }
            }, "Remove .drjava and .djapp File Associations", this, "This removes the association of .drjava and .djapp files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>Assign Java source files with the<br>extension .java to DrJava. When double-clicking<br>on a .java file, DrJava will open it.</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.registerJavaFileExtension()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully set .java file association.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not set .java file association.", "File Types Error", 0);
                    }
                }
            }, "Associate .java Files with DrJava", this, "This associates .java source files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.unregisterJavaFileExtension()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully removed .java file association.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not remove .java file association.", "File Types Error", 0);
                    }
                }
            }, "Remove .java File Association", this, "This removes the association of .java project files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.FILE_EXT_REGISTRATION, "<html>Automatically assign .java, .drjava and .djapp Files to DrJava</html>", this, "<html>Assign files with the extensions .java, .drjava and .djapp to DrJava.<br>When double-clicking those files, they will be opened in DrJava.<br><br>Selecting 'always' will re-establish this association every time DrJava<br>started, without asking. Selecting 'ask me' will ask the user at start up<br>if the association has been changed. Selecting 'never' will not assign<br>.java, .drjava and .djapp files to DrJava."));
        } else {
            this.addOptionComponent(panel, new LabelComponent("<html><br><br>" + (PlatformFactory.ONLY.isMacPlatform() ? "File associations are managed automatically by Mac OS." : (PlatformFactory.ONLY.isWindowsPlatform() ? "To set file associations, please use the .exe file version of DrJava.<br>Configuring file associations is not supported for the .jar file version." : "Managing file associations is not supported yet on this operating system.")) + "</html>", (SwingFrame)this, true));
        }
        panel.displayComponents();
    }

    private void _setupCompilerPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_UNCHECKED_WARNINGS, "Show Unchecked Warnings", this, "<html>Warn about unchecked conversions involving parameterized types.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_DEPRECATION_WARNINGS, "Show Deprecation Warnings", this, "<html>Warn about each use or override of a deprecated method, field, or class.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_PATH_WARNINGS, "Show Path Warnings", this, "<html>Warn about nonexistent members of the classpath and sourcepath.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_SERIAL_WARNINGS, "Show Serial Warnings", this, "<html>Warn about missing <code>serialVersionUID</code> definitions on serializable classes.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_FINALLY_WARNINGS, "Show Finally Warnings", this, "<html>Warn about <code>finally</code> clauses that cannot complete normally.</html>", false).setEntireColumn(true));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_FALLTHROUGH_WARNINGS, "Show Fall-Through Warnings", this, "<html>Warn about <code>switch</code> block cases that fall through to the next case.</html>", false).setEntireColumn(true));
        final ForcedChoiceOptionComponent CPC = new ForcedChoiceOptionComponent(OptionConstants.COMPILER_PREFERENCE_CONTROL.evaluate(), "Compiler Preference", this, "Which compiler is prefered?");
        ActionListener CPCActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!DrJava.getConfig().getSetting(OptionConstants.DEFAULT_COMPILER_PREFERENCE).equals(CPC.getCurrentComboBoxValue())) {
                    DrJava.getConfig().setSetting(OptionConstants.DEFAULT_COMPILER_PREFERENCE, CPC.getCurrentComboBoxValue());
                }
            }
        };
        this._applyButton.addActionListener(CPCActionListener);
        this._okButton.addActionListener(CPCActionListener);
        this.addOptionComponent(panel, CPC.setEntireColumn(false));
        this.addOptionComponent(panel, new LabelComponent("<html><br><br>Note: Compiler warnings not shown if compiling any Java language level files.</html>", (SwingFrame)this, true));
        panel.displayComponents();
    }

    private void _setupInteractionsPanel(ConfigPanel panel) {
        final DirectoryOptionComponent wdComponent = new DirectoryOptionComponent(OptionConstants.FIXED_INTERACTIONS_DIRECTORY, "Interactions Working Directory", this, "<html>Working directory for the Interactions Pane (unless<br>a project working directory has been set).</html>", this._dirChooser);
        this.addOptionComponent(panel, wdComponent);
        final BooleanOptionComponent stickyComponent = new BooleanOptionComponent(OptionConstants.STICKY_INTERACTIONS_DIRECTORY, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Restore last working directory of the Interactions pane on start up", 33, "<br>", " \t\n-,;.("), (SwingFrame)this, "<html>Whether to restore the last working directory of the Interaction pane on start up,<br>or to always use the value of the \"user.home\" Java property<br>(currently " + System.getProperty("user.home") + ").");
        this.addOptionComponent(panel, stickyComponent);
        OptionComponent.ChangeListener wdListener = new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                File f = ((DirectorySelectorComponent)wdComponent.getComponent()).getFileFromField();
                boolean enabled = f == null || f.equals(FileOps.NULL_FILE);
                ((JCheckBox)stickyComponent.getComponent()).setEnabled(enabled);
                return null;
            }
        };
        wdComponent.addChangeListener(wdListener);
        wdListener.value(wdComponent);
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, "Smart Run Command", (SwingFrame)this, "<html>Whether the Run button and meni item should automatically detect<br>applets and ACM Java Task Force programs (subclasses of acm.program.Program).</html>"));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.HISTORY_MAX_SIZE, "Size of Interactions History", this, "The number of interactions to remember in the history."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_ENABLED, "Enable the \"Auto Import\" Dialog", (SwingFrame)this, "<html>Whether DrJava should open the \"Auto Import\" dialog when<br>an undefined class is encountered in the Interactions Pane.</html>"));
        VectorStringOptionComponent autoImportClasses = new VectorStringOptionComponent(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES, "Classes to Auto-Import", this, "<html>List of classes to auto-import every time the<br>Interaction Pane is reset or started. Examples:<br><br>java.io.File<br>java.util.*</html>"){

            protected boolean verify(String s) {
                boolean result = true;
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '.' || ch == '*' || Character.isJavaIdentifierPart(ch)) continue;
                    result = false;
                    break;
                }
                if (!result) {
                    JOptionPane.showMessageDialog(ConfigFrame.this, "This is not a valid class name:\n" + s, "Error Adding Class Name", 0);
                }
                return result;
            }
        };
        this.addOptionComponent(panel, autoImportClasses);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.DYNAMICJAVA_ACCESS_CONTROL, "Enforce access control", this, "What kind of access control should DrJava enforce in the Interactions Pane?"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DYNAMICJAVA_REQUIRE_SEMICOLON, "Require Semicolon", (SwingFrame)this, "<html>Whether DrJava should require a semicolon at the<br>end of a statement in the Interactions Pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DYNAMICJAVA_REQUIRE_VARIABLE_TYPE, "Require Variable Type", (SwingFrame)this, "<html>Whether DrJava should require a variable type for<br>variable declarations in the Interactions Pane.</html>"));
        panel.displayComponents();
    }

    private void _setupJUnitPanel(ConfigPanel panel) {
        final BooleanOptionComponent junitLocEnabled = new BooleanOptionComponent(OptionConstants.JUNIT_LOCATION_ENABLED, "Use external JUnit", this, "<html>If this is enabled, DrJava will use the JUnit configured<br>below under 'JUnit/ConcJUnit Location'. If it is disabled,<br>DrJava will use the JUnit that is built-in.</html>", false).setEntireColumn(true);
        this.addOptionComponent(panel, junitLocEnabled);
        final FileOptionComponent junitLoc = new FileOptionComponent(OptionConstants.JUNIT_LOCATION, "JUnit/ConcJUnit Location", (SwingFrame)this, "<html>Optional location of the JUnit or ConcJUnit jar file.<br>(Changes will not be applied until the Interactions Pane<br>is reset.)</html>", new FileSelectorComponent(this, this._jarChooser, 30, 10.0f){

            public void setFileField(File file) {
                if (ConcJUnitUtils.isValidJUnitFile(file) || ConcJUnitUtils.isValidConcJUnitFile(file)) {
                    super.setFileField(file);
                } else if (file.exists()) {
                    new DrJavaScrollableDialog(this._parent, "Invalid JUnit/ConcJUnit File", "Stack trace:", StringOps.getStackTrace(), 600, 400, false).show();
                    JOptionPane.showMessageDialog(this._parent, "The file '" + file.getName() + "'\nis not a valid JUnit/ConcJUnit file.", "Invalid JUnit/ConcJUnit File", 0);
                    this.resetFileField();
                }
            }

            public boolean validateTextField() {
                String newValue = this._fileField.getText().trim();
                File newFile = FileOps.NULL_FILE;
                if (!newValue.equals("")) {
                    newFile = new File(newValue);
                }
                if (newFile != FileOps.NULL_FILE && !newFile.exists()) {
                    JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis invalid because it does not exist.", "Invalid File Name", 0);
                    if (this._file != null && !this._file.exists()) {
                        this._file = FileOps.NULL_FILE;
                    }
                    this.resetFileField();
                    return false;
                }
                if (ConcJUnitUtils.isValidJUnitFile(newFile) || ConcJUnitUtils.isValidConcJUnitFile(newFile) || FileOps.NULL_FILE.equals(newFile)) {
                    this.setFileField(newFile);
                    return true;
                }
                new DrJavaScrollableDialog(this._parent, "Invalid JUnit/ConcJUnit File", "newFile is NULL_FILE? " + FileOps.NULL_FILE.equals(newFile), StringOps.getStackTrace(), 600, 400, false).show();
                JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis not a valid JUnit/ConcJUnit file.", "Invalid JUnit/ConcJUnit File", 0);
                this.resetFileField();
                return false;
            }
        });
        junitLoc.setFileFilter(ClassPathFilter.ONLY);
        this.addOptionComponent(panel, junitLoc);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        final ForcedChoiceOptionComponent concJUnitChecksEnabledComponent = new ForcedChoiceOptionComponent(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "Enabled ConcJUnit Checks", this, "<html>The concurrent unit testing checks that should be performed.<br>'none' uses plain JUnit. ConcJUnit can also detect failures in<br>all threads ('all-threads'), detect threads that did not end in<br>time ('all-threads, join'), and threads that ended in time only<br>because they were lucky ('all-threads, nojoin, lucky).<br>The last setting requires a 'ConcJUnit Runtime Location' to be set.</html>");
        this.addOptionComponent(panel, concJUnitChecksEnabledComponent);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        final FileOptionComponent rtConcJUnitLoc = new FileOptionComponent(OptionConstants.RT_CONCJUNIT_LOCATION, "ConcJUnit Runtime Location", (SwingFrame)this, "<html>Optional location of the Java Runtime Library processed<br>to generate &quot;lucky&quot; warnings. If left blank, &quot;lucky&quot; warnings<br>will not be generated. This setting is deactivated if the path to<br>ConcJUnit has not been specified above.<br>(Changes will not be applied until the Interactions Pane is reset.)</html>", new FileSelectorComponent(this, this._jarChooser, 30, 10.0f){

            public void setFileField(File file) {
                if (ConcJUnitUtils.isValidRTConcJUnitFile(file)) {
                    super.setFileField(file);
                } else if (file.exists()) {
                    JOptionPane.showMessageDialog(this._parent, "The file '" + file.getName() + "'\nis not a valid ConcJUnit Runtime file.", "Invalid ConcJUnit Runtime File", 0);
                    this.resetFileField();
                }
            }

            public boolean validateTextField() {
                String newValue = this._fileField.getText().trim();
                File newFile = FileOps.NULL_FILE;
                if (!newValue.equals("")) {
                    newFile = new File(newValue);
                }
                if (newFile != FileOps.NULL_FILE && !newFile.exists()) {
                    JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis invalid because it does not exist.", "Invalid File Name", 0);
                    if (this._file != null && !this._file.exists()) {
                        this._file = FileOps.NULL_FILE;
                    }
                    this.resetFileField();
                    return false;
                }
                if (ConcJUnitUtils.isValidRTConcJUnitFile(newFile) || FileOps.NULL_FILE.equals(newFile)) {
                    this.setFileField(newFile);
                    return true;
                }
                JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis not a valid ConcJUnit Runtime file.", "Invalid ConcJUnit Runtime File", 0);
                this.resetFileField();
                return false;
            }
        });
        rtConcJUnitLoc.setFileFilter(ClassPathFilter.ONLY);
        ActionListener processRTListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File concJUnitJarFile = FileOps.getDrJavaFile();
                if (((JCheckBox)junitLocEnabled.getComponent()).isSelected()) {
                    concJUnitJarFile = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                }
                File rtFile = ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).getFileFromField();
                ConcJUnitUtils.showGenerateRTConcJUnitJarFileDialog(ConfigFrame.this, rtFile, concJUnitJarFile, new Runnable1<File>(){

                    @Override
                    public void run(File targetFile) {
                        ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).setFileField(targetFile);
                    }
                }, new Runnable(){

                    public void run() {
                    }
                });
            }
        };
        final ButtonComponent processRT = new ButtonComponent(processRTListener, "Generate ConcJUnit Runtime File", this, "<html>Generate the ConcJUnit Runtime file specified above.<br>This setting is deactivated if the path to ConcJUnit has not been specified above.</html>");
        OptionComponent.ChangeListener rtConcJUnitListener = new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                File f = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                boolean enabled = !((JCheckBox)junitLocEnabled.getComponent()).isSelected() || ConcJUnitUtils.isValidConcJUnitFile(f);
                ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).setEnabled(enabled);
                ((JButton)processRT.getComponent()).setEnabled(enabled);
                ((JComboBox)concJUnitChecksEnabledComponent.getComponent()).setEnabled(enabled);
                return null;
            }
        };
        OptionComponent.ChangeListener junitLocListener = new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                boolean enabled = ((JCheckBox)junitLocEnabled.getComponent()).isSelected();
                ((FileSelectorComponent)junitLoc.getComponent()).setEnabled(enabled);
                return null;
            }
        };
        junitLocEnabled.addChangeListener(junitLocListener);
        junitLocEnabled.addChangeListener(rtConcJUnitListener);
        junitLoc.addChangeListener(rtConcJUnitListener);
        this.addOptionComponent(panel, rtConcJUnitLoc);
        this.addOptionComponent(panel, processRT);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        final LabelComponent internalExternalStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
        final LabelComponent threadsStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
        final LabelComponent joinStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
        final LabelComponent luckyStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
        OptionComponent.ChangeListener junitStatusChangeListener = new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                File f = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                String[] s = new String[]{" ", " ", " ", " "};
                boolean isConcJUnit = true;
                if (!((JCheckBox)junitLocEnabled.getComponent()).isSelected() || f == null || FileOps.NULL_FILE.equals(f) || !f.exists()) {
                    s[0] = "DrJava uses the built-in ConcJUnit framework.";
                } else {
                    String type = "ConcJUnit";
                    if (!ConcJUnitUtils.isValidConcJUnitFile(f)) {
                        type = "JUnit";
                        isConcJUnit = false;
                    }
                    s[0] = "DrJava uses an external " + type + " framework.";
                }
                if (!isConcJUnit) {
                    s[1] = "JUnit does not support all-thread, no-join";
                    s[2] = "or lucky checks. They are all disabled.";
                } else {
                    s[1] = "All-thread checks are disabled.";
                    s[2] = "No-join checks are disabled.";
                    s[3] = "Lucky checks are disabled.";
                    if (!concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("none (use JUnit)")) {
                        s[1] = "All-thread checks are enabled.";
                        if (concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join, lucky") || concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join")) {
                            File rtf;
                            s[2] = "No-join checks are enabled.";
                            if (concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join, lucky") && (rtf = ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).getFileFromField()) != null && !FileOps.NULL_FILE.equals(rtf) && rtf.exists() && ConcJUnitUtils.isValidRTConcJUnitFile(rtf)) {
                                s[3] = "Lucky checks are enabled.";
                            }
                        }
                    }
                }
                internalExternalStatus.getComponent().setText(s[0]);
                threadsStatus.getComponent().setText(s[1]);
                joinStatus.getComponent().setText(s[2]);
                luckyStatus.getComponent().setText(s[3]);
                return null;
            }
        };
        concJUnitChecksEnabledComponent.addChangeListener(junitStatusChangeListener);
        junitLocEnabled.addChangeListener(junitStatusChangeListener);
        junitLoc.addChangeListener(junitStatusChangeListener);
        rtConcJUnitLoc.addChangeListener(junitStatusChangeListener);
        this.addOptionComponent(panel, internalExternalStatus);
        this.addOptionComponent(panel, threadsStatus);
        this.addOptionComponent(panel, joinStatus);
        this.addOptionComponent(panel, luckyStatus);
        junitLocListener.value(null);
        rtConcJUnitListener.value(null);
        junitStatusChangeListener.value(null);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        BooleanOptionComponent forceTestSuffix = new BooleanOptionComponent(OptionConstants.FORCE_TEST_SUFFIX, "Require test classes in projects to end in \"Test\"", this, "Whether to force test classes in projects to end in \"Test\".", false).setEntireColumn(true);
        this.addOptionComponent(panel, forceTestSuffix);
        panel.displayComponents();
    }

    private class PanelTreeSelectionListener
    implements TreeSelectionListener {
        private PanelTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object o = ConfigFrame.this._tree.getLastSelectedPathComponent();
            if (o instanceof PanelTreeNode) {
                PanelTreeNode child = (PanelTreeNode)ConfigFrame.this._tree.getLastSelectedPathComponent();
                ConfigFrame.this._displayPanel(child.getPanel());
            }
        }
    }

    private class PanelTreeNode
    extends DefaultMutableTreeNode {
        private final ConfigPanel _panel;

        public PanelTreeNode(String t) {
            super(t);
            this._panel = new ConfigPanel(t);
        }

        public PanelTreeNode(ConfigPanel c) {
            super(c.getTitle());
            this._panel = c;
        }

        private ConfigPanel getPanel() {
            return this._panel;
        }

        private boolean update() {
            boolean isValidUpdate = this._panel.update();
            if (!isValidUpdate) {
                Object[] nodes = this.getPath();
                TreePath path = new TreePath(nodes);
                ConfigFrame.this._tree.expandPath(path);
                ConfigFrame.this._tree.setSelectionPath(path);
                return false;
            }
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                boolean isValidUpdateChildren = ((PanelTreeNode)childNodes.nextElement()).update();
                if (isValidUpdateChildren) continue;
                return false;
            }
            return true;
        }

        public void resetToCurrent() {
            this._panel.resetToCurrent();
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                ((PanelTreeNode)childNodes.nextElement()).resetToCurrent();
            }
        }
    }
}

