/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.JavaSourceFilter;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.SmartSourceFilter;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.VectorAbsRelFileOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.AbsRelFile;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProjectPropertiesFrame
extends SwingFrame {
    private static final int FRAME_WIDTH = 503;
    private static final int FRAME_HEIGHT = 500;
    private MainFrame _mainFrame;
    private SingleDisplayModel _model;
    private final JButton _okButton;
    private final JButton _applyButton;
    private final JButton _cancelButton;
    private JPanel _mainPanel;
    private DirectorySelectorComponent _projRootSelector;
    private DirectorySelectorComponent _buildDirSelector;
    private DirectorySelectorComponent _workDirSelector;
    private JTextField _mainDocumentSelector;
    private JCheckBox _autoRefreshComponent;
    private VectorAbsRelFileOptionComponent _extraClassPathList;
    private VectorFileOptionComponent _excludedFilesList;
    private DocumentListener _applyListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        public void removeUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        public void changedUpdate(DocumentEvent e) {
            this.setEnabled();
        }

        private void setEnabled() {
            assert (EventQueue.isDispatchThread());
            ProjectPropertiesFrame.this._applyButton.setEnabled(true);
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ProjectPropertiesFrame.this.cancel();
        }
    };

    public ProjectPropertiesFrame(MainFrame mf) {
        super("Project Properties");
        this._mainFrame = mf;
        this._model = this._mainFrame.getModel();
        this._mainPanel = new JPanel();
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                successful = ProjectPropertiesFrame.this.saveSettings();
                if (successful) {
                    ProjectPropertiesFrame.this.setVisible(false);
                }
                ProjectPropertiesFrame.this.reset();
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.saveSettings();
                ProjectPropertiesFrame.this.reset();
            }
        };
        this._applyButton = new JButton(applyAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        this.init();
        this.initDone();
    }

    private void init() {
        this._setupPanel(this._mainPanel);
        JScrollPane scrollPane = new JScrollPane(this._mainPanel);
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cpLayout.setConstraints(scrollPane, c);
        cp.add(scrollPane);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dim.width = dim.width > 503 ? 503 : (dim.width -= 80);
        dim.height = dim.height > 500 ? 500 : (dim.height -= 80);
        this.setSize(dim);
        Utilities.setPopupLoc(this, this._mainFrame);
        this.reset();
    }

    public void cancel() {
        this.reset();
        this._applyButton.setEnabled(false);
        this.setVisible(false);
    }

    public void reset() {
        this.reset(this._model.getProjectRoot());
    }

    private void reset(File projRoot) {
        this._projRootSelector.setFileField(projRoot);
        File bd = this._model.getBuildDirectory();
        JTextField bdTextField = this._buildDirSelector.getFileField();
        if (bd == FileOps.NULL_FILE) {
            bdTextField.setText("");
        } else {
            this._buildDirSelector.setFileField(bd);
        }
        File wd = this._model.getWorkingDirectory();
        JTextField wdTextField = this._workDirSelector.getFileField();
        if (wd == FileOps.NULL_FILE) {
            wdTextField.setText("");
        } else {
            this._workDirSelector.setFileField(wd);
        }
        String mc = this._model.getMainClass();
        JTextField mcTextField = this._mainDocumentSelector;
        if (mc == null) {
            mcTextField.setText("");
        } else {
            mcTextField.setText(mc);
        }
        this._autoRefreshComponent.setSelected(this._getAutoRefreshStatus());
        ArrayList<AbsRelFile> cp = new ArrayList<AbsRelFile>(CollectUtil.makeList(this._model.getExtraClassPath()));
        this._extraClassPathList.setValue(cp);
        ArrayList<File> ef = new ArrayList<File>();
        for (File f : this._model.getExclFiles()) {
            ef.add(f);
        }
        this._excludedFilesList.setValue(ef);
        this._applyButton.setEnabled(false);
    }

    public boolean saveSettings() {
        boolean projRootChanged = false;
        File pr = this._projRootSelector.getFileFromField();
        if (!pr.equals(this._model.getProjectRoot())) {
            this._model.setProjectRoot(pr);
            projRootChanged = true;
        }
        File bd = this._buildDirSelector.getFileFromField();
        if (this._buildDirSelector.getFileField().getText().equals("")) {
            bd = FileOps.NULL_FILE;
        }
        this._model.setBuildDirectory(bd);
        File wd = this._workDirSelector.getFileFromField();
        if (this._workDirSelector.getFileField().getText().equals("")) {
            wd = FileOps.NULL_FILE;
        }
        this._model.setWorkingDirectory(wd);
        String mc = this._mainDocumentSelector.getText();
        if (mc == null) {
            mc = "";
        }
        this._model.setMainClass(mc);
        Vector extras = this._extraClassPathList.getValue();
        this._model.setExtraClassPath(IterUtil.snapshot(extras));
        this._model.setAutoRefreshStatus(this._autoRefreshComponent.isSelected());
        this._model.setExcludedFiles(this._excludedFilesList.getValue().toArray(new File[0]));
        if (projRootChanged) {
            try {
                this._model.reloadProject(this._mainFrame.getCurrentProject(), this._mainFrame.gatherProjectDocInfo());
            }
            catch (IOException e) {
                throw new UnexpectedException(e, "I/O error while reloading project");
            }
        }
        return true;
    }

    private File _getProjRoot() {
        File projRoot = this._model.getProjectRoot();
        if (projRoot != null) {
            return projRoot;
        }
        return FileOps.NULL_FILE;
    }

    private File _getBuildDir() {
        File buildDir = this._model.getBuildDirectory();
        if (buildDir != null) {
            return buildDir;
        }
        return FileOps.NULL_FILE;
    }

    private File _getWorkDir() {
        File workDir = this._model.getWorkingDirectory();
        if (workDir != null) {
            return workDir;
        }
        return FileOps.NULL_FILE;
    }

    private File _getMainFile() {
        File mainFile = this._model.getMainClassContainingFile();
        if (mainFile != null) {
            return mainFile;
        }
        return FileOps.NULL_FILE;
    }

    private String _getMainClass() {
        String mainClass = this._model.getMainClass();
        if (mainClass == null) {
            return "";
        }
        return mainClass;
    }

    private boolean _getAutoRefreshStatus() {
        return this._model.getAutoRefreshStatus();
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel prLabel = new JLabel("Project Root");
        prLabel.setToolTipText("<html>The root directory for the project source files .<br>If not specified, the parent directory of the project file.</html>");
        gridbag.setConstraints(prLabel, c);
        panel.add(prLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel prPanel = this._projRootPanel();
        gridbag.setConstraints(prPanel, c);
        panel.add(prPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel bdLabel = new JLabel("Build Directory");
        bdLabel.setToolTipText("<html>The directory the class files will be compiled into.<br>If not specified, the class files will be compiled into<br>the same directory as their corresponding source files</html>");
        gridbag.setConstraints(bdLabel, c);
        panel.add(bdLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel bdPanel = this._buildDirectoryPanel();
        gridbag.setConstraints(bdPanel, c);
        panel.add(bdPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel wdLabel = new JLabel("Working Directory");
        wdLabel.setToolTipText("<html>The root directory for relative path names.</html>");
        gridbag.setConstraints(wdLabel, c);
        panel.add(wdLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel wdPanel = this._workDirectoryPanel();
        gridbag.setConstraints(wdPanel, c);
        panel.add(wdPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel classLabel = new JLabel("Main Class");
        classLabel.setToolTipText("<html>The class containing the <code>main</code><br>method for the entire project</html>");
        gridbag.setConstraints(classLabel, c);
        panel.add(classLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel mainClassPanel = this._mainDocumentSelector();
        gridbag.setConstraints(mainClassPanel, c);
        panel.add(mainClassPanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel extrasLabel = new JLabel("Extra Classpath");
        extrasLabel.setToolTipText("<html>The list of extra classpaths to load with the project.<br>This may include either JAR files or directories. Any<br>classes defined in these classpath locations will be <br>visible in the interactions pane and also accessible <br>by the compiler when compiling the project.<br>The entries are relative to the project file unless<br>the 'Absolute' checkbox is marked.</html>");
        gridbag.setConstraints(extrasLabel, c);
        panel.add(extrasLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component extrasComponent = this._extraClassPathComponent();
        gridbag.setConstraints(extrasComponent, c);
        panel.add(extrasComponent);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel refreshLabel = new JLabel("<html>Auto Refresh<br>on Open</html>");
        refreshLabel.setToolTipText("<html>Whether the project will automatically open new files found within the source tree</html>");
        gridbag.setConstraints(refreshLabel, c);
        panel.add(refreshLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._autoRefreshComponent = new JCheckBox();
        gridbag.setConstraints(this._autoRefreshComponent, c);
        panel.add(this._autoRefreshComponent);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel excludedLabel = new JLabel("<html>Files Excluded from<br>Auto-Refresh</html>");
        excludedLabel.setToolTipText("<html>The list of source files excluded from project auto-refresh.<br>These files will not be added to the project.</html>");
        gridbag.setConstraints(excludedLabel, c);
        panel.add(excludedLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component excludedComponent = this._excludedFilesComponent();
        gridbag.setConstraints(excludedComponent, c);
        panel.add(excludedComponent);
    }

    public JPanel _projRootPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        dirChooser.setSelectedFile(this._getProjRoot());
        dirChooser.setDialogTitle("Select Project Root Folder");
        dirChooser.setApproveButtonText("Select");
        this._projRootSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f){

            protected void _chooseFile() {
                ProjectPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectPropertiesFrame.this);
                super._chooseFile();
                ProjectPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectPropertiesFrame.this, LambdaUtil.NO_OP, ProjectPropertiesFrame.this.CANCEL);
            }
        };
        this._projRootSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._projRootSelector;
    }

    public JPanel _buildDirectoryPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        File bd = this._getBuildDir();
        if (bd == null || bd == FileOps.NULL_FILE) {
            bd = this._getProjRoot();
        }
        dirChooser.setSelectedFile(bd);
        dirChooser.setDialogTitle("Select Build Directory");
        dirChooser.setApproveButtonText("Select");
        this._buildDirSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f, false){

            protected void _chooseFile() {
                ProjectPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectPropertiesFrame.this);
                super._chooseFile();
                ProjectPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectPropertiesFrame.this, LambdaUtil.NO_OP, ProjectPropertiesFrame.this.CANCEL);
            }
        };
        this._buildDirSelector.setFileField(bd);
        this._buildDirSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._buildDirSelector;
    }

    public JPanel _workDirectoryPanel() {
        DirectoryChooser dirChooser = new DirectoryChooser(this);
        dirChooser.setSelectedFile(this._getWorkDir());
        dirChooser.setDialogTitle("Select Working Directory");
        dirChooser.setApproveButtonText("Select");
        this._workDirSelector = new DirectorySelectorComponent(this, dirChooser, 20, 12.0f){

            protected void _chooseFile() {
                ProjectPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectPropertiesFrame.this);
                super._chooseFile();
                ProjectPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectPropertiesFrame.this, LambdaUtil.NO_OP, ProjectPropertiesFrame.this.CANCEL);
            }
        };
        this._workDirSelector.getFileField().getDocument().addDocumentListener(this._applyListener);
        return this._workDirSelector;
    }

    public Component _extraClassPathComponent() {
        this._extraClassPathList = new VectorAbsRelFileOptionComponent(null, "Extra Project Classpaths", this, null, true){

            protected Action _getAddAction() {
                final Action a = super._getAddAction();
                return new AbstractAction("Add"){

                    public void actionPerformed(ActionEvent ae) {
                        ProjectPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectPropertiesFrame.this);
                        a.actionPerformed(ae);
                        ProjectPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectPropertiesFrame.this, LambdaUtil.NO_OP, ProjectPropertiesFrame.this.CANCEL);
                    }
                };
            }
        };
        this._extraClassPathList.setRows(5, 5);
        this._extraClassPathList.addChangeListener(new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                ProjectPropertiesFrame.this._applyButton.setEnabled(true);
                return null;
            }
        });
        return this._extraClassPathList.getComponent();
    }

    public Component _excludedFilesComponent() {
        this._excludedFilesList = new VectorFileOptionComponent(null, "Files Excluded from Auto-Refresh", this, null, false){

            protected Action _getAddAction() {
                final Action a = super._getAddAction();
                return new AbstractAction("Add"){

                    public void actionPerformed(ActionEvent ae) {
                        ProjectPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectPropertiesFrame.this);
                        a.actionPerformed(ae);
                        ProjectPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectPropertiesFrame.this, LambdaUtil.NO_OP, ProjectPropertiesFrame.this.CANCEL);
                    }
                };
            }
        };
        this._excludedFilesList.setRows(5, 5);
        this._excludedFilesList.getFileChooser().resetChoosableFileFilters();
        this._excludedFilesList.getFileChooser().addChoosableFileFilter(new JavaSourceFilter());
        this._excludedFilesList.getFileChooser().setFileFilter(new SmartSourceFilter());
        this._excludedFilesList.addChangeListener(new OptionComponent.ChangeListener(){

            public Object value(Object oc) {
                ProjectPropertiesFrame.this._applyButton.setEnabled(true);
                return null;
            }
        });
        if (this._model.getProjectRoot() != null) {
            this._excludedFilesList.setBaseDir(this._model.getProjectRoot());
        }
        return this._excludedFilesList.getComponent();
    }

    public JPanel _mainDocumentSelector() {
        File projRoot = this._getProjRoot();
        final FileChooser chooser = new FileChooser(projRoot);
        chooser.setFileSelectionMode(0);
        chooser.setDialogType(2);
        chooser.setDialogTitle("Select Main Class");
        chooser.setCurrentDirectory(projRoot);
        File mainFile = this._getMainFile();
        if (mainFile != FileOps.NULL_FILE) {
            chooser.setSelectedFile(mainFile);
        }
        chooser.setApproveButtonText("Select");
        chooser.resetChoosableFileFilters();
        chooser.addChoosableFileFilter(new SmartSourceFilter());
        chooser.addChoosableFileFilter(new JavaSourceFilter());
        this._mainDocumentSelector = new JTextField(20){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this._mainDocumentSelector.setFont(this._mainDocumentSelector.getFont().deriveFont(12.0f));
        this._mainDocumentSelector.setPreferredSize(new Dimension(22, 22));
        this._mainDocumentSelector.getDocument().addDocumentListener(this._applyListener);
        JButton selectFile = new JButton("...");
        selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ret = chooser.showOpenDialog(ProjectPropertiesFrame.this);
                if (ret != 0) {
                    return;
                }
                File mainClass = chooser.getSelectedFile();
                File sourceRoot = new File(ProjectPropertiesFrame.this._projRootSelector.getFileField().getText());
                if (sourceRoot == null || mainClass == null) {
                    return;
                }
                if (!mainClass.getAbsolutePath().startsWith(sourceRoot.getAbsolutePath())) {
                    JOptionPane.showMessageDialog(ProjectPropertiesFrame.this, "Main Class must be in either Project Root or one of its sub-directories.", "Unable to set Main Class", 0);
                    ProjectPropertiesFrame.this._mainDocumentSelector.setText("");
                    return;
                }
                String qualifiedName = mainClass.getAbsolutePath().substring(sourceRoot.getAbsolutePath().length());
                if (qualifiedName.startsWith("" + File.separatorChar)) {
                    qualifiedName = qualifiedName.substring(1);
                }
                if (qualifiedName.toLowerCase().endsWith(".java")) {
                    qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 5);
                }
                ProjectPropertiesFrame.this._mainDocumentSelector.setText(qualifiedName.replace(File.separatorChar, '.'));
            }
        });
        selectFile.setMaximumSize(new Dimension(22, 22));
        selectFile.setMargin(new Insets(0, 5, 0, 5));
        JPanel toRet = new JPanel();
        BoxLayout layout = new BoxLayout(toRet, 0);
        toRet.setLayout(layout);
        toRet.add(this._mainDocumentSelector);
        toRet.add(selectFile);
        return toRet;
    }

    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }
}

