/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.UneditableTableModel;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static ImageInfo CSLOGO = new ImageInfo("RiceCS.gif", new Color(4339077));
    private static ImageInfo SF = new ImageInfo("SourceForge.gif", Color.black);
    private static ImageInfo DRJAVA = new ImageInfo("DrJava.png", new Color(0xCCCCFF));
    private final JButton _okButton = new JButton("OK");
    private JButton _copyButton;
    private JTable _propertiesTable;
    private int _propertiesTabIndex;
    private final JTabbedPane _tabs = new JTabbedPane();
    public static final String COPYRIGHT = "Copyright (c) 2001-2010, JavaPLT group at Rice University (javaplt@rice.edu)\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n* Neither the names of DrJava, the JavaPLT group, Rice University, nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThis software is Open Source Initiative approved Open Source Software.\nOpen Source Initative Approved is a trademark of the Open Source Initiative.\n";
    private static String LICENSE;
    private static boolean initLicense;
    public static final String DYADE_LICENSE = "DynamicJava - Copyright \u00a9 1999 Dyade\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL DYADE BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\nExcept as contained in this notice, the name of Dyade shall not be used in advertising or otherwise to promote the sale, use or other dealings in this Software without prior written authorization from Dyade.";
    public static final String ECLIPSE_LICENSE = "Eclipse Public License - v 1.0\n\nTHE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC LICENSE (\"AGREEMENT\"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.\n\n1. DEFINITIONS\n\n\"Contribution\" means:\n\na) in the case of the initial Contributor, the initial code and documentation distributed under this Agreement, and\n\nb) in the case of each subsequent Contributor:\n\ni) changes to the Program, and\n\nii) additions to the Program;\n\nwhere such changes and/or additions to the Program originate from and are distributed by that particular Contributor. A Contribution 'originates' from a Contributor if it was added to the Program by such Contributor itself or anyone acting on such Contributor's behalf. Contributions do not include additions to the Program which: (i) are separate modules of software distributed in conjunction with the Program under their own license agreement, and (ii) are not derivative works of the Program.\n\n\"Contributor\" means any person or entity that distributes the Program.\n\n\"Licensed Patents\" mean patent claims licensable by a Contributor which are necessarily infringed by the use or sale of its Contribution alone or when combined with the Program.\n\n\"Program\" means the Contributions distributed in accordance with this Agreement.\n\n\"Recipient\" means anyone who receives the Program under this Agreement, including all Contributors.\n\n2. GRANT OF RIGHTS\n\na) Subject to the terms of this Agreement, each Contributor hereby grants Recipient a non-exclusive, worldwide, royalty-free copyright license to reproduce, prepare derivative works of, publicly display, publicly perform, distribute and sublicense the Contribution of such Contributor, if any, and such derivative works, in source code and object code form.\n\nb) Subject to the terms of this Agreement, each Contributor hereby grants Recipient a non-exclusive, worldwide, royalty-free patent license under Licensed Patents to make, use, sell, offer to sell, import and otherwise transfer the Contribution of such Contributor, if any, in source code and object code form. This patent license shall apply to the combination of the Contribution and the Program if, at the time the Contribution is added by the Contributor, such addition of the Contribution causes such combination to be covered by the Licensed Patents. The patent license shall not apply to any other combinations which include the Contribution. No hardware per se is licensed hereunder.\n\nc) Recipient understands that although each Contributor grants the licenses to its Contributions set forth herein, no assurances are provided by any Contributor that the Program does not infringe the patent or other intellectual property rights of any other entity. Each Contributor disclaims any liability to Recipient for claims brought by any other entity based on infringement of intellectual property rights or otherwise. As a condition to exercising the rights and licenses granted hereunder, each Recipient hereby assumes sole responsibility to secure any other intellectual property rights needed, if any. For example, if a third party patent license is required to allow Recipient to distribute the Program, it is Recipient's responsibility to acquire that license before distributing the Program.\n\nd) Each Contributor represents that to its knowledge it has sufficient copyright rights in its Contribution, if any, to grant the copyright license set forth in this Agreement.\n\n3. REQUIREMENTS\n\nA Contributor may choose to distribute the Program in object code form under its own license agreement, provided that:\n\na) it complies with the terms and conditions of this Agreement; and\n\nb) its license agreement:\n\ni) effectively disclaims on behalf of all Contributors all warranties and conditions, express and implied, including warranties or conditions of title and non-infringement, and implied warranties or conditions of merchantability and fitness for a particular purpose;\n\nii) effectively excludes on behalf of all Contributors all liability for damages, including direct, indirect, special, incidental and consequential damages, such as lost profits;\n\niii) states that any provisions which differ from this Agreement are offered by that Contributor alone and not by any other party; and\n\niv) states that source code for the Program is available from such Contributor, and informs licensees how to obtain it in a reasonable manner on or through a medium customarily used for software exchange.\n\nWhen the Program is made available in source code form:\n\na) it must be made available under this Agreement; and\n\nb) a copy of this Agreement must be included with each copy of the Program.\n\nContributors may not remove or alter any copyright notices contained within the Program.\n\nEach Contributor must identify itself as the originator of its Contribution, if any, in a manner that reasonably allows subsequent Recipients to identify the originator of the Contribution.\n\n4. COMMERCIAL DISTRIBUTION\n\nCommercial distributors of software may accept certain responsibilities with respect to end users, business partners and the like. While this license is intended to facilitate the commercial use of the Program, the Contributor who includes the Program in a commercial product offering should do so in a manner which does not create potential liability for other Contributors. Therefore, if a Contributor includes the Program in a commercial product offering, such Contributor (\"Commercial Contributor\") hereby agrees to defend and indemnify every other Contributor (\"Indemnified Contributor\") against any losses, damages and costs (collectively \"Losses\") arising from claims, lawsuits and other legal actions brought by a third party against the Indemnified Contributor to the extent caused by the acts or omissions of such Commercial Contributor in connection with its distribution of the Program in a commercial product offering. The obligations in this section do not apply to any claims or Losses relating to any actual or alleged intellectual property infringement. In order to qualify, an Indemnified Contributor must: a) promptly notify the Commercial Contributor in writing of such claim, and b) allow the Commercial Contributor to control, and cooperate with the Commercial Contributor in, the defense and any related settlement negotiations. The Indemnified Contributor may participate in any such claim at its own expense.\n\nFor example, a Contributor might include the Program in a commercial product offering, Product X. That Contributor is then a Commercial Contributor. If that Commercial Contributor then makes performance claims, or offers warranties related to Product X, those performance claims and warranties are such Commercial Contributor's responsibility alone. Under this section, the Commercial Contributor would have to defend claims against the other Contributors related to those performance claims and warranties, and if a court requires any other Contributor to pay any damages as a result, the Commercial Contributor must pay those damages.\n\n5. NO WARRANTY\n\nEXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely responsible for determining the appropriateness of using and distributing the Program and assumes all risks associated with its exercise of rights under this Agreement , including but not limited to the risks and costs of program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and unavailability or interruption of operations.\n\n6. DISCLAIMER OF LIABILITY\n\nEXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.\n\n7. GENERAL\n\nIf any provision of this Agreement is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this Agreement, and without further action by the parties hereto, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.\n\nIf Recipient institutes patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Program itself (excluding combinations of the Program with other software or hardware) infringes such Recipient's patent(s), then such Recipient's rights granted under Section 2(b) shall terminate as of the date such litigation is filed.\n\nAll Recipient's rights under this Agreement shall terminate if it fails to comply with any of the material terms or conditions of this Agreement and does not cure such failure in a reasonable period of time after becoming aware of such noncompliance. If all Recipient's rights under this Agreement terminate, Recipient agrees to cease use and distribution of the Program as soon as reasonably practicable. However, Recipient's obligations under this Agreement and any licenses granted by Recipient relating to the Program shall continue and survive.\n\nEveryone is permitted to copy and distribute copies of this Agreement, but in order to avoid inconsistency the Agreement is copyrighted and may only be modified in the following manner. The Agreement Steward reserves the right to publish new versions (including revisions) of this Agreement from time to time. No one other than the Agreement Steward has the right to modify this Agreement. The Eclipse Foundation is the initial Agreement Steward. The Eclipse Foundation may assign the responsibility to serve as the Agreement Steward to a suitable separate entity. Each new version of the Agreement will be given a distinguishing version number. The Program (including Contributions) may always be distributed subject to the version of the Agreement under which it was received. In addition, after a new version of the Agreement is published, Contributor may elect to distribute the Program (including its Contributions) under the new version. Except as expressly stated in Sections 2(a) and 2(b) above, Recipient receives no rights or licenses to the intellectual property of any Contributor under this Agreement, whether expressly, by implication, estoppel or otherwise. All rights in the Program not expressly granted under this Agreement are reserved.\n\nThis Agreement is governed by the laws of the State of New York and the intellectual property laws of the United States of America. No party to this Agreement will bring a legal action under this Agreement more than one year after the cause of action arose. Each party waives its rights to a jury trial in any resulting litigation.";
    public static final String INTRODUCTION = "DrJava is a pedagogic programming environment for Java, intended to help students focus more on program design than on the features of a complicated development environment. It provides an Interactions window based on a \"read-eval-print loop\", which allows programmers to develop, test, and debug Java programs in an interactive, incremental fashion.\n\nHome Page: http://www.drjava.org\nPaper: http://drjava.sf.net/papers/drjava-paper.shtml";

    public AboutDialog(JFrame owner) {
        super(owner, "About DrJava", true);
        this.buildGUI(this.getContentPane());
        this.getRootPane().setDefaultButton(this._okButton);
        this.setSize(550, 400);
    }

    public void setVisible(boolean vis) {
        this._tabs.remove(0);
        AboutDialog.addTab(this._tabs, "About", AboutDialog.createCopyrightTab(), 0);
        this._tabs.setSelectedIndex(0);
        if (vis) {
            Utilities.setPopupLoc(this, this.getOwner());
        }
        super.setVisible(vis);
    }

    public void buildGUI(Container cp) {
        cp.setLayout(new BorderLayout());
        JLabel drjava = AboutDialog.createImageLabel(DRJAVA, 2);
        if (drjava != null) {
            drjava.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), drjava.getBorder()));
            drjava.setCursor(new Cursor(12));
            String url = "http://drjava.org/";
            drjava.setToolTipText("http://drjava.org/");
            drjava.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mouseClicked(MouseEvent e) {
                    try {
                        PlatformFactory.ONLY.openURL(new URL("http://drjava.org/"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JPanel djPanel = new JPanel(new GridLayout(1, 1));
            djPanel.add(drjava);
            djPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
            cp.add((Component)djPanel, "North");
        }
        AboutDialog.addTab(this._tabs, "About", AboutDialog.createCopyrightTab());
        LICENSE = AboutDialog.getLicense();
        if (LICENSE != null) {
            AboutDialog.addTab(this._tabs, "DrJava License", AboutDialog.createTextScroller(LICENSE));
        }
        AboutDialog.addTab(this._tabs, "DynamicJava License", AboutDialog.createTextScroller(DYADE_LICENSE));
        AboutDialog.addTab(this._tabs, "Eclipse License", AboutDialog.createTextScroller(ECLIPSE_LICENSE));
        AboutDialog.addTab(this._tabs, "System Properties", this.createSysPropTab());
        this._propertiesTabIndex = this._tabs.getTabCount() - 1;
        cp.add((Component)this.createBottomBar(), "South");
        cp.add((Component)this._tabs, "Center");
    }

    private JComponent createSysPropTab() {
        Properties props = System.getProperties();
        int size = props.size();
        Object[][] rowData = new String[size][2];
        int rowNum = 0;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            rowData[rowNum][0] = (String)entry.getKey();
            rowData[rowNum][1] = (String)entry.getValue();
            ++rowNum;
        }
        Arrays.sort(rowData, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return o1[0].compareTo(o2[0]);
            }
        });
        Object[] nvStrings = new String[]{"Name", "Value"};
        UneditableTableModel model = new UneditableTableModel(rowData, nvStrings);
        this._propertiesTable = new JTable(model);
        BorderlessScrollPane scroller = new BorderlessScrollPane(this._propertiesTable);
        AboutDialog.wrapBorder(scroller, new EmptyBorder(5, 0, 0, 0));
        JPanel propTab = new JPanel(new BorderLayout());
        propTab.add((Component)new JLabel("Current system properties:"), "North");
        propTab.add((Component)scroller, "Center");
        return propTab;
    }

    private static void addTab(JTabbedPane tabs, String title, JComponent tab) {
        AboutDialog.wrapBorder(tab, new EmptyBorder(5, 6, 6, 5));
        tabs.addTab(title, tab);
    }

    private static void addTab(JTabbedPane tabs, String title, JComponent tab, int i) {
        AboutDialog.wrapBorder(tab, new EmptyBorder(5, 6, 6, 5));
        tabs.insertTab(title, null, tab, "", i);
    }

    public static JComponent createCopyrightTab() {
        String customDrJavaJarVersionSuffix;
        JPanel panel = new JPanel(new BorderLayout());
        StringBuilder sb = new StringBuilder("DrJava Version : ");
        sb.append(Version.getVersionString());
        FileConfiguration config = DrJava.getConfig();
        if (config != null && (customDrJavaJarVersionSuffix = config.getSetting(OptionConstants.CUSTOM_DRJAVA_JAR_VERSION_SUFFIX)).length() > 0) {
            sb.append(" with ");
            sb.append(customDrJavaJarVersionSuffix);
        }
        sb.append("\nDrJava Build Time: ");
        sb.append(Version.getBuildTimeString());
        sb.append("\n\nDrJava Configuration File: ");
        sb.append(DrJava.getPropertiesFile().getAbsolutePath());
        sb.append("\n\nUsed memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        sb.append("\nFree memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().freeMemory()));
        sb.append("\nTotal memory: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().totalMemory()));
        sb.append("\nTotal memory can expand to: about ");
        sb.append(StringOps.memSizeToString(Runtime.getRuntime().maxMemory()));
        sb.append("\n\n");
        sb.append(COPYRIGHT);
        JScrollPane copy = AboutDialog.createTextScroller(sb.toString());
        AboutDialog.wrapBorder(copy, new EmptyBorder(0, 0, 5, 0));
        LogoList logos = new LogoList();
        logos.addLogo(AboutDialog.createBorderedLabel(AboutDialog.CSLOGO, new EmptyBorder(5, 5, 5, 5)), "http://compsci.rice.edu/");
        logos.addLogo(AboutDialog.createBorderedLabel(AboutDialog.SF, null), "http://sourceforge.net/projects/drjava/");
        logos.resizeLogos();
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new BoxLayout(logoPanel, 0));
        logoPanel.add(Box.createHorizontalGlue());
        for (JPanel l : logos) {
            logoPanel.add(l);
            l.setCursor(new Cursor(12));
            final String url = (String)l.getClientProperty("url");
            if (url != null) {
                l.setToolTipText(url);
                l.addMouseListener(new MouseListener(){

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                    }

                    public void mouseEntered(MouseEvent e) {
                    }

                    public void mouseExited(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                        try {
                            PlatformFactory.ONLY.openURL(new URL(url));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            logoPanel.add(Box.createHorizontalGlue());
        }
        panel.add((Component)logoPanel, "South");
        panel.add((Component)copy, "Center");
        return panel;
    }

    public static JPanel createBorderedLabel(ImageInfo info, EmptyBorder pad) {
        JLabel label = AboutDialog.createImageLabel(info, 0);
        if (label == null) {
            return null;
        }
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(true);
        panel.setBackground(info.color);
        panel.setBorder(pad);
        AboutDialog.wrapBorder(panel, new EtchedBorder());
        panel.add(label);
        return panel;
    }

    public static JLabel createImageLabel(ImageInfo info, int align) {
        ImageIcon icon = MainFrame.getIcon(info.name);
        if (icon == null) {
            return null;
        }
        JLabel label = new JLabel(icon, align);
        label.setOpaque(true);
        label.setBackground(info.color);
        return label;
    }

    public static JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCaretPosition(0);
        return textArea;
    }

    public static JScrollPane createTextScroller(String text) {
        return new BorderlessScrollPane(AboutDialog.createTextArea(text));
    }

    private JPanel createBottomBar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this._copyButton = new JButton(new AbstractAction("Copy System Properties"){

            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection contents = new StringSelection(DrJavaErrorWindow.getSystemAndDrJavaInfo());
                cb.setContents(contents, null);
            }
        });
        this._copyButton.setToolTipText("Copy information about your computer into the clipboard so it can be pasted.");
        this._okButton.addActionListener(this);
        buttonPanel.add(this._copyButton);
        buttonPanel.add(this._okButton);
        panel.add((Component)buttonPanel, "East");
        AboutDialog.wrapBorder(panel, new EmptyBorder(5, 5, 5, 5));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLicense() {
        block11: {
            if (initLicense) {
                return LICENSE;
            }
            try {
                InputStream is = AboutDialog.class.getResourceAsStream("/edu/rice/cs/LICENSE");
                if (is == null) break block11;
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                try {
                    StringBuilder sb = new StringBuilder();
                    String s = r.readLine();
                    while (s != null) {
                        int lastSig;
                        for (lastSig = s.length() - 1; lastSig >= 0 && Character.isWhitespace(s.charAt(lastSig)); --lastSig) {
                        }
                        if (lastSig < 0) {
                            sb.append("\n");
                        } else {
                            sb.append(s.substring(0, lastSig + 1));
                            sb.append('\n');
                        }
                        s = r.readLine();
                    }
                    LICENSE = sb.toString();
                    if ((LICENSE = LICENSE.trim()).length() == 0) {
                        LICENSE = null;
                    }
                }
                finally {
                    is.close();
                    r.close();
                }
            }
            catch (Exception e) {
                throw new UnexpectedException(e, StringOps.getStackTrace(e));
            }
        }
        initLicense = true;
        return LICENSE;
    }

    private static void wrapBorder(JComponent c, Border b) {
        c.setBorder(new CompoundBorder(b, c.getBorder()));
    }

    static {
        initLicense = false;
    }

    public static class ImageInfo {
        private final String name;
        private final Color color;

        public ImageInfo(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogoList
    extends LinkedList<JPanel>
    implements Serializable {
        private int width = Integer.MIN_VALUE;
        private int height = Integer.MIN_VALUE;

        private LogoList() {
        }

        private void addLogo(JPanel logo, String url) {
            if (logo != null) {
                Dimension d = logo.getMinimumSize();
                this.width = Math.max(this.width, d.width);
                this.height = Math.max(this.height, d.height);
                this.add(logo);
                if (url != null) {
                    logo.putClientProperty("url", url);
                }
            }
        }

        private void resizeLogos() {
            Dimension d = new Dimension(this.width, this.height);
            for (JPanel i : this) {
                i.setMinimumSize(d);
                i.setMaximumSize(d);
                i.setPreferredSize(d);
            }
        }
    }
}

