/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.platform;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.platform.DefaultPlatform;
import edu.rice.cs.drjava.platform.WindowsRegistry;
import edu.rice.cs.util.BalancingStreamTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.jar.JarFile;

class WindowsPlatform
extends DefaultPlatform {
    public static WindowsPlatform ONLY = new WindowsPlatform();
    private static final String DRJAVA_PROJECT_PROGID = "DrJava.Project";
    private static final String DRJAVA_EXTPROCESS_PROGID = "DrJava.ExtProcess";
    private static final String DRJAVA_JAVA_PROGID = "DrJava.Java";

    protected WindowsPlatform() {
    }

    public boolean isWindowsPlatform() {
        return true;
    }

    public boolean openURL(URL address) {
        if (super.openURL(address)) {
            return true;
        }
        try {
            String addressString = address.toString();
            if (addressString.startsWith("file:/")) {
                String suffix = addressString.substring("file:/".length(), addressString.length());
                addressString = "file://" + suffix;
            }
            Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", addressString});
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public boolean canRegisterFileExtensions() {
        try {
            return this.getDrJavaFile().getName().endsWith(".exe");
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean registerDrJavaFileExtensions() {
        boolean retval = this.registerFileExtension(".drjava", DRJAVA_PROJECT_PROGID, "DrJava project file", "text", "text/plain");
        return retval &= this.registerFileExtension(".djapp", DRJAVA_EXTPROCESS_PROGID, "DrJava addon file", "program", "multipart/mixed");
    }

    public boolean unregisterDrJavaFileExtensions() {
        boolean retval = this.unregisterFileExtension(".drjava", DRJAVA_PROJECT_PROGID);
        return retval &= this.unregisterFileExtension(".djapp", DRJAVA_EXTPROCESS_PROGID);
    }

    public boolean areDrJavaFileExtensionsRegistered() {
        return this.isFileExtensionRegistered(".drjava", DRJAVA_PROJECT_PROGID) && this.isFileExtensionRegistered(".djapp", DRJAVA_EXTPROCESS_PROGID);
    }

    public boolean registerJavaFileExtension() {
        return this.registerFileExtension(".java", DRJAVA_JAVA_PROGID, "Java source file", "text", "text/plain");
    }

    public boolean unregisterJavaFileExtension() {
        return this.unregisterFileExtension(".java", DRJAVA_JAVA_PROGID);
    }

    public boolean isJavaFileExtensionRegistered() {
        return this.isFileExtensionRegistered(".java", DRJAVA_JAVA_PROGID);
    }

    private boolean isFileExtensionRegistered(String extension, String progid) {
        try {
            String oldDefault = WindowsRegistry.getKey(Integer.MIN_VALUE, extension, "");
            if (oldDefault == null || !progid.equals(oldDefault)) {
                return false;
            }
            String cmdLine = this.getCommandLine() + " \"%1\" %*";
            String oldCmdLine = WindowsRegistry.getKey(Integer.MIN_VALUE, progid + "\\shell\\open\\command", "");
            return oldCmdLine != null && cmdLine.equals(oldCmdLine);
        }
        catch (WindowsRegistry.RegistryException re) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean registerFileExtension(String extension, String progid, String fileDesc, String perceived, String mime) {
        try {
            String cmdLine = this.getCommandLine();
            try {
                String oldDefault = WindowsRegistry.getKey(Integer.MIN_VALUE, extension, "");
                if (oldDefault != null && !progid.equals(oldDefault)) {
                    WindowsRegistry.setKey(Integer.MIN_VALUE, extension + "\\OpenWithProgids", oldDefault, "");
                    WindowsRegistry.setKey(Integer.MIN_VALUE, extension + "\\OpenWithList", oldDefault, "");
                }
            }
            catch (WindowsRegistry.RegistryException re) {
                // empty catch block
            }
            WindowsRegistry.setKey(Integer.MIN_VALUE, extension, "", progid);
            WindowsRegistry.setKey(Integer.MIN_VALUE, extension, "PerceivedType", perceived);
            WindowsRegistry.setKey(Integer.MIN_VALUE, extension, "Content Type", mime);
            WindowsRegistry.setKey(Integer.MIN_VALUE, extension + "\\OpenWithProgids", progid, "");
            WindowsRegistry.setKey(Integer.MIN_VALUE, extension + "\\OpenWithList", progid, "");
            WindowsRegistry.setKey(Integer.MIN_VALUE, progid, "", fileDesc);
            WindowsRegistry.setKey(Integer.MIN_VALUE, progid + "\\shell\\open", "FriendlyAppName", "DrJava");
            WindowsRegistry.setKey(Integer.MIN_VALUE, progid + "\\shell\\open\\command", "", cmdLine + " \"%1\" %*");
            return true;
        }
        catch (WindowsRegistry.RegistryException re) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean unregisterFileExtension(String extension, String progid) {
        boolean otherProgidsLeft = false;
        try {
            WindowsRegistry.QueryInfoResult qir;
            int handle;
            try {
                handle = WindowsRegistry.openKey(Integer.MIN_VALUE, extension + "\\OpenWithProgids", 983103);
                try {
                    WindowsRegistry.deleteValue(handle, progid);
                }
                catch (WindowsRegistry.RegistryException re) {
                    // empty catch block
                }
                qir = WindowsRegistry.queryInfoKey(handle);
                otherProgidsLeft |= qir.valueCount > 0;
                otherProgidsLeft |= qir.subkeyCount > 0;
                WindowsRegistry.flushKey(handle);
                WindowsRegistry.closeKey(handle);
                handle = WindowsRegistry.openKey(Integer.MIN_VALUE, extension + "\\OpenWithList", 983103);
                try {
                    WindowsRegistry.deleteValue(handle, progid);
                }
                catch (WindowsRegistry.RegistryException re) {
                    // empty catch block
                }
                qir = WindowsRegistry.queryInfoKey(handle);
                otherProgidsLeft |= qir.valueCount > 0;
                boolean bl = qir.subkeyCount > 0;
                WindowsRegistry.flushKey(handle);
                WindowsRegistry.closeKey(handle);
                if (!(otherProgidsLeft |= bl)) {
                    WindowsRegistry.delKey(Integer.MIN_VALUE, extension + "\\OpenWithProgids");
                    WindowsRegistry.delKey(Integer.MIN_VALUE, extension);
                }
                WindowsRegistry.delKey(Integer.MIN_VALUE, progid + "\\shell\\open");
                WindowsRegistry.delKey(Integer.MIN_VALUE, progid);
            }
            catch (WindowsRegistry.RegistryException re) {
                // empty catch block
            }
            File drjavaFile = null;
            String ourCmdLine = null;
            try {
                drjavaFile = this.getDrJavaFile();
                ourCmdLine = this.getCommandLine() + " \"%1\" %*";
            }
            catch (IOException ioe) {
                return false;
            }
            try {
                handle = WindowsRegistry.openKey(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension, 983103);
                try {
                    String s = WindowsRegistry.queryValue(handle, "Application");
                    if (s != null && s.equals(drjavaFile.getName())) {
                        WindowsRegistry.deleteValue(handle, progid);
                    }
                }
                catch (WindowsRegistry.RegistryException re) {
                    // empty catch block
                }
                WindowsRegistry.flushKey(handle);
                WindowsRegistry.closeKey(handle);
            }
            catch (WindowsRegistry.RegistryException re) {
                // empty catch block
            }
            otherProgidsLeft = false;
            try {
                handle = WindowsRegistry.openKey(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\OpenWithProgids", 983103);
                try {
                    WindowsRegistry.deleteValue(handle, progid);
                }
                catch (WindowsRegistry.RegistryException re) {
                    // empty catch block
                }
                qir = WindowsRegistry.queryInfoKey(handle);
                otherProgidsLeft |= qir.valueCount > 0;
                boolean bl = qir.subkeyCount > 0;
                WindowsRegistry.flushKey(handle);
                WindowsRegistry.closeKey(handle);
                if (!(otherProgidsLeft |= bl)) {
                    WindowsRegistry.delKey(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\OpenWithProgids");
                }
            }
            catch (WindowsRegistry.RegistryException re) {
                // empty catch block
            }
            String mruList = "";
            try {
                handle = WindowsRegistry.openKey(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension + "\\OpenWithList", 983103);
                try {
                    String s = WindowsRegistry.queryValue(handle, "MRUList");
                    if (s != null) {
                        mruList = s;
                    }
                }
                catch (WindowsRegistry.RegistryException re) {
                    // empty catch block
                }
                String newMRUList = "";
                for (int i = 0; i < mruList.length(); ++i) {
                    boolean keep;
                    String letter;
                    block39: {
                        letter = mruList.substring(i, i + 1);
                        keep = true;
                        try {
                            String cmdLine;
                            String value = WindowsRegistry.queryValue(handle, letter);
                            if (value == null) break block39;
                            try {
                                cmdLine = WindowsRegistry.getKey(-2147483646, "SOFTWARE\\Classes\\Applications\\" + value + "\\shell\\open\\command", "");
                                if (cmdLine != null && cmdLine.equals(ourCmdLine)) {
                                    keep = false;
                                    WindowsRegistry.delKey(-2147483646, "SOFTWARE\\Classes\\Applications\\" + value + "\\shell\\open\\command");
                                    WindowsRegistry.delKey(-2147483646, "SOFTWARE\\Classes\\Applications\\" + value + "\\shell\\open");
                                    WindowsRegistry.delKey(-2147483646, "SOFTWARE\\Classes\\Applications\\" + value + "\\shell");
                                    WindowsRegistry.delKey(-2147483646, "SOFTWARE\\Classes\\Applications\\" + value);
                                }
                            }
                            catch (WindowsRegistry.RegistryException re) {
                                // empty catch block
                            }
                            try {
                                cmdLine = WindowsRegistry.getKey(-2147483647, "Software\\Classes\\Applications\\" + value + "\\shell\\open\\command", "");
                                if (cmdLine != null && cmdLine.equals(ourCmdLine)) {
                                    keep = false;
                                    WindowsRegistry.delKey(-2147483647, "Software\\Classes\\Applications\\" + value + "\\shell\\open\\command");
                                    WindowsRegistry.delKey(-2147483647, "Software\\Classes\\Applications\\" + value + "\\shell\\open");
                                    WindowsRegistry.delKey(-2147483647, "Software\\Classes\\Applications\\" + value + "\\shell");
                                    WindowsRegistry.delKey(-2147483647, "Software\\Classes\\Applications\\" + value);
                                }
                            }
                            catch (WindowsRegistry.RegistryException re) {
                                // empty catch block
                            }
                            if (!keep) {
                                try {
                                    WindowsRegistry.deleteValue(handle, letter);
                                }
                                catch (WindowsRegistry.RegistryException re) {}
                            }
                        }
                        catch (WindowsRegistry.RegistryException re) {
                            // empty catch block
                        }
                    }
                    if (!keep) continue;
                    newMRUList = newMRUList + letter;
                }
                if (!mruList.equals(newMRUList)) {
                    WindowsRegistry.setValue(handle, "MRUList", newMRUList);
                }
                WindowsRegistry.flushKey(handle);
                WindowsRegistry.closeKey(handle);
            }
            catch (WindowsRegistry.RegistryException re) {
                // empty catch block
            }
            return true;
        }
        catch (WindowsRegistry.RegistryException re) {
            return false;
        }
    }

    private File getDrJavaFile() throws IOException {
        String[] cps = System.getProperty("java.class.path").split("\\;", -1);
        File found = null;
        for (String cp : cps) {
            try {
                JarFile jf;
                File f = new File(cp);
                if (!f.exists()) continue;
                if (f.isDirectory()) {
                    File cf = new File(f, DrJava.class.getName().replace('.', File.separatorChar) + ".class");
                    if (!cf.exists() || !cf.isFile()) continue;
                    found = f;
                    break;
                }
                if (!f.isFile() || (jf = new JarFile(f)).getJarEntry(DrJava.class.getName().replace('.', '/') + ".class") == null) continue;
                found = f;
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (found == null) {
            throw new IOException("DrJava file not found");
        }
        return found;
    }

    private String getCommandLine() throws WindowsRegistry.RegistryException, IOException {
        File drjavaFile = this.getDrJavaFile();
        String cmdLine = drjavaFile.getAbsolutePath();
        if (!drjavaFile.getAbsolutePath().endsWith(".exe")) {
            String jarProgid = WindowsRegistry.getKey(Integer.MIN_VALUE, ".jar", "");
            String jarLine = WindowsRegistry.getKey(Integer.MIN_VALUE, jarProgid + "\\shell\\open\\command", "");
            BalancingStreamTokenizer tok = new BalancingStreamTokenizer(new StringReader(jarLine));
            tok.wordRange(0, 255);
            tok.whitespaceRange(32, 32);
            tok.addQuotes("\"", "\"");
            String jarCommand = tok.getNextToken();
            cmdLine = jarCommand + " -jar " + drjavaFile.getAbsolutePath();
        }
        return cmdLine;
    }
}

