/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class ClassAndInterfaceFinder {
    private StreamTokenizer tokenizer;

    public ClassAndInterfaceFinder(Reader r) {
        this.initialize(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassAndInterfaceFinder(File f) {
        Reader r = null;
        try {
            try {
                r = new FileReader(f);
            }
            catch (FileNotFoundException e) {
                r = new StringReader("");
            }
            this.initialize(r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void initialize(Reader r) {
        this.tokenizer = new StreamTokenizer(r);
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.slashStarComments(true);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(46, 46);
    }

    public String getClassOrInterfaceName() {
        return this.getName(true);
    }

    public String getClassName() {
        return this.getName(false);
    }

    String getName(boolean interfaceOK) {
        try {
            int tokenType;
            String package_name = "";
            while (!this.isClassOrInterfaceWord(tokenType = this.tokenizer.nextToken(), interfaceOK) && !this.isPackageWord(tokenType)) {
            }
            if (ClassAndInterfaceFinder.isEOF(tokenType)) {
                return "";
            }
            String keyword = this.tokenizer.sval;
            while (!ClassAndInterfaceFinder.isWord(tokenType = this.tokenizer.nextToken())) {
            }
            if (ClassAndInterfaceFinder.isEOF(tokenType)) {
                return "";
            }
            if (keyword.equals("class")) {
                return this.tokenizer.sval;
            }
            if (interfaceOK && keyword.equals("interface")) {
                return this.tokenizer.sval;
            }
            if (keyword.equals("package")) {
                package_name = this.tokenizer.sval;
            }
            while (!this.isClassOrInterfaceWord(tokenType = this.tokenizer.nextToken(), interfaceOK)) {
            }
            while (!ClassAndInterfaceFinder.isWord(tokenType = this.tokenizer.nextToken())) {
            }
            if (tokenType == -1) {
                return "";
            }
            if (package_name.length() > 0) {
                return package_name + "." + this.tokenizer.sval;
            }
            return this.tokenizer.sval;
        }
        catch (IOException e) {
            return "";
        }
    }

    private static boolean isWord(int tt) {
        return tt == -3 || ClassAndInterfaceFinder.isEOF(tt);
    }

    private static boolean isEOF(int tt) {
        return tt == -1;
    }

    private boolean isClassOrInterfaceWord(int tt, boolean interfaceOK) {
        return ClassAndInterfaceFinder.isEOF(tt) || tt == -3 && this.tokenizer.sval.equals("class") || tt == -3 && interfaceOK && this.tokenizer.sval.equals("interface");
    }

    private boolean isPackageWord(int tt) {
        return tt == -3 && this.tokenizer.sval.equals("package") || tt == -1;
    }
}

