/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.BrowserDocumentRegion;
import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserHistoryManager
extends EventNotifier<RegionManagerListener<BrowserDocumentRegion>> {
    public static final int DIFF_THRESHOLD = 5;
    private volatile Stack<BrowserDocumentRegion> _pastRegions = new Stack();
    private volatile Stack<BrowserDocumentRegion> _futureRegions = new Stack();
    private volatile int _maxSize;

    public BrowserHistoryManager(int size) {
        this._maxSize = size;
    }

    public BrowserHistoryManager() {
        this(0);
    }

    public void addBrowserRegion(final BrowserDocumentRegion r, GlobalEventNotifier notifier) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        BrowserDocumentRegion current = this.getCurrentRegion();
        if (current != null && BrowserHistoryManager.similarRegions(current, r)) {
            current.update(r);
        } else {
            this._pastRegions.push(r);
            r.getDocument().addBrowserRegion(r);
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BrowserHistoryManager.this._lock.startRead();
                    try {
                        for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                            l.regionAdded(r);
                        }
                    }
                    finally {
                        BrowserHistoryManager.this._lock.endRead();
                    }
                }
            });
            this.shrinkManager();
        }
        notifier.browserChanged();
    }

    public void addBrowserRegionBefore(final BrowserDocumentRegion r, GlobalEventNotifier notifier) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        BrowserDocumentRegion current = this.getCurrentRegion();
        if (current != null && BrowserHistoryManager.similarRegions(current, r)) {
            current.update(r);
        } else {
            if (this._pastRegions.size() == 0) {
                this._pastRegions.push(r);
            } else {
                this._futureRegions.push(this._pastRegions.pop());
                this._pastRegions.push(r);
            }
            r.getDocument().addBrowserRegion(r);
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BrowserHistoryManager.this._lock.startRead();
                    try {
                        for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                            l.regionAdded(r);
                        }
                    }
                    finally {
                        BrowserHistoryManager.this._lock.endRead();
                    }
                }
            });
            this.shrinkManager();
        }
        notifier.browserChanged();
    }

    private void shrinkManager() {
        if (this._maxSize > 0) {
            int size = this._pastRegions.size() + this._futureRegions.size();
            int diff = size - this._maxSize;
            for (int i = 0; i < diff; ++i) {
                this.remove((BrowserDocumentRegion)(this._pastRegions.size() > this._futureRegions.size() ? this._pastRegions : this._futureRegions).get(0));
            }
        }
    }

    public void remove(final BrowserDocumentRegion r) {
        OpenDefinitionsDocument doc = r.getDocument();
        if (!this._pastRegions.remove(r)) {
            this._futureRegions.remove(r);
        }
        doc.removeBrowserRegion(r);
        Utilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowserHistoryManager.this._lock.startRead();
                try {
                    for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                        l.regionRemoved(r);
                    }
                }
                finally {
                    BrowserHistoryManager.this._lock.endRead();
                }
            }
        });
    }

    public SortedSet<BrowserDocumentRegion> getRegions() {
        TreeSet<BrowserDocumentRegion> ts = new TreeSet<BrowserDocumentRegion>(this._pastRegions);
        ts.addAll(this._futureRegions);
        return ts;
    }

    public void clearBrowserRegions() {
        while (this._pastRegions.size() + this._futureRegions.size() > 0) {
            this.remove((BrowserDocumentRegion)(this._pastRegions.size() > this._futureRegions.size() ? this._pastRegions : this._futureRegions).get(0));
        }
    }

    public BrowserDocumentRegion getCurrentRegion() {
        if (this._pastRegions.isEmpty()) {
            return null;
        }
        return this._pastRegions.peek();
    }

    public boolean isCurrentRegionFirst() {
        return this._pastRegions.size() < 2;
    }

    public boolean isCurrentRegionLast() {
        return this._futureRegions.size() < 1;
    }

    public BrowserDocumentRegion nextCurrentRegion(GlobalEventNotifier notifier) {
        if (this.isCurrentRegionLast()) {
            return null;
        }
        this._pastRegions.push(this._futureRegions.pop());
        notifier.browserChanged();
        return this._pastRegions.peek();
    }

    public BrowserDocumentRegion prevCurrentRegion(GlobalEventNotifier notifier) {
        if (this.isCurrentRegionFirst()) {
            return null;
        }
        this._futureRegions.push(this._pastRegions.pop());
        notifier.browserChanged();
        return this._pastRegions.peek();
    }

    public void setMaximumSize(int size) {
        this._maxSize = size;
        this.shrinkManager();
    }

    public int getMaximumSize() {
        return this._maxSize;
    }

    public void changeRegion(final BrowserDocumentRegion region, Lambda<BrowserDocumentRegion, Object> cmd) {
        cmd.value(region);
        Utilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowserHistoryManager.this._lock.startRead();
                try {
                    for (RegionManagerListener l : BrowserHistoryManager.this._listeners) {
                        l.regionChanged(region);
                    }
                }
                finally {
                    BrowserHistoryManager.this._lock.endRead();
                }
            }
        });
    }

    public static boolean similarRegions(BrowserDocumentRegion r1, BrowserDocumentRegion r2) {
        int l2;
        OpenDefinitionsDocument d = r1.getDocument();
        if (d != r2.getDocument()) {
            return false;
        }
        int l1 = d.getLineOfOffset(r1.getStartOffset());
        return Math.abs(l1 - (l2 = d.getLineOfOffset(r2.getStartOffset()))) <= 5;
    }

    public String toString() {
        ArrayList<BrowserDocumentRegion> future = new ArrayList<BrowserDocumentRegion>(this._futureRegions);
        Collections.reverse(future);
        return "Past: " + this._pastRegions.toString() + ", Future: " + future.toString();
    }
}

