/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.lambda.Lambda;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DrJavaProperty
implements Cloneable {
    public volatile boolean DEACTIVATED_DUE_TO_ERROR = false;
    protected String _name;
    protected String _value = "--uninitialized--";
    protected boolean _isCurrent = false;
    protected String _help = "Help unavailable.";
    protected HashMap<String, String> _attributes = new HashMap();
    protected Set<DrJavaProperty> _listening = new HashSet<DrJavaProperty>();

    public DrJavaProperty(String name, String help) {
        if (name == null) {
            throw new IllegalArgumentException("DrJavaProperty name is null");
        }
        this._name = name;
        if (help != null) {
            this._help = help;
        }
        this.resetAttributes();
    }

    public DrJavaProperty(String name, String value, String help) {
        this(name, help);
        if (value == null) {
            throw new IllegalArgumentException("DrJavaProperty value is null");
        }
        if (help != null) {
            this._help = help;
        }
        this._value = value;
        this._isCurrent = true;
    }

    public String getName() {
        return this._name;
    }

    public String getCurrent(PropertyMaps pm) {
        if (!this.isCurrent()) {
            this.update(pm);
            if (this._value == null) {
                throw new IllegalArgumentException("DrJavaProperty value is null");
            }
            this._isCurrent = true;
        }
        return this._value;
    }

    public String getLazy(PropertyMaps pm) {
        if (this._value == null) {
            throw new IllegalArgumentException("DrJavaProperty value is null");
        }
        return this._value;
    }

    public abstract void update(PropertyMaps var1);

    public void resetAttributes() {
        this._attributes.clear();
    }

    public void setAttribute(String key, String value) {
        if (!this._attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute " + key + " not known to property " + this._name);
        }
        this._attributes.put(key, value);
    }

    public void setAttributes(HashMap<String, String> attrs, Lambda<String, String> replaceLambda) {
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            this.setAttribute(e.getKey(), replaceLambda.value(e.getValue()));
        }
    }

    public String getAttribute(String key) {
        if (!this._attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute " + key + " not known to property " + this._name);
        }
        return this._attributes.get(key);
    }

    public String toString() {
        return this._value;
    }

    public String getHelp() {
        return this._help;
    }

    public boolean isCurrent() {
        return this._isCurrent;
    }

    public void invalidate() {
        this._invalidate();
        this.invalidateOthers(new HashSet<DrJavaProperty>());
    }

    protected void _invalidate() {
        this._isCurrent = false;
    }

    public DrJavaProperty listenToInvalidatesOf(DrJavaProperty other) {
        if (other == this) {
            this.DEACTIVATED_DUE_TO_ERROR = true;
            IllegalArgumentException e = new IllegalArgumentException("Property cannot listen for invalidation of itself. Variables for external processes will not function correctly anymore. This is a SERIOUS programming error. Please notify the DrJava team.");
            DrJavaErrorHandler.record(e);
            throw e;
        }
        other._listening.add(this);
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DrJavaProperty o = (DrJavaProperty)other;
        return this._name.equals(o._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    protected void invalidateOthers(Set<DrJavaProperty> alreadyVisited) {
        if (this.DEACTIVATED_DUE_TO_ERROR) {
            return;
        }
        if (alreadyVisited.contains(this)) {
            Iterator<DrJavaProperty> it = alreadyVisited.iterator();
            StringBuilder sb = new StringBuilder("Invalidating ");
            sb.append(this.getName());
            sb.append(" after already having invalidated ");
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(it.next().getName());
            }
            sb.append(". Variables for external processes will not function correctly anymore. This is a SERIOUS programming error. Please notify the DrJava team.");
            this.DEACTIVATED_DUE_TO_ERROR = true;
            InfiniteLoopException e = new InfiniteLoopException(sb.toString());
            DrJavaErrorHandler.record(e);
            throw e;
        }
        alreadyVisited.add(this);
        for (DrJavaProperty prop : this._listening) {
            prop._invalidate();
            prop.invalidateOthers(alreadyVisited);
        }
    }

    public static class InfiniteLoopException
    extends RuntimeException {
        public InfiniteLoopException(String s) {
            super(s);
        }
    }
}

