/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.record;

import edu.rice.cs.cunit.SyncPointBuffer;
import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;

public class CompactSynchronizedBlockStrategy
implements IInstrumentationStrategy {
    public void instrument(ClassFile cf) {
        if (!CompactSynchronizedBlockStrategy.isClassInstrumentable(cf.getThisClassName())) {
            return;
        }
        ConstantPool cp = cf.getConstantPool();
        ReferenceInstruction addCallInstr = new ReferenceInstruction(-72, 0);
        ReferenceInstruction loadMonitorEnterCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction loadMonitorExitCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction getThreadIDInstr = new ReferenceInstruction(-76, 0);
        ReferenceInstruction currentThreadCallInstr = new ReferenceInstruction(-72, 0);
        int addCallIndex = 0;
        int monitorEnterCodeIndex = 0;
        int monitorExitCodeIndex = 0;
        int threadIDIndex = 0;
        int currentThreadCallIndex = 0;
        for (MethodInfo mi : cf.getMethods()) {
            boolean result;
            if ((mi.getAccessFlags() & 0x500) != 0) continue;
            boolean changed = false;
            InstructionList il = new InstructionList(mi.getCodeAttributeInfo().getCode());
            while (il.findOpcode((byte)-62)) {
                changed = true;
                if (addCallIndex == 0) {
                    addCallIndex = cf.addMethodToConstantPool("edu/rice/cs/cunit/SyncPointBuffer", "compactAdd", "(JJ)V");
                    addCallInstr.setReference(addCallIndex);
                    monitorEnterCodeIndex = cf.addLongToConstantPool(SyncPointBuffer.SP.MONITORENTER.intValue());
                    loadMonitorEnterCodeIndexInstr.setReference(monitorEnterCodeIndex);
                    threadIDIndex = cf.addField("java/lang/Thread", "$$$threadID$$$", "J", false, (short)0);
                    getThreadIDInstr.setReference(threadIDIndex);
                    currentThreadCallIndex = cf.addMethodToConstantPool("java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
                    currentThreadCallInstr.setReference(currentThreadCallIndex);
                }
                il.advanceIndex();
                il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(currentThreadCallInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(loadMonitorEnterCodeIndexInstr, mi.getCodeAttributeInfo());
                result = il.advanceIndex(4);
                assert (result);
            }
            il.setIndex(0);
            while (il.findOpcode((byte)-61)) {
                changed = true;
                if (monitorExitCodeIndex == 0) {
                    monitorExitCodeIndex = cf.addLongToConstantPool(SyncPointBuffer.SP.MONITOREXIT.intValue());
                    loadMonitorExitCodeIndexInstr.setReference(monitorExitCodeIndex);
                }
                il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(currentThreadCallInstr, mi.getCodeAttributeInfo());
                il.insertBeforeInstr(loadMonitorExitCodeIndexInstr, mi.getCodeAttributeInfo());
                result = il.advanceIndex(4);
                assert (result);
                if (il.advanceIndex()) continue;
                break;
            }
            if (!changed) continue;
            mi.getCodeAttributeInfo().setCode(il.getCode());
            CodeAttributeInfo.CodeProperties cProps = mi.getCodeAttributeInfo().getProperties();
            cProps.maxStack += 4;
            mi.getCodeAttributeInfo().setProperties(cProps.maxStack, cProps.maxLocals);
        }
    }

    public static boolean isClassInstrumentable(String className) {
        return ClassFileTools.classNameMatches(className, "***", "!java.lang.ClassLoader", "!java.lang.ThreadGroup", "!java.lang.ref.***", "!java.lang.ref.Reference", "!java.lang.ref.ReferenceQueue", "!java.lang.ref.ReferenceQueue\\$Lock", "!java.security.Permission", "!java.util.AbstractCollection", "!java.util.AbstractMap", "!java.util.Vector", "!sun.reflect.[n-zN-Z]*");
    }

    public void done() {
    }
}

