/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckMethodVisitor;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;

public class MarkerInlineStrategy
implements IInstrumentationStrategy {
    private final GenericInstruction _monitorEnter = new GenericInstruction(-62);
    private final GenericInstruction _monitorExit = new GenericInstruction(-61);
    private final GenericInstruction _iconst_1 = new GenericInstruction(4);
    private final ReferenceInstruction _getOldThreadFieldInstr = new ReferenceInstruction(-76, 0);
    private final ReferenceInstruction _putOldThreadFieldInstr = new ReferenceInstruction(-75, 0);
    private final ReferenceInstruction _invokeCurrentThreadInstr = new ReferenceInstruction(-72, 0);
    private boolean _addNames;

    public void instrument(ClassFile cf) {
        this._addNames = true;
        for (MethodInfo mi : cf.getMethods()) {
            if ((mi.getAccessFlags() & 0x500) != 0) continue;
            boolean changed = false;
            int stackIncrease = 0;
            InstructionList il = new InstructionList(mi.getCodeAttributeInfo().getCode());
            do {
                boolean ret;
                ReferenceInstruction ri;
                MethodPoolInfo ref;
                if (il.getOpcode() != -72 || !(ref = cf.getConstantPoolItem((ri = (ReferenceInstruction)il.getInstr()).getReference()).execute(CheckMethodVisitor.singleton(), null)).getClassInfo().getName().toString().equals("edu/rice/cs/cunit/SyncPointBuffer")) continue;
                if (ref.getNameAndType().getName().toString().equals("monitorEnter") && ref.getNameAndType().getDescriptor().toString().equals("(Ljava/lang/Object;)V")) {
                    il.insertInstr(this._monitorEnter, mi.getCodeAttributeInfo());
                    ret = il.advanceIndex();
                    assert (ret);
                    il.deleteInstr(mi.getCodeAttributeInfo());
                    ret = il.rewindIndex();
                    assert (ret);
                    changed = true;
                    continue;
                }
                if (ref.getNameAndType().getName().toString().equals("monitorExit") && ref.getNameAndType().getDescriptor().toString().equals("(Ljava/lang/Object;)V")) {
                    il.insertInstr(this._monitorExit, mi.getCodeAttributeInfo());
                    ret = il.advanceIndex();
                    assert (ret);
                    il.deleteInstr(mi.getCodeAttributeInfo());
                    ret = il.rewindIndex();
                    assert (ret);
                    changed = true;
                    continue;
                }
                if (ref.getNameAndType().getName().toString().equals("isOldThread") && ref.getNameAndType().getDescriptor().toString().equals("()Z")) {
                    this.addNamesIfNecessary(cf);
                    il.insertInstr(this._getOldThreadFieldInstr, mi.getCodeAttributeInfo());
                    il.insertInstr(this._invokeCurrentThreadInstr, mi.getCodeAttributeInfo());
                    ret = il.advanceIndex(2);
                    assert (ret);
                    il.deleteInstr(mi.getCodeAttributeInfo());
                    ret = il.rewindIndex();
                    assert (ret);
                    changed = true;
                    stackIncrease = Math.max(stackIncrease, 1);
                    continue;
                }
                if (!ref.getNameAndType().getName().toString().equals("setOldThread") || !ref.getNameAndType().getDescriptor().toString().equals("()V")) continue;
                this.addNamesIfNecessary(cf);
                il.insertInstr(this._putOldThreadFieldInstr, mi.getCodeAttributeInfo());
                il.insertInstr(this._iconst_1, mi.getCodeAttributeInfo());
                il.insertInstr(this._invokeCurrentThreadInstr, mi.getCodeAttributeInfo());
                ret = il.advanceIndex(3);
                assert (ret);
                il.deleteInstr(mi.getCodeAttributeInfo());
                ret = il.rewindIndex();
                assert (ret);
                changed = true;
                stackIncrease = Math.max(stackIncrease, 2);
            } while (il.advanceIndex());
            if (!changed) continue;
            mi.getCodeAttributeInfo().setCode(il.getCode());
            CodeAttributeInfo.CodeProperties cProps = mi.getCodeAttributeInfo().getProperties();
            cProps.maxStack += stackIncrease;
            mi.getCodeAttributeInfo().setProperties(cProps.maxStack, cProps.maxLocals);
        }
    }

    private void addNamesIfNecessary(ClassFile cf) {
        if (this._addNames) {
            this._addNames = false;
            int oldThreadFieldIndex = cf.addField("java/lang/Thread", "$$$oldThread$$$", "Z", false, (short)0);
            this._getOldThreadFieldInstr.setReference(oldThreadFieldIndex);
            this._putOldThreadFieldInstr.setReference(oldThreadFieldIndex);
            int currentThreadMethodIndex = cf.addMethodToConstantPool("java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
            this._invokeCurrentThreadInstr.setReference(currentThreadMethodIndex);
        }
    }

    public void done() {
    }
}

