/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.concJUnit;

import edu.rice.cs.cunit.concJUnit.LuckyError;
import edu.rice.cs.cunit.concJUnit.MultithreadedTestError;
import edu.rice.cs.cunit.concJUnit.NoJoinError;
import edu.rice.cs.cunit.concJUnit.TestThreadGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import junit.framework.TestCase;
import org.junit.runners.model.Statement;

public class RunInThreadGroup
extends Statement {
    private Statement fNext;
    private Method fMethod;
    private boolean fCheckJoin = true;
    private boolean fCheckLucky = true;

    public RunInThreadGroup(Statement next, Method method) {
        this.fNext = next;
        this.fMethod = method;
    }

    public RunInThreadGroup(Statement next, Method method, boolean checkJoin, boolean checkLucky) {
        this.fNext = next;
        this.fMethod = method;
        this.fCheckJoin = checkJoin;
        this.fCheckLucky = checkLucky;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        block29: {
            String prevSunHandler = System.getProperty("sun.awt.exception.handler");
            try {
                final TestThreadGroup tg = new TestThreadGroup();
                TestThreadGroup.setCurrentThreadGroup(tg);
                System.setProperty("sun.awt.exception.handler", TestThreadGroup.AwtHandler.class.getName());
                Thread t = new Thread(tg, new Runnable(){

                    public void run() {
                        Throwable exception = null;
                        try {
                            RunInThreadGroup.this.fNext.evaluate();
                        }
                        catch (InvocationTargetException ite) {
                            exception = ite.getTargetException();
                        }
                        catch (Throwable running) {
                            exception = running;
                        }
                        if (exception != null) {
                            throw new TestCase.WrappedException(exception);
                        }
                        tg.notifyEvent();
                    }
                }, "Concutest-JUnit-" + (this.fMethod.getName() != null ? this.fMethod.getName() : "test"));
                t.setDaemon(false);
                t.start();
                try {
                    tg.waitForEvent();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        throw new MultithreadedTestError("After the test had finished, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e1) {
                        throw new MultithreadedTestError("After the test had been interrupted, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                if (tg.getUncaughtThread() != null) {
                    try {
                        tg.getUncaughtThread().join(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new MultithreadedTestError("After the test threw an exception and died, the join operation with the test thread was interrupted (probably a bug in Concutest-JUnit)", e);
                    }
                }
                if (tg.getUncaughtException() != null) {
                    Throwable tgException = tg.getUncaughtException();
                    if (tgException instanceof TestCase.WrappedException) {
                        tgException = tgException.getCause();
                    }
                    if (tgException != null) {
                        try {
                            TestThreadGroup.extendStackTrace(tgException, tg.getUncaughtThread());
                        }
                        catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                            // empty catch block
                        }
                    }
                    throw tgException;
                }
                if (!this.fCheckJoin) break block29;
                Thread[] alive = TestThreadGroup.checkThreadsAlive(tg, t);
                if (alive.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.fMethod.getName());
                    sb.append(": The test did not perform a join on all spawned threads.");
                    try {
                        String cc = TestThreadGroup.getThreadStartStackTrace(alive[0]);
                        throw new NoJoinError(sb.toString(), cc);
                    }
                    catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                        throw new NoJoinError(sb.toString());
                    }
                }
                if (!this.fCheckLucky) break block29;
                try {
                    HashSet<Thread> threadsStarted = TestThreadGroup.collectThreads(t, "threadsStarted");
                    HashSet<Thread> threadsJoined = TestThreadGroup.collectThreads(t, "threadsJoined");
                    for (Thread ct : threadsStarted) {
                        if (!TestThreadGroup.shouldIgnoreThread(ct)) continue;
                        HashSet<Thread> threadsJoinedByIgnored = TestThreadGroup.collectThreads(ct, "threadsJoined");
                        threadsJoined.addAll(threadsJoinedByIgnored);
                    }
                    HashSet<Thread> threadsNotJoined = new HashSet<Thread>(threadsStarted);
                    threadsNotJoined.removeAll(threadsJoined);
                    HashSet<Thread> threadsInViolation = new HashSet<Thread>(threadsNotJoined);
                    for (Thread ct : threadsNotJoined) {
                        if (!TestThreadGroup.shouldIgnoreThread(ct)) continue;
                        threadsInViolation.remove(ct);
                    }
                    if (threadsInViolation.size() > 0) {
                        StringBuilder sb = new StringBuilder(this.fMethod.getName() + ": Some spawned threads ended before the test was over, but the test did not join with them:");
                        for (Thread ct : threadsInViolation) {
                            sb.append('\n');
                            sb.append(ct);
                            sb.append(":\n");
                            sb.append(TestThreadGroup.getThreadStartStackTrace(ct));
                        }
                        throw new LuckyError(sb.toString(), TestThreadGroup.getThreadStartStackTrace(threadsInViolation.iterator().next()));
                    }
                }
                catch (TestThreadGroup.LuckyWarningsDisabledException e) {
                    System.err.println("Disabled \"lucky\" warnings: " + e);
                }
            }
            finally {
                if (prevSunHandler != null) {
                    System.setProperty("sun.awt.exception.handler", prevSunHandler);
                } else {
                    System.setProperty("sun.awt.exception.handler", TestThreadGroup.DummyHandler.class.getName());
                }
            }
        }
    }
}

