/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.util.Types;
import java.util.Arrays;

public class LookupSwitchInstruction
extends AInstruction {
    protected int _defaultTarget;
    protected int[] _targets;
    protected int[] _keys;

    public LookupSwitchInstruction(int defaultTarget, int[] keys, int[] targets) {
        this._defaultTarget = defaultTarget;
        this._targets = targets;
        this._keys = keys;
    }

    public byte getOpcode() {
        return -85;
    }

    public int getBytecodeLength(int pc) {
        int pad = 3 - pc % 4;
        return pad + 9 + this._targets.length * 8;
    }

    public LookupSwitchInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        int[] branchTargets = Opcode.getBranchTargets(bytecode, pc, paddingPC);
        this._defaultTarget = lnt.getLineNumber(branchTargets[0]);
        int pad = 3 - paddingPC % 4;
        this._targets = new int[branchTargets.length - 1];
        this._keys = new int[branchTargets.length - 1];
        for (int i = 1; i < branchTargets.length; ++i) {
            this._targets[i - 1] = lnt.getLineNumber(branchTargets[i]);
            this._keys[i - 1] = Types.intFromBytes(bytecode, pc + pad + 1 + i * 8);
        }
    }

    public byte[] getBytecode(int pc, LineNumberTable lnt) {
        int pad = 3 - pc % 4;
        byte[] b = new byte[this.getBytecodeLength(pc)];
        b[0] = this.getOpcode();
        Types.bytesFromInt(lnt.getPC(this._defaultTarget) - pc, b, pad + 1);
        Types.bytesFromInt(this._targets.length, b, pad + 5);
        for (int i = 0; i < this._targets.length; ++i) {
            Types.bytesFromInt(this._keys[i], b, pad + 9 + i * 8);
            Types.bytesFromInt(lnt.getPC(this._targets[i]) - pc, b, pad + 13 + i * 8);
        }
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupSwitchInstruction)) {
            return false;
        }
        LookupSwitchInstruction lookupSwitchInstruction = (LookupSwitchInstruction)o;
        if (this._defaultTarget != lookupSwitchInstruction._defaultTarget) {
            return false;
        }
        if (!Arrays.equals(this._keys, lookupSwitchInstruction._keys)) {
            return false;
        }
        return Arrays.equals(this._targets, lookupSwitchInstruction._targets);
    }

    public int hashCode() {
        return this._defaultTarget;
    }

    public int[] getBranchTargets() {
        int[] bt = new int[this._targets.length + 1];
        bt[0] = this._defaultTarget;
        int i = 1;
        for (int t : this._targets) {
            bt[i++] = t;
        }
        return bt;
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != this._targets.length + 1) {
            throw new IllegalArgumentException("LOOKUPSWITCH has incorrect number of targets");
        }
        this._defaultTarget = branchTargets[0];
        for (int i = 1; i < branchTargets.length; ++i) {
            this._targets[i - 1] = branchTargets[i];
        }
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName((byte)-85));
        x.append(" default = ");
        x.append(this._defaultTarget);
        x.append(" n = ");
        x.append(this._targets.length);
        for (int i = 0; i < this._targets.length; ++i) {
            x.append(" (");
            x.append(this._keys[i]);
            x.append("->");
            x.append(this._targets[i]);
            x.append(")");
        }
        return x.toString();
    }
}

