/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.SourceFileAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldInfo {
    private short _accessFlags;
    private AUTFPoolInfo _name;
    private AUTFPoolInfo _descriptor;
    private ArrayList<AAttributeInfo> _attributes = new ArrayList();

    public FieldInfo(short accessFlags, AUTFPoolInfo name, AUTFPoolInfo descriptor, SourceFileAttributeInfo[] attributes) {
        this._accessFlags = accessFlags;
        this._name = name;
        this._descriptor = descriptor;
        if (attributes != null) {
            for (SourceFileAttributeInfo attr : attributes) {
                this._attributes.add(attr);
            }
        }
    }

    public FieldInfo(DataInputStream di, ConstantPool pool) throws IOException, ClassFormatError {
        this._accessFlags = di.readShort();
        this._name = ((APoolInfo)pool.get(di.readShort())).execute(CheckUTFVisitor.singleton(), null);
        this._descriptor = ((APoolInfo)pool.get(di.readShort())).execute(CheckUTFVisitor.singleton(), null);
        int count = di.readShort();
        for (int i = 0; i < count; ++i) {
            this._attributes.add(AAttributeInfo.read(di, pool));
        }
    }

    public void write(DataOutputStream dos, ConstantPool pool) throws IOException {
        dos.writeShort(this._accessFlags);
        dos.writeShort(pool.indexOf(this._name));
        dos.writeShort(pool.indexOf(this._descriptor));
        dos.writeShort(this._attributes.size());
        for (AAttributeInfo attr : this._attributes) {
            attr.write(dos);
        }
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(ClassFileTools.getAccessString(this._accessFlags));
        x.append(ClassFileTools.getTypeString(this._descriptor.toStringVerbose(), this._name.toStringVerbose()));
        if (this._attributes.size() != 0) {
            x.append(" = " + this._attributes.get(0).toString());
        }
        return x.toString();
    }

    public final String toString(ConstantPool pool) {
        StringBuilder x = new StringBuilder();
        x.append(ClassFileTools.getAccessString(this._accessFlags));
        String t = ClassFileTools.getTypeString(this._descriptor.toString(), this._name.toString());
        x.append(t);
        for (AAttributeInfo attr : this._attributes) {
            x.append(", " + attr);
        }
        return x.toString();
    }

    public short getAccessFlags() {
        return this._accessFlags;
    }

    public void setAccessFlags(short accessFlags) {
        this._accessFlags = accessFlags;
    }

    public AUTFPoolInfo getName() {
        return this._name;
    }

    public void setName(AUTFPoolInfo name) {
        this._name = name;
    }

    public AUTFPoolInfo getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(AUTFPoolInfo descriptor) {
        this._descriptor = descriptor;
    }

    public ArrayList<AAttributeInfo> getAttributes() {
        return this._attributes;
    }

    public AAttributeInfo getAttribute(String name) {
        if (0 == this._attributes.size()) {
            return null;
        }
        for (AAttributeInfo attr : this._attributes) {
            if (0 != name.compareTo(attr.getName().toString())) continue;
            return attr;
        }
        return null;
    }

    public void setAttributes(ArrayList<AAttributeInfo> attributes) {
        this._attributes = attributes;
    }
}

