/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.FieldInfo;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.ASingleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.InnerClassesAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.EmptyPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.UnicodePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.util.ILambda;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileTools {
    public static String getAccessString(short flags) {
        StringBuilder x = new StringBuilder();
        if (0 != (flags & 1)) {
            x.append("public ");
        }
        if (0 != (flags & 2)) {
            x.append("private ");
        }
        if (0 != (flags & 4)) {
            x.append("protected ");
        }
        if (0 != (flags & 8)) {
            x.append("static ");
        }
        if (0 != (flags & 0x10)) {
            x.append("final ");
        }
        if (0 != (flags & 0x20)) {
            x.append("synchronized ");
        }
        if (0 != (flags & 0x40)) {
            x.append("volatile ");
        }
        if (0 != (flags & 0x80)) {
            x.append("transient ");
        }
        if (0 != (flags & 0x100)) {
            x.append("native ");
        }
        if (0 != (flags & 0x200)) {
            x.append("interface ");
        }
        if (0 != (flags & 0x400)) {
            x.append("abstract ");
        }
        if (0 != (flags & 0x800)) {
            x.append("strictfp ");
        }
        return x.toString();
    }

    public static String getTypeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuilder x = new StringBuilder();
        while ('[' == typeString.charAt(ndx)) {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x.append("byte");
                break;
            }
            case 'C': {
                x.append("char");
                break;
            }
            case 'D': {
                x.append("double");
                break;
            }
            case 'F': {
                x.append("float");
                break;
            }
            case 'I': {
                x.append("int");
                break;
            }
            case 'J': {
                x.append("long");
                break;
            }
            case 'L': {
                for (int i = ndx + 1; i < typeString.indexOf(59); ++i) {
                    if ('/' != typeString.charAt(i)) {
                        x.append(typeString.charAt(i));
                        continue;
                    }
                    x.append('.');
                }
                break;
            }
            case 'V': {
                x.append("void");
                break;
            }
            case 'S': {
                x.append("short");
                break;
            }
            case 'Z': {
                x.append("boolean");
            }
        }
        while (0 < isArray) {
            x.append("[]");
            --isArray;
        }
        x.append(' ');
        x.append(varName);
        return x.toString();
    }

    public static char getPrimitiveTypeChar(String primTypeName) {
        if (primTypeName.equals("void")) {
            return 'V';
        }
        if (primTypeName.equals("byte")) {
            return 'B';
        }
        if (primTypeName.equals("char")) {
            return 'C';
        }
        if (primTypeName.equals("double")) {
            return 'D';
        }
        if (primTypeName.equals("float")) {
            return 'F';
        }
        if (primTypeName.equals("int")) {
            return 'I';
        }
        if (primTypeName.equals("long")) {
            return 'J';
        }
        if (primTypeName.equals("short")) {
            return 'S';
        }
        if (primTypeName.equals("boolean")) {
            return 'Z';
        }
        return '\u0000';
    }

    public static boolean isPrimitive(String typeString) {
        int ndx = 0;
        while ('[' == typeString.charAt(ndx)) {
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static List<String> getSignatures(String sig) {
        ArrayList<String> sigList = new ArrayList<String>();
        if (sig != null) {
            while (sig.length() > 0) {
                String next = ClassFileTools.getNextSignature(sig);
                sigList.add(sig.substring(0, sig.length() - next.length()));
                sig = next;
            }
        }
        return sigList;
    }

    public static String getNextSignature(String sig) {
        int ndx = 0;
        while ('[' == sig.charAt(ndx)) {
            ++ndx;
        }
        if ('L' == sig.charAt(ndx)) {
            while (';' != sig.charAt(ndx)) {
                ++ndx;
            }
        }
        String x = sig.substring(++ndx);
        return x;
    }

    public static String getClassName(String s) {
        if ('[' == s.charAt(0)) {
            return ClassFileTools.getTypeString(s, "");
        }
        return s.replace('/', '.');
    }

    public static Set<String> getClassNamesUsed(String s) {
        HashSet<String> set = new HashSet<String>();
        char ch = s.charAt(0);
        if ('[' == ch) {
            if ('L' == s.charAt(1)) {
                set.addAll(ClassFileTools.getClassNamesUsed(s.substring(1, s.indexOf(59) + 1)));
            }
        } else if ('(' == ch) {
            String p = s.substring(1, s.indexOf(41));
            while (0 != p.length()) {
                String next = ClassFileTools.getNextSignature(p);
                String param = p.substring(0, p.length() - next.length());
                set.addAll(ClassFileTools.getClassNamesUsed(param));
                p = next;
            }
            p = s.substring(s.indexOf(41) + 1);
            set.addAll(ClassFileTools.getClassNamesUsed(p));
        } else if ('L' == ch) {
            String p = s.substring(1, s.indexOf(59)).replace('/', '.');
            set.add(p);
        }
        return set;
    }

    public static Set<String> getClassNamesUsed(ClassFile cf) {
        ASingleAnnotationsAttributeInfo an;
        final HashSet<String> classesUsed = new HashSet<String>();
        for (APoolInfo cpi : cf.getConstantPool()) {
            if (cpi == cf.getThisClass() || cpi == cf.getSuperClass()) continue;
            cpi.execute(new ADefaultPoolInfoVisitor<Object, Object>(){

                @Override
                public Object nameAndTypeCase(NameAndTypePoolInfo host, Object param) {
                    String s = host.getDescriptor().toString();
                    if ('[' == s.charAt(0)) {
                        if ('L' != s.charAt(1)) {
                            return null;
                        }
                        s = s.substring(2);
                    }
                    classesUsed.addAll(ClassFileTools.getClassNamesUsed(s));
                    return null;
                }

                @Override
                public Object classCase(ClassPoolInfo host, Object param) {
                    String s = host.getName().toString();
                    if ('[' == s.charAt(0)) {
                        if ('L' != s.charAt(1)) {
                            return null;
                        }
                        s = s.substring(2);
                    }
                    if (s.endsWith(";")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    classesUsed.add(s.replace('/', '.'));
                    return null;
                }

                @Override
                public Object defaultCase(APoolInfo host, Object param) {
                    return null;
                }
            }, null);
        }
        classesUsed.add(cf.getThisClassName());
        classesUsed.add(cf.getSuperClassName());
        for (FieldInfo field : cf.getFields()) {
            classesUsed.addAll(ClassFileTools.getClassNamesUsed(field.getDescriptor().toString()));
        }
        for (MethodInfo method : cf.getMethods()) {
            classesUsed.addAll(ClassFileTools.getClassNamesUsed(method.getDescriptor().toString()));
        }
        AAttributeInfo attr = cf.getAttribute(InnerClassesAttributeInfo.getAttributeName());
        if (null != attr) {
            InnerClassesAttributeInfo ic = (InnerClassesAttributeInfo)attr;
            for (InnerClassesAttributeInfo.InnerClassesRecord innerClassesRecord : ic.getInnerClasses()) {
                innerClassesRecord.innerClass.execute(new ADefaultPoolInfoVisitor<Object, Object>(){

                    @Override
                    public Object defaultCase(APoolInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public String emptyCase(EmptyPoolInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public String classCase(ClassPoolInfo host, Object param) {
                        classesUsed.add(ClassFileTools.getClassName(host.getName().toString()));
                        return null;
                    }
                }, null);
                innerClassesRecord.outerClass.execute(new ADefaultPoolInfoVisitor<Object, Object>(){

                    @Override
                    public Object defaultCase(APoolInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public String emptyCase(EmptyPoolInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public String classCase(ClassPoolInfo host, Object param) {
                        classesUsed.add(ClassFileTools.getClassName(host.getName().toString()));
                        return null;
                    }
                }, null);
            }
        }
        if (null != (attr = cf.getAttribute(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()))) {
            an = (RuntimeInvisibleAnnotationsAttributeInfo)attr;
            for (AAnnotationsAttributeInfo.Annotation annotation : an.getAnnotations()) {
                ClassFileTools.processAnnotation(annotation, classesUsed);
            }
        }
        if (null != (attr = cf.getAttribute(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName()))) {
            an = (RuntimeVisibleAnnotationsAttributeInfo)attr;
            for (AAnnotationsAttributeInfo.Annotation annotation : an.getAnnotations()) {
                ClassFileTools.processAnnotation(annotation, classesUsed);
            }
        }
        return classesUsed;
    }

    private static void processAnnotation(AAnnotationsAttributeInfo.Annotation a, HashSet<String> classesUsed) {
        classesUsed.add(ClassFileTools.getTypeString(a.getType(), "").trim());
        for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : a.getPairs()) {
            AAnnotationsAttributeInfo.Annotation.AMemberValue mv = nvp.getValue();
            ClassFileTools.processMemberValue(mv, classesUsed);
        }
    }

    private static void processMemberValue(AAnnotationsAttributeInfo.Annotation.AMemberValue mv, final HashSet<String> classesUsed) {
        mv.execute(new AAnnotationsAttributeInfo.Annotation.IMemberValueVisitor<Object, Object>(){

            @Override
            public Object constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object param) {
                host.getConstValue().execute(new ADefaultPoolInfoVisitor<Object, Object>(){

                    @Override
                    public Object unicodeCase(UnicodePoolInfo host, Object param) {
                        classesUsed.addAll(ClassFileTools.getClassNamesUsed("java.lang.String"));
                        return null;
                    }

                    @Override
                    public Object asciizCase(ASCIIPoolInfo host, Object param) {
                        classesUsed.add("java.lang.String");
                        return null;
                    }

                    @Override
                    public Object defaultCase(APoolInfo host, Object param) {
                        return null;
                    }
                }, null);
                return null;
            }

            @Override
            public Object enumMemberCase(AAnnotationsAttributeInfo.Annotation.EnumMemberValue host, Object param) {
                classesUsed.add(ClassFileTools.getTypeString(host.getTypeName().toString(), "").trim());
                return null;
            }

            @Override
            public Object classMemberCase(AAnnotationsAttributeInfo.Annotation.ClassMemberValue host, Object param) {
                classesUsed.add("java.lang.Class");
                classesUsed.add(ClassFileTools.getTypeString(host.getClassName().toString(), "").trim());
                return null;
            }

            @Override
            public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object param) {
                classesUsed.add("java.lang.annotation.Annotation");
                ClassFileTools.processAnnotation(host.getAnnotation(), classesUsed);
                return null;
            }

            @Override
            public Object arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object param) {
                for (AAnnotationsAttributeInfo.Annotation.AMemberValue mv : host.getEntries()) {
                    ClassFileTools.processMemberValue(mv, classesUsed);
                }
                return null;
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ClassLocation findClassFile(String className, List<String> classPath) {
        for (String pathStr : classPath) {
            InputStream stream;
            File path = new File(pathStr);
            if (path.isFile()) {
                if (pathStr.toLowerCase().endsWith(".class")) {
                    FileInputStream stream2 = null;
                    try {
                        stream2 = new FileInputStream(path);
                        ClassFile cf = new ClassFile(stream2);
                        if (!cf.getThisClassName().equals(className)) continue;
                        ClassLocation classLocation = new ClassLocation(className, cf, new FileInputStream(path), path);
                        return classLocation;
                    }
                    catch (ClassFormatError e) {}
                    continue;
                    catch (IOException e) {}
                    continue;
                    finally {
                        if (stream2 == null) continue;
                        try {
                            stream2.close();
                            continue;
                        }
                        catch (IOException e1) {}
                    }
                }
                if (!pathStr.toLowerCase().endsWith(".jar")) continue;
                JarFile jf = null;
                stream = null;
                try {
                    jf = new JarFile(path);
                    JarEntry je = jf.getJarEntry(className.replace('.', '/') + ".class");
                    if (null != je) {
                        stream = jf.getInputStream(je);
                        ClassFile cf = new ClassFile(stream);
                        if (cf.getThisClassName().equals(className)) {
                            ClassLocation classLocation = new ClassLocation(className, cf, jf.getInputStream(je), path, jf);
                            return classLocation;
                        }
                        jf.close();
                        continue;
                    }
                    if (jf == null) continue;
                    try {
                        jf.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    continue;
                }
                catch (IOException e) {
                    if (jf == null) continue;
                    try {
                        jf.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    continue;
                }
                catch (ClassFormatError e) {
                    if (jf == null) continue;
                    try {
                        jf.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    continue;
                }
                finally {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {}
                    continue;
                }
            }
            File classFile = new File(path, className.replace('.', '/') + ".class");
            if (!classFile.isFile()) continue;
            stream = null;
            try {
                stream = new FileInputStream(classFile);
                ClassFile cf = new ClassFile(stream);
                if (!cf.getThisClassName().equals(className)) continue;
                ClassLocation e1 = new ClassLocation(className, cf, new FileInputStream(classFile), classFile);
                return e1;
            }
            catch (IOException e) {}
            continue;
            catch (ClassFormatError e) {}
            continue;
            finally {
                try {
                    ((FileInputStream)stream).close();
                }
                catch (IOException e1) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDependencyFixPoint(Set<String> classNames, List<String> classPath, Set<String> classesUsed, ILambda<Object, ClassLocation> processClassNameLambda, ILambda<Object, String> processNotFoundLambda) {
        LinkedList<String> bfQueue = new LinkedList<String>();
        for (String className : classNames) {
            bfQueue.add(className);
            while (!bfQueue.isEmpty()) {
                String curClassName = (String)bfQueue.remove();
                ClassLocation cl = null;
                try {
                    cl = ClassFileTools.findClassFile(curClassName, classPath);
                    if (null != cl && !classesUsed.contains(curClassName)) {
                        processClassNameLambda.apply(cl);
                    }
                    classesUsed.add(curClassName);
                    if (null == cl) {
                        processNotFoundLambda.apply(curClassName);
                        continue;
                    }
                    try {
                        ClassFile cf = new ClassFile(cl.getInputStream());
                        Set<String> newClasses = ClassFileTools.getClassNamesUsed(cf);
                        for (String c : newClasses) {
                            if (classesUsed.contains(c) || bfQueue.contains(c)) continue;
                            bfQueue.add(c);
                        }
                    }
                    catch (IOException e) {
                        processNotFoundLambda.apply(curClassName);
                    }
                    catch (ClassFormatError classFormatError) {
                        processNotFoundLambda.apply(curClassName);
                    }
                }
                finally {
                    try {
                        if (cl == null) continue;
                        cl.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public Set<String> getDependencyFixPoint(Set<String> classNames, List<String> classPath) {
        HashSet<String> classesUsed = new HashSet<String>();
        ClassFileTools.generateDependencyFixPoint(classNames, classPath, classesUsed, new ILambda<Object, ClassLocation>(){

            @Override
            public Object apply(ClassLocation param) {
                return null;
            }
        }, new ILambda<Object, String>(){

            @Override
            public Object apply(String param) {
                return null;
            }
        });
        return classesUsed;
    }

    public static ClassFile findClassInFiles(String className, Set<String> filesToConsider) {
        ClassFile cf = null;
        for (String name : filesToConsider) {
            try {
                if (name.endsWith(".jar")) {
                    JarFile jf = new JarFile(name);
                    JarEntry je = jf.getJarEntry(className + ".class");
                    if (je == null) continue;
                    return ClassFileTools.loadClassFromStream(jf.getInputStream(je));
                }
                String fileName = name + File.separatorChar + className + ".class";
                File f = new File(fileName = fileName.replace('/', File.separatorChar));
                if (!f.exists() || !f.isFile()) continue;
                return ClassFileTools.loadClassFromStream(new FileInputStream(f));
            }
            catch (IOException e) {
            }
        }
        return cf;
    }

    public static ClassFile loadClassFromStream(InputStream is) throws IOException {
        int bytesRead;
        byte[] b = new byte[is.available()];
        for (int offset = 0; offset < b.length && (bytesRead = is.read(b, offset, b.length - offset)) != -1; offset += bytesRead) {
        }
        is.close();
        return new ClassFile(new ByteArrayInputStream(b));
    }

    public static boolean classNameMatches(String className, String ... classNamePatterns) {
        boolean matchFound = false;
        for (String pattern : classNamePatterns) {
            boolean negate = false;
            String regex = pattern;
            if (regex.indexOf(33) == 0) {
                negate = true;
                regex = regex.substring(1);
            }
            regex = regex.replaceAll("\\.", "\\\\.");
            regex = regex.replaceAll("\\?", ".");
            regex = regex.replaceAll("\\$", "\\\\\\$");
            regex = regex.replaceAll("\\(", "\\\\(");
            regex = regex.replaceAll("\\)", "\\\\)");
            regex = regex.replaceAll("\\*\\*\\*", ".`");
            regex = regex.replaceAll("^\\*\\*\\*", ".`");
            regex = regex.replaceAll("\\*", "[^\\.]*");
            regex = regex.replaceAll("\\.`", ".*");
            regex = "^" + regex + "$";
            boolean matches = className.matches(regex);
            if (!matches) continue;
            if (negate) {
                return false;
            }
            matchFound = true;
        }
        return matchFound;
    }

    public static Class<?> getClassFromType(String type) throws ClassNotFoundException {
        if (type.equals("I")) {
            return Integer.TYPE;
        }
        if (type.equals("J")) {
            return Long.TYPE;
        }
        if (type.equals("F")) {
            return Float.TYPE;
        }
        if (type.equals("D")) {
            return Double.TYPE;
        }
        if (type.equals("B")) {
            return Byte.TYPE;
        }
        if (type.equals("C")) {
            return Character.TYPE;
        }
        if (type.equals("S")) {
            return Short.TYPE;
        }
        if (type.equals("Z")) {
            return Boolean.TYPE;
        }
        String tn = type.substring(1, type.length() - 1).replace('/', '.');
        return Class.forName(tn);
    }

    public static Class<?> getClassFromType(String type, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (type.equals("I")) {
            return Integer.TYPE;
        }
        if (type.equals("J")) {
            return Long.TYPE;
        }
        if (type.equals("F")) {
            return Float.TYPE;
        }
        if (type.equals("D")) {
            return Double.TYPE;
        }
        if (type.equals("B")) {
            return Byte.TYPE;
        }
        if (type.equals("C")) {
            return Character.TYPE;
        }
        if (type.equals("S")) {
            return Short.TYPE;
        }
        if (type.equals("Z")) {
            return Boolean.TYPE;
        }
        String tn = type.substring(1, type.length() - 1).replace('/', '.');
        return Class.forName(tn, initialize, loader);
    }

    public static String getClassNameFromType(String type) {
        if (type.equals("I")) {
            return "int";
        }
        if (type.equals("J")) {
            return "long";
        }
        if (type.equals("F")) {
            return "float";
        }
        if (type.equals("D")) {
            return "double";
        }
        if (type.equals("B")) {
            return "byte";
        }
        if (type.equals("C")) {
            return "char";
        }
        if (type.equals("S")) {
            return "short";
        }
        if (type.equals("Z")) {
            return "boolean";
        }
        if (type.charAt(0) == '[') {
            return type.replace('/', '.');
        }
        return type.substring(1, type.length() - 1).replace('/', '.');
    }

    public static class ClassFileToolsTest
    extends TestCase {
        public void testClassNameMatches() {
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Number", "java.*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.Number", "java.***"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Number", "*java*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.Number", "***java***"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.Number", "java.lang.Number"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Number", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Number", "lang.***"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Number", "java.***", "sun.management.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("sun.Foobar", "java.***", "sun.management.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("sun.management.Foobar", "java.***", "sun.management.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.Foobar", "java.***", "sun.management.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.util.Foobar", "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.util.concurrent.Foobar", "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.util.logging.Foobar", "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.util.foobar.Foobar", "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java/util/Foobar", "java/util/*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.util.foo.Foobar", "java.util.*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.util.foo.Foobar", "java.util.foo.[a-mA-M]*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.util.foo.Foobar", "java.util.foo.[n-zN-Z]*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.util.AbstractCollection", "java.util.*Collection*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.ref.Reference$1", "java.lang.ref.Reference$*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.ref.ReferenceQueue", "java.lang.ref.Reference$*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("edu.rice.cs.cunit.instrumentors.replay.CompactSynchronizedBlockReplayStrategy", "***Synchronized*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("anything", ""));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("anything", new String[0]));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.Integer", "***", "!java.lang.Object", "!java.lang.String", "!java.util.zip.*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.Object", "***", "!java.lang.Object", "!java.lang.String", "!java.util.zip.*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.lang.String", "***", "!java.lang.Object", "!java.lang.String", "!java.util.zip.*"));
            ClassFileToolsTest.assertEquals(false, ClassFileTools.classNameMatches("java.util.zip.Inflater", "***", "!java.lang.Object", "!java.lang.String", "!java.util.zip.*"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("loadClass(Ljava/lang/String;Z)Ljava/lang/Class;", "loadClass(Ljava/lang/String;Z)Ljava/lang/Class;"));
            ClassFileToolsTest.assertEquals(true, ClassFileTools.classNameMatches("java.lang.ref.Finalizer$FinalizerThread", "java.lang.ref.Finalizer$FinalizerThread"));
        }
    }

    public static class ClassLocation {
        private final String _className;
        private final InputStream _inputStream;
        private final File _file;
        private final ClassFile _cf;
        private final JarFile _jarFile;

        public ClassLocation(String className, ClassFile cf, InputStream inputStream, File file) {
            this(className, cf, inputStream, file, null);
        }

        public ClassLocation(String className, ClassFile cf, InputStream inputStream, File file, JarFile jarFile) {
            this._className = className;
            this._inputStream = inputStream;
            this._file = file;
            this._jarFile = jarFile;
            this._cf = cf;
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        public File getFile() {
            return this._file;
        }

        public String getClassName() {
            return this._className;
        }

        public JarFile getJarFile() {
            return this._jarFile;
        }

        public ClassFile getClassFile() {
            return this._cf;
        }

        public void close() throws IOException {
            if (this._inputStream != null) {
                this._inputStream.close();
            }
            if (this._jarFile != null) {
                this._jarFile.close();
            }
        }
    }
}

