/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.AbstractTypeChecker;
import koala.dynamicjava.interpreter.EvaluationVisitor;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.context.AbstractVariable;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.context.MethodContext;
import koala.dynamicjava.interpreter.context.StaticContext;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeInterpreter
implements Interpreter {
    protected ParserFactory parserFactory;
    protected LibraryFinder libraryFinder = new LibraryFinder();
    protected TreeClassLoader classLoader;
    protected static Map<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
    List<String> localMethods = new LinkedList<String>();
    protected static Map<String, ConstructorParametersDescriptor> constructorParameters = new HashMap<String, ConstructorParametersDescriptor>();
    List<String> localConstructorParameters = new LinkedList<String>();
    protected static int nClass;
    protected Context nameVisitorContext;
    protected Context checkVisitorContext;
    protected Context evalVisitorContext;
    protected boolean accessible;
    static /* synthetic */ Class class$koala$dynamicjava$interpreter$error$CatchedExceptionError;

    public TreeInterpreter(ParserFactory pf) {
        this(pf, null);
    }

    public TreeInterpreter(ParserFactory pf, ClassLoader cl) {
        this.parserFactory = pf;
        this.classLoader = new TreeClassLoader(this, cl);
        this.nameVisitorContext = new GlobalContext(this);
        this.nameVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.checkVisitorContext = new GlobalContext(this);
        this.checkVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.evalVisitorContext = new GlobalContext(this);
        this.evalVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
    }

    @Override
    public Object interpret(Reader r, String fname) throws InterpreterException {
        try {
            SourceCodeParser p = this.parserFactory.createParser(r, fname);
            List<Node> statements = p.parseStream();
            ListIterator<Node> it = statements.listIterator();
            Object result = null;
            while (it.hasNext()) {
                Node n = it.next();
                result = this.interpret(n);
            }
            return result;
        }
        catch (ExecutionError e) {
            throw new InterpreterException(e);
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    @Override
    public Object interpret(InputStream is, String fname) throws InterpreterException {
        return this.interpret(new InputStreamReader(is), fname);
    }

    @Override
    public Object interpret(String fname) throws InterpreterException, IOException {
        return this.interpret(new FileReader(fname), fname);
    }

    public List<Node> buildStatementList(Reader r, String fname) throws InterpreterException {
        try {
            SourceCodeParser p = this.parserFactory.createParser(r, fname);
            List<Node> statements = p.parseStream();
            ListIterator<Node> it = statements.listIterator();
            ArrayList<Node> resultingList = new ArrayList<Node>();
            while (it.hasNext()) {
                NameVisitor nv;
                Node n = it.next();
                Node o = n.acceptVisitor(nv = new NameVisitor(this.nameVisitorContext, this.checkVisitorContext));
                if (o != null) {
                    n = o;
                }
                resultingList.add(n);
                AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(this.checkVisitorContext);
                n.acceptVisitor(tc);
                this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
            }
            return resultingList;
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    public Object interpret(List<Node> statements) throws InterpreterException {
        try {
            ListIterator<Node> it = statements.listIterator();
            Object result = null;
            while (it.hasNext()) {
                Node n = it.next();
                EvaluationVisitor ev = new EvaluationVisitor(this.evalVisitorContext);
                result = n.acceptVisitor(ev);
            }
            return result;
        }
        catch (ExecutionError e) {
            throw new InterpreterException(e);
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    public void defineVariable(String name, Object value, Class<?> c) {
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, value);
    }

    @Override
    public void defineVariable(String name, Object value) {
        this.defineVariable(name, value, value == null ? null : value.getClass());
    }

    public void defineVariable(String name, boolean value) {
        Class<Boolean> c = Boolean.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Boolean(value));
    }

    public void defineVariable(String name, byte value) {
        Class<Byte> c = Byte.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Byte(value));
    }

    public void defineVariable(String name, short value) {
        Class<Short> c = Short.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Short(value));
    }

    public void defineVariable(String name, char value) {
        Class<Character> c = Character.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Character(value));
    }

    public void defineVariable(String name, int value) {
        Class<Integer> c = Integer.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Integer(value));
    }

    public void defineVariable(String name, long value) {
        Class<Long> c = Long.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Long(value));
    }

    public void defineVariable(String name, float value) {
        Class<Float> c = Float.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Float(value));
    }

    public void defineVariable(String name, double value) {
        Class<Double> c = Double.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Double(value));
    }

    @Override
    public void setVariable(String name, Object value) {
        Class c = (Class)this.checkVisitorContext.get(name);
        if (!InterpreterUtilities.isValidAssignment(c, value)) {
            throw new IllegalStateException(name);
        }
        this.evalVisitorContext.set(name, value);
    }

    @Override
    public Object getVariable(String name) {
        return this.evalVisitorContext.get(name);
    }

    @Override
    public Class<?> getVariableClass(String name) {
        return (Class)this.checkVisitorContext.get(name);
    }

    @Override
    public Set getVariableNames() {
        return this.evalVisitorContext.getCurrentScopeVariableNames();
    }

    @Override
    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
        this.nameVisitorContext.setAccessible(accessible);
        this.checkVisitorContext.setAccessible(accessible);
        this.evalVisitorContext.setAccessible(accessible);
    }

    @Override
    public boolean getAccessible() {
        return this.accessible;
    }

    @Override
    public Set getClassNames() {
        return this.classLoader.getClassNames();
    }

    @Override
    public void addClassPath(String path) {
        try {
            this.classLoader.addURL(new File(path).toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void addClassURL(URL url) {
        this.classLoader.addURL(url);
    }

    @Override
    public void addLibraryPath(String path) {
        this.libraryFinder.addPath(path);
    }

    @Override
    public void addLibrarySuffix(String s) {
        this.libraryFinder.addSuffix(s);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return new TreeCompiler(this).compile(name);
    }

    @Override
    public Class<?> defineClass(String name, byte[] code) {
        return this.classLoader.defineClass(name, code);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public LibraryFinder getLibraryFinder() {
        return this.libraryFinder;
    }

    @Override
    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public Class<?> getExceptionClass() {
        return class$koala$dynamicjava$interpreter$error$CatchedExceptionError == null ? (class$koala$dynamicjava$interpreter$error$CatchedExceptionError = TreeInterpreter.class$("koala.dynamicjava.interpreter.error.CatchedExceptionError")) : class$koala$dynamicjava$interpreter$error$CatchedExceptionError;
    }

    public void registerMethod(String sig, MethodDeclaration md, ImportationManager im) {
        this.localMethods.add(sig);
        methods.put(sig, new MethodDescriptor(md, im));
    }

    public static Object invokeMethod(String key, Object obj, Object[] params) {
        MethodDescriptor md = methods.get(key);
        Class<?> c = null;
        try {
            c = Class.forName(key.substring(0, key.lastIndexOf(35)), true, md.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return md.interpreter.interpretMethod(c, md, obj, params);
    }

    protected Object interpretMethod(Class<?> c, MethodDescriptor md, Object obj, Object[] params) {
        MethodDeclaration meth = md.method;
        List<FormalParameter> mparams = meth.getParameters();
        List<Node> stmts = meth.getBody().getStatements();
        String name = meth.getName();
        StaticContext context = null;
        if (Modifier.isStatic(md.method.getAccessFlags())) {
            if (md.variables == null) {
                md.importationManager.setClassLoader(this.classLoader);
                StaticContext ctx = new StaticContext((Interpreter)this, c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                NameVisitor nv = new NameVisitor(ctx, this.checkVisitorContext);
                ListIterator<FormalParameter> it1 = mparams.listIterator();
                while (it1.hasNext()) {
                    it1.next().acceptVisitor(nv);
                }
                Iterator<Node> it2 = stmts.listIterator();
                while (it2.hasNext()) {
                    Node o = ((Node)it2.next()).acceptVisitor(nv);
                    if (o == null) continue;
                    it2.set(o);
                }
                ctx = new StaticContext((Interpreter)this, c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(ctx);
                it1 = mparams.listIterator();
                while (it1.hasNext()) {
                    it1.next().acceptVisitor(tc);
                }
                it2 = stmts.listIterator();
                while (it2.hasNext()) {
                    ((Node)it2.next()).acceptVisitor(tc);
                }
                md.variables = ctx.getCurrentScopeVariables();
                if (!name.equals("<clinit>") && !name.equals("<init>")) {
                    try {
                        md.contextField = c.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
            }
            context = new StaticContext((Interpreter)this, c, md.variables);
        } else {
            if (md.variables == null) {
                md.importationManager.setClassLoader(this.classLoader);
                MethodContext ctx1 = new MethodContext((Interpreter)this, c, c, md.importationManager);
                ctx1.setAdditionalClassLoaderContainer(this.classLoader);
                NameVisitor nv1 = new NameVisitor(ctx1, this.checkVisitorContext);
                MethodContext ctx2 = new MethodContext((Interpreter)this, c, c, md.importationManager);
                ctx2.setAdditionalClassLoaderContainer(this.classLoader);
                NameVisitor nv2 = new NameVisitor(ctx2, this.checkVisitorContext);
                Object[][] cc = null;
                try {
                    Field f = c.getField("local$Variables$Class$0");
                    cc = (Object[][])f.get(obj);
                    for (int i = 0; i < cc.length; ++i) {
                        Object[] cell = cc[i];
                        if (((String)cell[0]).equals("this")) continue;
                        ctx1.defineConstant((String)cell[0], cell[1]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ListIterator<FormalParameter> it1 = mparams.listIterator();
                while (it1.hasNext()) {
                    it1.next().acceptVisitor(nv1);
                }
                ListIterator<Node> it2 = stmts.listIterator();
                while (it2.hasNext()) {
                    Node n = it2.next();
                    Node o = null;
                    o = n.hasProperty("instanceInitializer") ? n.acceptVisitor(nv2) : n.acceptVisitor(nv1);
                    if (o == null) continue;
                    it2.set(o);
                }
                ctx1 = new MethodContext((Interpreter)this, c, c, md.importationManager);
                ctx1.setAdditionalClassLoaderContainer(this.classLoader);
                AbstractTypeChecker tc1 = AbstractTypeChecker.makeTypeChecker(ctx1);
                ctx2 = new MethodContext((Interpreter)this, c, c, md.importationManager);
                ctx2.setAdditionalClassLoaderContainer(this.classLoader);
                AbstractTypeChecker tc2 = AbstractTypeChecker.makeTypeChecker(ctx2);
                if (cc != null) {
                    for (int i = 0; i < cc.length; ++i) {
                        Object[] cell = cc[i];
                        if (((String)cell[0]).equals("this")) continue;
                        ctx1.defineConstant((String)cell[0], cell[1]);
                    }
                }
                it1 = mparams.listIterator();
                while (it1.hasNext()) {
                    it1.next().acceptVisitor(tc1);
                }
                it2 = stmts.listIterator();
                while (it2.hasNext()) {
                    Node n = it2.next();
                    if (n.hasProperty("instanceInitializer")) {
                        n.acceptVisitor(tc2);
                        continue;
                    }
                    n.acceptVisitor(tc1);
                }
                md.variables = ctx1.getCurrentScopeVariables();
                if (!name.equals("<clinit>") && !name.equals("<init>")) {
                    try {
                        md.contextField = c.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
            }
            context = new MethodContext((Interpreter)this, c, obj, md.variables);
        }
        context.setAdditionalClassLoaderContainer(this.classLoader);
        Iterator<FormalParameter> it1 = mparams.iterator();
        int i = 0;
        while (it1.hasNext()) {
            context.set(it1.next().getName(), params[i++]);
        }
        if (md.contextField != null) {
            Map vars = null;
            try {
                vars = (Map)md.contextField.get(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (vars != null) {
                for (String s : vars.keySet()) {
                    if (s.equals("this")) continue;
                    context.setConstant(s, vars.get(s));
                }
            }
        }
        EvaluationVisitor ev = new EvaluationVisitor(context);
        Iterator<Node> it3 = stmts.iterator();
        try {
            while (it3.hasNext()) {
                it3.next().acceptVisitor(ev);
            }
        }
        catch (ReturnException e) {
            return e.getValue();
        }
        return null;
    }

    public void registerConstructorArguments(String sig, List<FormalParameter> params, List<Expression> exprs, ImportationManager im) {
        this.localConstructorParameters.add(sig);
        constructorParameters.put(sig, new ConstructorParametersDescriptor(params, exprs, im));
    }

    public static Object[] interpretArguments(String key, Object[] args) {
        ConstructorParametersDescriptor cpd = constructorParameters.get(key);
        Class<?> c = null;
        try {
            c = Class.forName(key.substring(0, key.lastIndexOf(35)), true, cpd.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return cpd.interpreter.interpretArguments(c, cpd, args);
    }

    protected Object[] interpretArguments(Class<?> c, ConstructorParametersDescriptor cpd, Object[] args) {
        ListIterator<Node> it;
        StaticContext ctx;
        if (cpd.variables == null) {
            cpd.importationManager.setClassLoader(this.classLoader);
            ctx = new StaticContext((Interpreter)this, c, cpd.importationManager);
            ctx.setAdditionalClassLoaderContainer(this.classLoader);
            NameVisitor nv = new NameVisitor(ctx, this.checkVisitorContext);
            AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(ctx);
            if (cpd.parameters != null) {
                it = cpd.parameters.listIterator();
                while (it.hasNext()) {
                    ((FormalParameter)it.next()).acceptVisitor(tc);
                }
            }
            if (cpd.arguments != null) {
                it = cpd.arguments.listIterator();
                while (it.hasNext()) {
                    Expression root = (Expression)it.next();
                    Node res = root.acceptVisitor(nv);
                    if (res == null) continue;
                    it.set((Expression)res);
                }
                it = cpd.arguments.listIterator();
                while (it.hasNext()) {
                    ((Expression)it.next()).acceptVisitor(tc);
                }
            }
            cpd.variables = ctx.getCurrentScopeVariables();
        }
        ctx = new StaticContext((Interpreter)this, c, cpd.variables);
        ctx.setAdditionalClassLoaderContainer(this.classLoader);
        if (cpd.parameters != null) {
            Iterator<FormalParameter> it2 = cpd.parameters.iterator();
            int i = 0;
            while (it2.hasNext()) {
                ctx.set(it2.next().getName(), args[i++]);
            }
        }
        Object[] result = new Object[]{};
        if (cpd.arguments != null) {
            EvaluationVisitor ev = new EvaluationVisitor(ctx);
            it = cpd.arguments.listIterator();
            result = new Object[cpd.arguments.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = ((Expression)it.next()).acceptVisitor(ev);
            }
        }
        return result;
    }

    protected void finalize() throws Throwable {
        Iterator<String> it = this.localMethods.iterator();
        while (it.hasNext()) {
            methods.remove(it.next());
        }
        it = this.localConstructorParameters.iterator();
        while (it.hasNext()) {
            constructorParameters.remove(it.next());
        }
    }

    public Object interpret(Node AST) throws InterpreterException {
        NameVisitor nv = new NameVisitor(this.nameVisitorContext, this.checkVisitorContext);
        Node o = AST.acceptVisitor(nv);
        if (o != null) {
            AST = o;
        }
        AbstractTypeChecker tc = AbstractTypeChecker.makeTypeChecker(this.checkVisitorContext);
        AST.acceptVisitor(tc);
        this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
        EvaluationVisitor ev = new EvaluationVisitor(this.evalVisitorContext);
        return AST.acceptVisitor(ev);
    }

    @Override
    public List<Node> parse(String input) {
        StringReader r = new StringReader(input.trim());
        SourceCodeParser p = this.parserFactory.createParser(r, "DrJava");
        return p.parseStream();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstructorParametersDescriptor {
        Set<AbstractVariable> variables;
        List<FormalParameter> parameters;
        List<Expression> arguments;
        ImportationManager importationManager;
        TreeInterpreter interpreter;

        ConstructorParametersDescriptor(List<FormalParameter> params, List<Expression> args, ImportationManager im) {
            this.parameters = params;
            this.arguments = args;
            this.importationManager = im;
            this.interpreter = TreeInterpreter.this;
        }
    }

    protected class MethodDescriptor {
        Set<AbstractVariable> variables;
        MethodDeclaration method;
        ImportationManager importationManager;
        TreeInterpreter interpreter;
        Field contextField;

        MethodDescriptor(MethodDeclaration md, ImportationManager im) {
            this.method = md;
            this.importationManager = im;
            this.interpreter = TreeInterpreter.this;
        }
    }
}

